<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package multivas
 */

//Theme defaults and customizer selected values
$default = multivas_get_defaults();

$selected_posts_grid = get_theme_mod('multivas_posts_grid_settings', $default['multivas_posts_grid_settings']);
?>
<?php $classes = [
	'bg-light',
	'clearfix',
	'py-4',
	'px-5',
];
?>
<div class="<?php if ($selected_posts_grid == '1' || is_single()) : ?>col-lg-12<?php else : ?>col-lg-6<?php endif; ?>">
	<article id="post-<?php the_ID(); ?>" <?php post_class($classes); ?>>
		<header class="entry-header py-2">
			<?php
			if (is_singular()) :
				the_title('<h1 class="entry-title text-capitalize">', '</h1>');
			else :
				the_title('<h2 class="entry-title text-capitalize"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');
			endif;

			if ('post' === get_post_type()) :
			?>
				<div class="entry-meta my-2 small">
					<?php
					multivas_posted_on();
					multivas_posted_by();
					if (comments_open()) : ?>
						&nbsp;&nbsp;<span class="cooments-count"><i class="fa fa-commenting"></i>&nbsp;<?php echo get_comments_number(get_the_ID()); ?></span>
					<?php endif; ?>
					<span class="read-time float-end"><i class="fa fa-clock-o"></i>&nbsp;<?php echo multivas_reading_time(); ?></span>
				</div><!-- .entry-meta -->
			<?php endif; ?>
		</header><!-- .entry-header -->

		<?php the_post_thumbnail("full", ["class" => "img-fluid mt-2 mb-4 "]); ?>

		<?php if (is_singular()) : ?>
			<div class="entry-content">
				<?php
				the_content(
					sprintf(
						wp_kses(
							/* translators: %s: Name of current post. Only visible to screen readers */
							__('Continue reading<span class="screen-reader-text"> "%s"</span>', 'multivas'),
							array(
								'span' => array(
									'class' => array(),
								),
							)
						),
						wp_kses_post(get_the_title())
					)
				);

				wp_link_pages(
					array(
						'before' => '<div class="page-links">' . esc_html__('Pages:', 'multivas'),
						'after'  => '</div>',
					)
				);
				?>
			</div><!-- .entry-content -->
			<footer class="entry-footer my-3">
				<?php multivas_entry_footer(); ?>
			</footer><!-- .entry-footer -->
		<?php else : ?>
			<div class="entry-summary">
				<p>
					<?php echo get_the_excerpt(); ?>
				</p>
			</div><!-- .entry-summary -->
			<footer class="entry-footer my-3">
				<a href="<?php the_permalink(); ?>" class="readme float-end"><?php esc_html_e("Read More", "multivas"); ?>&nbsp;<i class="fa fa-long-arrow-right"></i></a>
				<?php multivas_entry_footer(); ?>
			</footer><!-- .entry-footer -->
		<?php endif; ?>
	</article><!-- #post-<?php the_ID(); ?> -->
</div>