<?php

/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package multivas
 */

//Theme defaults and customizer selected values
$default = multivas_get_defaults();

$selected_posts_grid = get_theme_mod('multivas_posts_grid_settings', $default['multivas_posts_grid_settings']);
?>
<?php $classes = [
	'bg-light',
	'clearfix',
	'py-4',
	'px-5',
];
?>
<div class="<?php if ($selected_posts_grid == '1') : ?>col-lg-12<?php else : ?>col-lg-6<?php endif; ?>">
	<article id="post-<?php the_ID(); ?>" <?php post_class($classes); ?>>
		<header class="entry-header py-2">
			<?php the_title(sprintf('<h2 class="entry-title text-capitalize"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h2>'); ?>

			<?php if ('post' === get_post_type()) : ?>
				<div class="entry-meta my-2 small">
					<?php
					multivas_posted_on();
					multivas_posted_by();
					?>
					&nbsp;&nbsp;<span class="cooments-count"><i class="fa fa-commenting"></i>&nbsp;<?php echo get_comments_number(get_the_ID()); ?></span>
					<span class="read-time float-end"><i class="fa fa-clock-o"></i>&nbsp;<?php echo multivas_reading_time(); ?></span>
				</div><!-- .entry-meta -->
			<?php endif; ?>
		</header><!-- .entry-header -->

		<?php the_post_thumbnail("full", ["class" => "img-fluid mt-2 mb-4"]); ?>

		<div class="entry-summary">
			<p>
				<?php echo get_the_excerpt(); ?>
			</p>
		</div><!-- .entry-summary -->
		<footer class="entry-footer my-3">
			<a href="<?php the_permalink(); ?>" class="readme float-end "><?php esc_html_e("Read More", "multivas"); ?>&nbsp;<i class="fa fa-long-arrow-right"></i></a>
			<?php multivas_entry_footer(); ?>
		</footer><!-- .entry-footer -->
	</article><!-- #post-<?php the_ID(); ?> -->
</div>