<?php

/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package multivas
 */

?>
<div class="container page-container mb-5">
	<div class="row">
		<div class="col-lg-12">
			<section class="no-results not-found bg-light pt-5 pb-5 px-5">
				<header class="page-header text-center">
					<h1 class="page-title text-capitalize pb-3"><?php esc_html_e('Nothing Found', 'multivas'); ?></h1>
				</header><!-- .page-header -->

				<div class="page-content">
					<?php
					if (is_home() && current_user_can('publish_posts')) :

						printf(
							'<p class="mb-3 text-center">' . wp_kses(
								/* translators: 1: link to WP admin new post page. */
								__('Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'multivas'),
								array(
									'a' => array(
										'href' => array(),
									),
								)
							) . '</p>',
							esc_url(admin_url('post-new.php'))
						);

					elseif (is_search()) :
					?>

						<p class="mb-3 text-center"><?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'multivas'); ?></p>
						<div class="text-center">
							<?php
							get_search_form(); ?>
						</div>
					<?php	
					else :
						?>
						<p class="mb-3 text-center"><?php esc_html_e('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'multivas'); ?></p>
						<div class="text-center">
							<?php
							get_search_form(); ?>
						</div>
					<?php
					endif;
						?>
				</div><!-- .page-content -->
			</section><!-- .no-results -->
		</div>
	</div>
</div>