<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package multivas
 */

get_header();

//Theme defaults and customizer selected values
$default = multivas_get_defaults();

$selected_blog_grid = get_theme_mod('multivas_blog_grid_settings', $default['multivas_blog_grid_settings']);
?>
<div class="container single-post-container mt-5">
	<div class="row g-5">
		<div class="<?php if ($selected_blog_grid == 'no') : ?>col-lg-12<?php else : ?>col-lg-9<?php endif; ?>">
			<main id="primary" class="site-main">

				<?php
				while (have_posts()) :
					the_post();

					get_template_part('template-parts/content', get_post_type());

					the_post_navigation(
						array(
							'prev_text' => '<span class="nav-subtitle">' . esc_html__('Previous:', 'multivas') . '</span> <span class="nav-title">%title</span>',
							'next_text' => '<span class="nav-subtitle">' . esc_html__('Next:', 'multivas') . '</span> <span class="nav-title">%title</span>',
						)
					);

					// If comments are open or we have at least one comment, load up the comment template.
					if (comments_open() || get_comments_number()) :
						comments_template();
					endif;

				endwhile; // End of the loop.
				?>

			</main><!-- #main -->
		</div>
		<?php if ($selected_blog_grid != 'no') : ?>
			<div class="col-lg-3">
				<?php get_sidebar(); ?>
			</div>
		<?php endif; ?>
	</div>
</div>
<?php get_footer();
