<?php

/**
 * WooCommerce - Single - Module - Upsell & Related - Customizer Settings
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'Multifox_Shop_Customizer_Single_Upsell_Related' ) ) {

    class Multifox_Shop_Customizer_Single_Upsell_Related {

        private static $_instance = null;

        public static function instance() {

            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;

        }

        function __construct() {

            add_action( 'customize_register', array( $this, 'register' ), 15);

        }

        function register( $wp_customize ) {

            /**************
             *  Upsell
             **************/

                /**
                * Option : Show Upsell Products
                */
                    $wp_customize->add_setting(
                        MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-upsell-display]', array(
                            'type' => 'option',
                            'sanitize_callback' => 'wp_filter_nohtml_kses'
                        )
                    );

                    $wp_customize->add_control(
                        new Multifox_Customize_Control_Switch(
                            $wp_customize, MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-upsell-display]', array(
                                'type'    => 'mfx-switch',
                                'label'   => esc_html__( 'Show Upsell Products', 'multifox'),
                                'section' => 'woocommerce-single-page-upsell-section',
                                'choices' => array(
                                    'on'  => esc_attr__( 'Yes', 'multifox' ),
                                    'off' => esc_attr__( 'No', 'multifox' )
                                )
                            )
                        )
                    );

                /**
                 * Option : Upsell Title
                 */
                    $wp_customize->add_setting(
                        MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-upsell-title]', array(
                            'type' => 'option',
                            'sanitize_callback' => 'wp_filter_nohtml_kses'
                        )
                    );

                    $wp_customize->add_control(
                        MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-upsell-title]', array(
                            'type'       => 'text',
                            'section'    => 'woocommerce-single-page-upsell-section',
                            'label'      => esc_html__( 'Upsell Title', 'multifox' )
                        )
                    );

                /**
                 * Option : Upsell Column
                 */
                    $wp_customize->add_setting(
                        MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-upsell-column]', array(
                            'type' => 'option',
                            'sanitize_callback' => 'wp_filter_nohtml_kses'
                        )
                    );

                    $wp_customize->add_control( new Multifox_Customize_Control_Radio_Image(
                        $wp_customize, MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-upsell-column]', array(
                            'type' => 'mfx-radio-image',
                            'label' => esc_html__( 'Upsell Column', 'multifox'),
                            'section' => 'woocommerce-single-page-upsell-section',
                            'choices' => apply_filters( 'multifox_woo_upsell_columns_options', array(
                                1 => array(
                                    'label' => esc_html__( 'One Column', 'multifox' ),
                                    'path' => multifox_shop_single_module_upsell_related()->module_dir_url() . 'customizer/images/one-column.png'
                                ),
                                2 => array(
                                    'label' => esc_html__( 'One Half Column', 'multifox' ),
                                    'path' => multifox_shop_single_module_upsell_related()->module_dir_url() . 'customizer/images/one-half-column.png'
                                ),
                                3 => array(
                                    'label' => esc_html__( 'One Third Column', 'multifox' ),
                                    'path' => multifox_shop_single_module_upsell_related()->module_dir_url() . 'customizer/images/one-third-column.png'
                                ),
                                4 => array(
                                    'label' => esc_html__( 'One Fourth Column', 'multifox' ),
                                    'path' => multifox_shop_single_module_upsell_related()->module_dir_url() . 'customizer/images/one-fourth-column.png'
                                )
                            ))
                        )
                    ));


                /**
                * Option : Upsell Limit
                */
                    $wp_customize->add_setting(
                        MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-upsell-limit]', array(
                            'type' => 'option',
                            'sanitize_callback' => 'wp_filter_nohtml_kses'
                        )
                    );

                    $wp_customize->add_control(
                        new Multifox_Customize_Control(
                            $wp_customize, MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-upsell-limit]', array(
                                'type'     => 'select',
                                'label'    => esc_html__( 'Upsell Limit', 'multifox'),
                                'section'  => 'woocommerce-single-page-upsell-section',
                                'choices'  => array (
                                    1 => esc_html__( '1', 'multifox' ),
                                    2 => esc_html__( '2', 'multifox' ),
                                    3 => esc_html__( '3', 'multifox' ),
                                    4 => esc_html__( '4', 'multifox' ),
                                    5 => esc_html__( '5', 'multifox' ),
                                    6 => esc_html__( '6', 'multifox' ),
                                    7 => esc_html__( '7', 'multifox' ),
                                    8 => esc_html__( '8', 'multifox' ),
                                    9 => esc_html__( '9', 'multifox' ),
                                    10 => esc_html__( '10', 'multifox' ),
                                )
                            )
                        )
                    );

                /**
                 * Option : Product Style Template
                 */
                    $wp_customize->add_setting(
                        MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-upsell-style-template]', array(
                            'type' => 'option',
                            'sanitize_callback' => 'wp_filter_nohtml_kses'
                        )
                    );

                    $wp_customize->add_control(
                        new Multifox_Customize_Control(
                            $wp_customize, MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-upsell-style-template]', array(
                                'type'     => 'select',
                                'label'    => esc_html__( 'Product Style Template', 'multifox'),
                                'section'  => 'woocommerce-single-page-upsell-section',
                                'choices'  => multifox_woo_listing_customizer_settings()->product_templates_list()
                            )
                        )
                    );


            /**************
             *  Related
             **************/

                /**
                * Option : Show Related Products
                */
                    $wp_customize->add_setting(
                        MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-related-display]', array(
                            'type' => 'option',
                            'sanitize_callback' => 'wp_filter_nohtml_kses'
                        )
                    );

                    $wp_customize->add_control(
                        new Multifox_Customize_Control_Switch(
                            $wp_customize, MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-related-display]', array(
                                'type'    => 'mfx-switch',
                                'label'   => esc_html__( 'Show Related Products', 'multifox'),
                                'section' => 'woocommerce-single-page-related-section',
                                'choices' => array(
                                    'on'  => esc_attr__( 'Yes', 'multifox' ),
                                    'off' => esc_attr__( 'No', 'multifox' )
                                )
                            )
                        )
                    );

                /**
                 * Option : Related Title
                 */
                    $wp_customize->add_setting(
                        MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-related-title]', array(
                            'type' => 'option',
                            'sanitize_callback' => 'wp_filter_nohtml_kses'
                        )
                    );

                    $wp_customize->add_control(
                        MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-related-title]', array(
                            'type'       => 'text',
                            'section'    => 'woocommerce-single-page-related-section',
                            'label'      => esc_html__( 'Related Title', 'multifox' )
                        )
                    );

                /**
                 * Option : Related Column
                 */
                    $wp_customize->add_setting(
                        MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-related-column]', array(
                            'type' => 'option',
                            'sanitize_callback' => 'wp_filter_nohtml_kses'
                        )
                    );

                    $wp_customize->add_control( new Multifox_Customize_Control_Radio_Image(
                        $wp_customize, MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-related-column]', array(
                            'type' => 'mfx-radio-image',
                            'label' => esc_html__( 'Related Column', 'multifox'),
                            'section' => 'woocommerce-single-page-related-section',
                            'choices' => apply_filters( 'multifox_woo_related_columns_options', array(
                                1 => array(
                                    'label' => esc_html__( 'One Column', 'multifox' ),
                                    'path' => multifox_shop_single_module_upsell_related()->module_dir_url() . 'customizer/images/one-column.png'
                                ),
                                2 => array(
                                    'label' => esc_html__( 'One Half Column', 'multifox' ),
                                    'path' => multifox_shop_single_module_upsell_related()->module_dir_url() . 'customizer/images/one-half-column.png'
                                ),
                                3 => array(
                                    'label' => esc_html__( 'One Third Column', 'multifox' ),
                                    'path' => multifox_shop_single_module_upsell_related()->module_dir_url() . 'customizer/images/one-third-column.png'
                                ),
                                4 => array(
                                    'label' => esc_html__( 'One Fourth Column', 'multifox' ),
                                    'path' => multifox_shop_single_module_upsell_related()->module_dir_url() . 'customizer/images/one-fourth-column.png'
                                )
                            ))
                        )
                    ));


                /**
                * Option : Related Limit
                */
                    $wp_customize->add_setting(
                        MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-related-limit]', array(
                            'type' => 'option',
                            'sanitize_callback' => 'wp_filter_nohtml_kses'
                        )
                    );

                    $wp_customize->add_control(
                        new Multifox_Customize_Control(
                            $wp_customize, MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-related-limit]', array(
                                'type'     => 'select',
                                'label'    => esc_html__( 'Related Limit', 'multifox'),
                                'section'  => 'woocommerce-single-page-related-section',
                                'choices'  => array (
                                    1 => esc_html__( '1', 'multifox' ),
                                    2 => esc_html__( '2', 'multifox' ),
                                    3 => esc_html__( '3', 'multifox' ),
                                    4 => esc_html__( '4', 'multifox' ),
                                    5 => esc_html__( '5', 'multifox' ),
                                    6 => esc_html__( '6', 'multifox' ),
                                    7 => esc_html__( '7', 'multifox' ),
                                    8 => esc_html__( '8', 'multifox' ),
                                    9 => esc_html__( '9', 'multifox' ),
                                    10 => esc_html__( '10', 'multifox' ),
                                )
                            )
                        )
                    );

                /**
                 * Option : Product Style Template
                 */
                    $wp_customize->add_setting(
                        MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-related-style-template]', array(
                            'type' => 'option',
                            'sanitize_callback' => 'wp_filter_nohtml_kses'
                        )
                    );

                    $wp_customize->add_control(
                        new Multifox_Customize_Control(
                            $wp_customize, MULTIFOX_CUSTOMISER_VAL . '[mfx-single-product-related-style-template]', array(
                                'type'     => 'select',
                                'label'    => esc_html__( 'Product Style Template', 'multifox'),
                                'section'  => 'woocommerce-single-page-related-section',
                                'choices'  => multifox_woo_listing_customizer_settings()->product_templates_list()
                            )
                        )
                    );


        }

    }

}


if( !function_exists('multifox_shop_customizer_single_upsell_related') ) {
	function multifox_shop_customizer_single_upsell_related() {
		return Multifox_Shop_Customizer_Single_Upsell_Related::instance();
	}
}

multifox_shop_customizer_single_upsell_related();