<?php
/**
 * Listing Options - Image Effect
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'Multifox_Woo_Listing_Option_Hover_Image_Effect' ) ) {

    class Multifox_Woo_Listing_Option_Hover_Image_Effect extends Multifox_Woo_Listing_Option_Core {

        private static $_instance = null;

        public $option_slug;

        public $option_name;

        public $option_type;

        public $option_default_value;

        public $option_value_prefix;

        public static function instance() {

            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {

            $this->option_slug          = 'product-hover-image-effect';
            $this->option_name          = esc_html__('Image Effect', 'multifox');
            $this->option_type          = array ( 'class', 'value-css' );
            $this->option_default_value = '';
            $this->option_value_prefix  = 'product-hover-image-';

            $this->render_backend();
        }

        /**
         * Backend Render
         */
        function render_backend() {
            add_filter( 'multifox_woo_custom_product_template_hover_options', array( $this, 'woo_custom_product_template_hover_options'), 10, 1 );
        }

        /**
         * Custom Product Templates - Options
         */
        function woo_custom_product_template_hover_options( $template_options ) {

            array_push( $template_options, $this->setting_args() );

            return $template_options;
        }

        /**
         * Settings Group
         */
        function setting_group() {
            return 'hover';
        }

        /**
         * Setting Args
         */
        function setting_args() {
            $settings            =  array ();
            $settings['id']      =  $this->option_slug;
            $settings['type']    =  'select';
            $settings['title']   =  $this->option_name;
            $settings['options'] =  array (
                ''                                => esc_html__('None', 'multifox'),
                'product-hover-image-blur'        => esc_html__('Blur', 'multifox'),
                'product-hover-image-blackwhite'  => esc_html__('Black & White', 'multifox'),
                'product-hover-image-fadeinleft'  => esc_html__('Fade In Left', 'multifox'),
                'product-hover-image-fadeinright' => esc_html__('Fade In Right', 'multifox'),
                'product-hover-image-rotate'      => esc_html__('Rotate', 'multifox'),
                'product-hover-image-rotatealt'   => esc_html__('Rotate - Alt', 'multifox'),
                'product-hover-image-scalein'     => esc_html__('Scale In', 'multifox'),
                'product-hover-image-scaleout'    => esc_html__('Scale Out', 'multifox'),
                'product-hover-image-floatout'    => esc_html__('Float Up', 'multifox')

            );
            $settings['default'] =  $this->option_default_value;

            return $settings;
        }
    }

}

if( !function_exists('multifox_woo_listing_option_hover_image_effect') ) {
	function multifox_woo_listing_option_hover_image_effect() {
		return Multifox_Woo_Listing_Option_Hover_Image_Effect::instance();
	}
}

multifox_woo_listing_option_hover_image_effect();