<?php
/**
 *
 */

if( !class_exists( 'Multifox_Loader' ) ) {

    class Multifox_Loader {

        private static $_instance = null;

        private $theme_defaults = array ();

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {
            $this->define_constants();
            $this->load_helpers();

            $this->theme_defaults = multifox_theme_defaults();

            add_action( 'after_setup_theme', array( $this, 'set_theme_support' ) );

            add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_js' ) );

            add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_css' ) );
            add_action( 'wp_enqueue_scripts', array( $this, 'add_inline_style' ) );

            add_action( 'multifox_before_main_css', array( $this, 'add_google_fonts' ) );

            add_action( 'after_setup_theme', array( $this, 'include_module_helpers' ) );

            $this->freemius_config();

            // Filter for WordPress default forget password
            add_filter( 'lostpassword_url', function( $url, $redirect )
            {
                remove_all_filters( 'lostpassword_url' );

                return wp_lostpassword_url( $redirect );
            }, PHP_INT_MAX, 2 );
        }

        function define_constants() {
            define( 'MULTIFOX_ROOT_DIR', get_template_directory() );
            define( 'MULTIFOX_ROOT_URI', get_template_directory_uri() );
            define( 'MULTIFOX_MODULE_DIR', MULTIFOX_ROOT_DIR.'/modules'  );
            define( 'MULTIFOX_MODULE_URI', MULTIFOX_ROOT_URI.'/modules' );
            define( 'MULTIFOX_LANG_DIR', MULTIFOX_ROOT_DIR.'/languages' );

            $theme = wp_get_theme();
            define( 'MULTIFOX_THEME_NAME', $theme->get('Name'));
            define( 'MULTIFOX_THEME_VERSION', $theme->get('Version'));
        }

        function load_helpers() {
            include_once MULTIFOX_ROOT_DIR . '/helpers/helper.php';
        }

        function set_theme_support() {
            load_theme_textdomain( 'multifox', MULTIFOX_LANG_DIR );
            add_theme_support( 'automatic-feed-links' );
            add_theme_support( 'title-tag' );
            add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );
            add_theme_support( 'post-formats', array('status', 'quote', 'gallery', 'image', 'video', 'audio', 'link', 'aside', 'chat'));
            add_theme_support( 'post-thumbnails' );
            add_theme_support( 'custom-logo' );
            add_theme_support( 'custom-background', array( 'default-color' => '#d1e4dd' ) );
            add_theme_support( 'custom-header' );

			add_theme_support( 'align-wide' ); // Gutenberg wide images.
            add_theme_support( 'editor-color-palette', array(
                array(
                    'name'  => esc_html__( 'Primary Color', 'multifox' ),
                    'slug'  => 'primary',
                    'color'	=> $this->theme_defaults['primary_color'],
                ),
                array(
                    'name'  => esc_html__( 'Secondary Color', 'multifox' ),
                    'slug'  => 'secondary',
                    'color' => $this->theme_defaults['secondary_color'],
                ),
                array(
                    'name'  => esc_html__( 'Tertiary Color', 'multifox' ),
                    'slug'  => 'tertiary',
                    'color' => $this->theme_defaults['tertiary_color'],
                ),
                array(
                    'name'  => esc_html__( 'Body Background Color', 'multifox' ),
                    'slug'  => 'body-bg',
                    'color' => $this->theme_defaults['body_bg_color'],
                ),
                array(
                    'name'  => esc_html__( 'Body Text Color', 'multifox' ),
                    'slug'  => 'body-text',
                    'color' => $this->theme_defaults['body_text_color'],
                ),
                array(
                    'name'  => esc_html__( 'Alternate Color', 'multifox' ),
                    'slug'  => 'alternate',
                    'color' => $this->theme_defaults['headalt_color'],
                ),
                array(
                    'name'  => esc_html__( 'Transparent Color', 'multifox' ),
                    'slug'  => 'transparent',
                    'color' => 'rgba(0,0,0,0)',
                )
            ) );

            add_theme_support( 'editor-styles' );
            add_editor_style( './assets/css/style-editor.css' );

            $GLOBALS['content_width'] = apply_filters( 'multifox_set_content_width', 1230 );
            register_nav_menus( array(
                'main-menu' => esc_html__('Main Menu', 'multifox'),
            ) );
        }

        function enqueue_js() {

            wp_enqueue_script('jquery-select2', get_theme_file_uri('/assets/lib/select2/select2.full.js'), array('jquery'), false, true);

            /**
             * Before Hook
             */
            do_action( 'multifox_before_enqueue_js' );

                wp_enqueue_script('multifox-jqcustom', get_theme_file_uri('/assets/js/custom.js'), array('jquery'), false, true);

                if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
				    wp_enqueue_script( 'comment-reply' );
			    }

            /**
             * After Hook
             */
            do_action( 'multifox_after_enqueue_js' );

        }

        function enqueue_css() {
            /**
             * Before Hook
             */
            do_action( 'multifox_before_main_css' );

                wp_enqueue_style( 'multifox', get_stylesheet_uri(), false, MULTIFOX_THEME_VERSION, 'all' );
                wp_enqueue_style( 'multifox-icons', get_theme_file_uri('/assets/css/icons.css'), false, MULTIFOX_THEME_VERSION, 'all');

                $css = $this->generate_theme_default_css();
                if( !empty( $css ) ) {
                    wp_add_inline_style( 'multifox', ':root {'.$css.'}' );
                }

                wp_enqueue_style( 'multifox-base', get_theme_file_uri('/assets/css/base.css'), false, MULTIFOX_THEME_VERSION, 'all');
                wp_enqueue_style( 'multifox-grid', get_theme_file_uri('/assets/css/grid.css'), false, MULTIFOX_THEME_VERSION, 'all');
                wp_enqueue_style( 'multifox-layout', get_theme_file_uri('/assets/css/layout.css'), false, MULTIFOX_THEME_VERSION, 'all');
                wp_enqueue_style( 'multifox-widget', get_theme_file_uri('/assets/css/widget.css'), false, MULTIFOX_THEME_VERSION, 'all');

            /**
             * After Hook
             */
            do_action( 'multifox_after_main_css' );

            wp_enqueue_style( 'jquery-select2', get_theme_file_uri('/assets/lib/select2/select2.css'), false, MULTIFOX_THEME_VERSION, 'all');

            wp_enqueue_style( 'multifox-theme', get_theme_file_uri('/assets/css/theme.css'), false, MULTIFOX_THEME_VERSION, 'all');
        }

        function generate_theme_default_css() {

            $css = '';

            $css .= apply_filters( 'multifox_primary_color_css_var',  '--mfxPrimaryColor: '.$this->theme_defaults['primary_color'].';' );
            $css .= apply_filters( 'multifox_primary_rgb_color_css_var',  '--mfxPrimaryColorRgb: '.$this->theme_defaults['primary_color_rgb'].';' );
            $css .= apply_filters( 'multifox_secondary_color_css_var',  '--mfxSecondaryColor: '.$this->theme_defaults['secondary_color'].';' );
            $css .= apply_filters( 'multifox_secondary_rgb_color_css_var',  '--mfxSecondaryColorRgb: '.$this->theme_defaults['secondary_color_rgb'].';' );
            $css .= apply_filters( 'multifox_tertiary_color_css_var',  '--mfxTertiaryColor: '.$this->theme_defaults['tertiary_color'].';' );
            $css .= apply_filters( 'multifox_tertiary_rgb_color_css_var',  '--mfxTertiaryColorRgb: '.$this->theme_defaults['tertiary_color_rgb'].';' );
            $css .= apply_filters( 'multifox_body_bg_color_css_var',  '--mfxBodyBGColor: '.$this->theme_defaults['body_bg_color'].';' );
            $css .= apply_filters( 'multifox_body_bg_rgb_color_css_var',  '--mfxBodyBGColorRgb: '.$this->theme_defaults['body_bg_color_rgb'].';' );
            $css .= apply_filters( 'multifox_body_text_color_css_var',  '--mfxBodyTxtColor:'.$this->theme_defaults['body_text_color'].';' );
            $css .= apply_filters( 'multifox_body_text_rgb_color_css_var',  '--mfxBodyTxtColorRgb:'.$this->theme_defaults['body_text_color_rgb'].';' );
            $css .= apply_filters( 'multifox_headalt_color_css_var',  '--mfxHeadAltColor: '.$this->theme_defaults['headalt_color'].';' );
            $css .= apply_filters( 'multifox_headalt_rgb_color_css_var',  '--mfxHeadAltColorRgb: '.$this->theme_defaults['headalt_color_rgb'].';' );
            $css .= apply_filters( 'multifox_link_color_css_var',  '--mfxLinkColor: '.$this->theme_defaults['link_color'].';' );
            $css .= apply_filters( 'multifox_link_rgb_color_css_var',  '--mfxLinkColorRgb: '.$this->theme_defaults['link_color_rgb'].';' );
            $css .= apply_filters( 'multifox_link_hover_color_css_var',  '--mfxLinkHoverColor: '.$this->theme_defaults['link_hover_color'].';' );
            $css .= apply_filters( 'multifox_link_hover_rgb_color_css_var',  '--mfxLinkHoverColorRgb: '.$this->theme_defaults['link_hover_color_rgb'].';' );
            $css .= apply_filters( 'multifox_border_color_css_var',  '--mfxBorderColor: '.$this->theme_defaults['border_color'].';' );
            $css .= apply_filters( 'multifox_border_rgb_color_css_var',  '--mfxBorderColorRgb: '.$this->theme_defaults['border_color_rgb'].';' );
            $css .= apply_filters( 'multifox_accent_text_color_css_var',  '--mfxAccentTxtColor: '.$this->theme_defaults['accent_text_color'].';' );
            $css .= apply_filters( 'multifox_accent_text_rgb_color_css_var',  '--mfxAccentTxtColorRgb: '.$this->theme_defaults['accent_text_color_rgb'].';' );

            if(isset($this->theme_defaults['body_typo']) && !empty($this->theme_defaults['body_typo'])) {

                $body_typo_css_var = apply_filters( 'multifox_body_typo_customizer_update',  $this->theme_defaults['body_typo'] );

                $css .=  '--mfxFontTypo_Base: '.$body_typo_css_var['font-fallback'].';';
                $css .=  '--mfxFontWeight_Base: '.$body_typo_css_var['font-weight'].';';
                $css .=  '--mfxFontSize_Base: '.$body_typo_css_var['fs-desktop'].$body_typo_css_var['fs-desktop-unit'].';';
                $css .=  '--mfxLineHeight_Base: '.$body_typo_css_var['lh-desktop'].$body_typo_css_var['lh-desktop-unit'].';';
            }

            if(isset($this->theme_defaults['h1_typo']) && !empty($this->theme_defaults['h1_typo'])) {

                $h1_typo_css_var = apply_filters( 'multifox_h1_typo_customizer_update',  $this->theme_defaults['h1_typo'] );

                $css .= '--mfxFontTypo_Alt: '.$h1_typo_css_var['font-fallback'].';';
                $css .= '--mfxFontWeight_Alt: '.$h1_typo_css_var['font-weight'].';';
                $css .= '--mfxFontSize_Alt: '.$h1_typo_css_var['fs-desktop'].$h1_typo_css_var['fs-desktop-unit'].';';
                $css .= '--mfxLineHeight_Alt: '.$h1_typo_css_var['lh-desktop'].$h1_typo_css_var['lh-desktop-unit'].';';

                $css .= '--mfxFontTypo_H1: '.$h1_typo_css_var['font-fallback'].';';
                $css .= '--mfxFontWeight_H1: '.$h1_typo_css_var['font-weight'].';';
                $css .= '--mfxFontSize_H1: '.$h1_typo_css_var['fs-desktop'].$h1_typo_css_var['fs-desktop-unit'].';';
                $css .= '--mfxLineHeight_H1: '.$h1_typo_css_var['lh-desktop'].$h1_typo_css_var['lh-desktop-unit'].';';

            }

            if(isset($this->theme_defaults['h2_typo']) && !empty($this->theme_defaults['h2_typo'])) {

                $h2_typo_css_var = apply_filters( 'multifox_h2_typo_customizer_update',  $this->theme_defaults['h2_typo'] );

                $css .= '--mfxFontTypo_H2: '.$h2_typo_css_var['font-fallback'].';';
                $css .= '--mfxFontWeight_H2: '.$h2_typo_css_var['font-weight'].';';
                $css .= '--mfxFontSize_H2: '.$h2_typo_css_var['fs-desktop'].$h2_typo_css_var['fs-desktop-unit'].';';
                $css .= '--mfxLineHeight_H2: '.$h2_typo_css_var['lh-desktop'].$h2_typo_css_var['lh-desktop-unit'].';';

            }

            if(isset($this->theme_defaults['h3_typo']) && !empty($this->theme_defaults['h3_typo'])) {

                $h3_typo_css_var = apply_filters( 'multifox_h3_typo_customizer_update',  $this->theme_defaults['h3_typo'] );

                $css .= '--mfxFontTypo_H3: '.$h3_typo_css_var['font-fallback'].';';
                $css .= '--mfxFontWeight_H3: '.$h3_typo_css_var['font-weight'].';';
                $css .= '--mfxFontSize_H3: '.$h3_typo_css_var['fs-desktop'].$h3_typo_css_var['fs-desktop-unit'].';';
                $css .= '--mfxLineHeight_H3: '.$h3_typo_css_var['lh-desktop'].$h3_typo_css_var['lh-desktop-unit'].';';

            }

            if(isset($this->theme_defaults['h4_typo']) && !empty($this->theme_defaults['h4_typo'])) {

                $h4_typo_css_var = apply_filters( 'multifox_h4_typo_customizer_update',  $this->theme_defaults['h4_typo'] );

                $css .= '--mfxFontTypo_H4: '.$h4_typo_css_var['font-fallback'].';';
                $css .= '--mfxFontWeight_H4: '.$h4_typo_css_var['font-weight'].';';
                $css .= '--mfxFontSize_H4: '.$h4_typo_css_var['fs-desktop'].$h4_typo_css_var['fs-desktop-unit'].';';
                $css .= '--mfxLineHeight_H4: '.$h4_typo_css_var['lh-desktop'].$h4_typo_css_var['lh-desktop-unit'].';';

            }

            if(isset($this->theme_defaults['h5_typo']) && !empty($this->theme_defaults['h5_typo'])) {

                $h5_typo_css_var = apply_filters( 'multifox_h5_typo_customizer_update',  $this->theme_defaults['h5_typo'] );

                $css .= '--mfxFontTypo_H5: '.$h5_typo_css_var['font-fallback'].';';
                $css .= '--mfxFontWeight_H5: '.$h5_typo_css_var['font-weight'].';';
                $css .= '--mfxFontSize_H5: '.$h5_typo_css_var['fs-desktop'].$h5_typo_css_var['fs-desktop-unit'].';';
                $css .= '--mfxLineHeight_H5: '.$h5_typo_css_var['lh-desktop'].$h5_typo_css_var['lh-desktop-unit'].';';

            }

            if(isset($this->theme_defaults['h6_typo']) && !empty($this->theme_defaults['h6_typo'])) {

                $h6_typo_css_var = apply_filters( 'multifox_h6_typo_customizer_update',  $this->theme_defaults['h6_typo'] );

                $css .= '--mfxFontTypo_H6: '.$h6_typo_css_var['font-fallback'].';';
                $css .= '--mfxFontWeight_H6: '.$h6_typo_css_var['font-weight'].';';
                $css .= '--mfxFontSize_H6: '.$h6_typo_css_var['fs-desktop'].$h6_typo_css_var['fs-desktop-unit'].';';
                $css .= '--mfxLineHeight_H6: '.$h6_typo_css_var['lh-desktop'].$h6_typo_css_var['lh-desktop-unit'].';';

            }

            if(isset($this->theme_defaults['extra_typo']) && !empty($this->theme_defaults['extra_typo'])) {

                $css .= apply_filters( 'multifox_typo_font_family_css_var',  '--mfxFontTypo_Ext: '.$this->theme_defaults['extra_typo']['font-fallback'].';' );
                $css .= apply_filters( 'multifox_typo_font_weight_css_var',  '--mfxFontWeight_Ext: '.$this->theme_defaults['extra_typo']['font-weight'].';' );
                $css .= apply_filters( 'multifox_typo_fs_desktop_css_var',  '--mfxFontSize_Ext: '.$this->theme_defaults['extra_typo']['fs-desktop'].$this->theme_defaults['extra_typo']['fs-desktop-unit'].';' );
                $css .= apply_filters( 'multifox_typo_lh_desktop_css_var',  '--mfxLineHeight_Ext: '.$this->theme_defaults['extra_typo']['lh-desktop'].$this->theme_defaults['extra_typo']['lh-desktop-unit'].';' );

            }

            return $css;

        }

        function add_inline_style() {

            wp_register_style( 'multifox-admin', '', array(), MULTIFOX_THEME_VERSION, 'all' );
            wp_enqueue_style( 'multifox-admin' );

            $css = apply_filters( 'multifox_add_inline_style', $css = '' );

            if( !empty( $css ) ) {
                wp_add_inline_style( 'multifox-admin', $css );
            }

            /**
             * Responsive CSS
             */

                # Tablet Landscape
                    $tablet_landscape = apply_filters( 'multifox_add_tablet_landscape_inline_style', $tablet_landscape = '' );
                    if( !empty( $tablet_landscape ) ) {
                        $tablet_landscape = '@media only screen and (min-width:1025px) and (max-width:1280px) {'."\n".$tablet_landscape."\n".'}';
                        wp_add_inline_style( 'multifox-admin', $tablet_landscape );
                    }

                # Tablet Portrait
                    $tablet_portrait = apply_filters( 'multifox_add_tablet_portrait_inline_style', $tablet_portrait = '' );
                    if( !empty( $tablet_portrait ) ) {
                        $tablet_portrait = '@media only screen and (min-width:768px) and (max-width:1024px) {'."\n".$tablet_portrait."\n".'}';
                        wp_add_inline_style( 'multifox-admin', $tablet_portrait );
                    }

                # Mobile
                    $mobile_res = apply_filters( 'multifox_add_mobile_res_inline_style', $mobile_res = '' );
                    if( !empty( $mobile_res ) ) {
                        $mobile_res = '@media (max-width: 767px) {'."\n".$mobile_res."\n".'}';
                        wp_add_inline_style( 'multifox-admin', $mobile_res );
                    }

        }

        function add_google_fonts() {
            $subset = apply_filters( 'multifox_google_font_supsets', 'latin-ext' );
            $fonts  = apply_filters( 'multifox_google_fonts_list', array(
                'Open Sans:300,400,500,600,700,800,900',
                'Montserrat:300,400,500,600,700,800,900',
                'Merriweather:400'
            ) );

			foreach( $fonts as $font ) {
				$url = '//fonts.googleapis.com/css?family=' . str_replace( ' ', '+', $font );
                $url .= !empty( $subset ) ? '&subset=' . $subset : '';

				$key = md5( $font . $subset );

				// check that the URL is valid. we're going to use transients to make this faster.
				$url_is_valid = get_transient( $key );

				// transient does not exist
				if ( false === $url_is_valid ) {
					$response = wp_remote_get( 'https:' . $url );
					if ( ! is_array( $response ) ) {
						// the url was not properly formatted,
						// cache for 12 hours and continue to the next field
						set_transient( $key, null, 12 * HOUR_IN_SECONDS );
						continue;
					}

					// check the response headers.
					if ( isset( $response['response'] ) && isset( $response['response']['code'] ) ) {
						if ( 200 == $response['response']['code'] ) {
							// URL was ok
							// set transient to true and cache for a week
							set_transient( $key, true, 7 * 24 * HOUR_IN_SECONDS );
							$url_is_valid = true;
						}
					}
				}

				// If the font-link is valid, enqueue it.
				if ( $url_is_valid ) {
					wp_enqueue_style( $key, $url, null, null );
				}
			}

        }

        function include_module_helpers() {

            /**
             * Before Hook
             */
            do_action( 'multifox_before_load_module_helpers' );

            foreach( glob( MULTIFOX_ROOT_DIR. '/modules/*/helper.php'  ) as $helper ) {
                include_once $helper;
            }

            /**
             * After Hook
             */
            do_action( 'multifox_after_load_module_helpers' );
        }

        function mfx_fs() {
            global $mfx_fs;

            if ( ! isset( $mfx_fs ) ) {
                // Include Freemius SDK.
                require_once MULTIFOX_PLUS_DIR_PATH . '/freemius/start.php';

                $mfx_fs = fs_dynamic_init( array(
                    'id'                  => '9591',
                    'slug'                => 'multifox',
                    'type'                => 'theme',
                    'public_key'          => 'pk_5dbb09f881cfc6b3829d8c12709db',
                    'is_premium'          => false,
                    'has_addons'          => false,
                    'has_paid_plans'      => false,
                    'menu'                => array(
                        'account'        => false,
                        'contact'        => false,
                        'support'        => false,
                    ),
                ) );
            }

            return $mfx_fs;
        }

        function freemius_config() {

            if (class_exists ( 'MultifoxPlus' ) && defined('MULTIFOX_PLUS_DIR_PATH')) {
                // Init Freemius.
                $this->mfx_fs();
                // Signal that SDK was initiated.
                do_action( 'mfx_fs_loaded' );
            }

        }

    }

    Multifox_Loader::instance();
}