<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'Multifox_Shop_Metabox_Single_Upsell_Related' ) ) {
    class Multifox_Shop_Metabox_Single_Upsell_Related {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {

			add_filter( 'multifox_shop_product_custom_settings', array( $this, 'multifox_shop_product_custom_settings' ), 10 );

		}

        function multifox_shop_product_custom_settings( $options ) {

			$ct_dependency      = array ();
			$upsell_dependency  = array ( 'show-upsell', '==', 'true');
			$related_dependency = array ( 'show-related', '==', 'true');
			if( function_exists('multifox_shop_single_module_custom_template') ) {
				$ct_dependency['dependency'] 	= array ( 'product-template', '!=', 'custom-template');
				$upsell_dependency 				= array ( 'product-template|show-upsell', '!=|==', 'custom-template|true');
				$related_dependency 			= array ( 'product-template|show-related', '!=|==', 'custom-template|true');
			}

			$product_options = array (

				array_merge (
					array(
						'id'         => 'show-upsell',
						'type'       => 'select',
						'title'      => esc_html__('Show Upsell Products', 'multifox'),
						'class'      => 'chosen',
						'default'    => 'admin-option',
						'attributes' => array( 'data-depend-id' => 'show-upsell' ),
						'options'    => array(
							'admin-option' => esc_html__( 'Admin Option', 'multifox' ),
							'true'         => esc_html__( 'Show', 'multifox'),
							null           => esc_html__( 'Hide', 'multifox'),
						)
					),
					$ct_dependency
				),

				array(
					'id'         => 'upsell-column',
					'type'       => 'select',
					'title'      => esc_html__('Choose Upsell Column', 'multifox'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'multifox' ),
						1              => esc_html__( 'One Column', 'multifox' ),
						2              => esc_html__( 'Two Columns', 'multifox' ),
						3              => esc_html__( 'Three Columns', 'multifox' ),
						4              => esc_html__( 'Four Columns', 'multifox' ),
					),
					'dependency' => $upsell_dependency
				),

				array(
					'id'         => 'upsell-limit',
					'type'       => 'select',
					'title'      => esc_html__('Choose Upsell Limit', 'multifox'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'multifox' ),
						1              => esc_html__( 'One', 'multifox' ),
						2              => esc_html__( 'Two', 'multifox' ),
						3              => esc_html__( 'Three', 'multifox' ),
						4              => esc_html__( 'Four', 'multifox' ),
						5              => esc_html__( 'Five', 'multifox' ),
						6              => esc_html__( 'Six', 'multifox' ),
						7              => esc_html__( 'Seven', 'multifox' ),
						8              => esc_html__( 'Eight', 'multifox' ),
						9              => esc_html__( 'Nine', 'multifox' ),
						10              => esc_html__( 'Ten', 'multifox' ),
					),
					'dependency' => $upsell_dependency
				),

				array_merge (
					array(
						'id'         => 'show-related',
						'type'       => 'select',
						'title'      => esc_html__('Show Related Products', 'multifox'),
						'class'      => 'chosen',
						'default'    => 'admin-option',
						'attributes' => array( 'data-depend-id' => 'show-related' ),
						'options'    => array(
							'admin-option' => esc_html__( 'Admin Option', 'multifox' ),
							'true'         => esc_html__( 'Show', 'multifox'),
							null           => esc_html__( 'Hide', 'multifox'),
						)
					),
					$ct_dependency
				),

				array(
					'id'         => 'related-column',
					'type'       => 'select',
					'title'      => esc_html__('Choose Related Column', 'multifox'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'multifox' ),
						2              => esc_html__( 'Two Columns', 'multifox' ),
						3              => esc_html__( 'Three Columns', 'multifox' ),
						4              => esc_html__( 'Four Columns', 'multifox' ),
					),
					'dependency' => $related_dependency
				),

				array(
					'id'         => 'related-limit',
					'type'       => 'select',
					'title'      => esc_html__('Choose Related Limit', 'multifox'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'multifox' ),
						1              => esc_html__( 'One', 'multifox' ),
						2              => esc_html__( 'Two', 'multifox' ),
						3              => esc_html__( 'Three', 'multifox' ),
						4              => esc_html__( 'Four', 'multifox' ),
						5              => esc_html__( 'Five', 'multifox' ),
						6              => esc_html__( 'Six', 'multifox' ),
						7              => esc_html__( 'Seven', 'multifox' ),
						8              => esc_html__( 'Eight', 'multifox' ),
						9              => esc_html__( 'Nine', 'multifox' ),
						10              => esc_html__( 'Ten', 'multifox' ),
					),
					'dependency' => $related_dependency
				)

			);

			$options = array_merge( $options, $product_options );

			return $options;

		}

    }
}

Multifox_Shop_Metabox_Single_Upsell_Related::instance();