<?php
/**
 * Recommends plugins for use with the theme via the TGMA Script
 *
 * @package Multifox WordPress theme
 */

function multifox_tgmpa_plugins_register() {

	// Get array of recommended plugins.
	$plugins_list = array(
		array(
			'name'				=> 'Multifox Plus',
			'slug'				=> 'multifox-plus',
			'required'			=> false,
			'force_activation'	=> false,
		)
	);

	$plugins = apply_filters('multifox_required_plugins_list', $plugins_list);

	// Register notice
	tgmpa( $plugins, array(
		'id'           => 'multifox_theme',
		'domain'       => 'multifox',
		'menu'         => 'install-required-plugins',
		'has_notices'  => true,
		'is_automatic' => true,
		'dismissable'  => true,
	) );

}
add_action( 'tgmpa_register', 'multifox_tgmpa_plugins_register' );