<?php
add_action( 'multifox_after_main_css', 'header_style' );
function header_style() {
    wp_enqueue_style( 'multifox-header', get_theme_file_uri('/modules/header/assets/css/header.css'), false, MULTIFOX_THEME_VERSION, 'all');
}

if( ! function_exists( 'multifox_get_header_wrapper_classes' )  ) {
	function multifox_get_header_wrapper_classes() {
		return apply_filters( 'multifox_header_wrapper_classes', 'header-top-absolute' );
	}
}

if( ! function_exists( 'multifox_header_template' )  ) {
	function multifox_header_template() {
		multifox_template_part( 'header', 'templates/header' );
	}

	add_action( 'multifox_header', 'multifox_header_template' );
}

if( !class_exists( 'Multifox_Default_Header_Walker_Nav_Menu' ) ) {

	class Multifox_Default_Header_Walker_Nav_Menu extends Walker_Nav_Menu {

		public function start_lvl( &$output, $depth = 0, $args = null ) {
			if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
				$t = '';
				$n = '';
			} else {
				$t = "\t";
				$n = "\n";
			}
			$indent = str_repeat( $t, $depth );

			$classes = array( 'sub-menu', 'is-hidden' );
			$class_names = join( ' ', apply_filters( 'nav_menu_submenu_css_class', $classes, $args, $depth ) );
			$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

			$output .= "{$n}{$indent}<ul$class_names>{$n}";
			$output .= '<li class="close-nav"><a href="javascript:void(0);"></a></li>';
			$output .= '<li class="go-back"><a href="javascript:void(0);"></a></li>';
			$output .= '<li class="see-all"></li>';
		}
	}
}

if( !function_exists('multifox_nav_menu_class') ) {
	function multifox_nav_menu_class( $classes, $item, $args, $depth ) {

		$classes[] = 'menu-item-depth-' . $depth;
		return $classes;
	}

	add_filter( 'nav_menu_css_class', 'multifox_nav_menu_class', 10, 4 );
}