<?php
/**
 * multicolor-business: Customizer
 *
 * @subpackage multicolor-business
 * @since 1.0
 */

function multicolor_business_customize_register( $wp_customize ) {

	$wp_customize->add_setting('multicolor_business_logo_size',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_logo_size',array(
		'type' => 'range',
		'description' => __('Logo Size (0-100%)','multicolor-business'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('multicolor_business_logo_padding',array(
		'sanitize_callback'	=> 'esc_html'
	));
	$wp_customize->add_control('multicolor_business_logo_padding',array(
		'label' => __('Logo Padding','multicolor-business'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('multicolor_business_logo_top_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_logo_top_padding',array(
		'type' => 'number',
		'description' => __('Top','multicolor-business'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('multicolor_business_logo_bottom_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_logo_bottom_padding',array(
		'type' => 'number',
		'description' => __('Bottom','multicolor-business'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('multicolor_business_logo_left_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_logo_left_padding',array(
		'type' => 'number',
		'description' => __('Left','multicolor-business'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('multicolor_business_logo_right_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_logo_right_padding',array(
		'type' => 'number',
		'description' => __('Right','multicolor-business'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('multicolor_business_show_site_title',array(
		'default' => true,
		'sanitize_callback'	=> 'multicolor_business_sanitize_checkbox'
	));
	$wp_customize->add_control('multicolor_business_show_site_title',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Title','multicolor-business'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('multicolor_business_site_title_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_site_title_font_size',array(
		'type' => 'number',
		'label' => __('Site Title Font Size','multicolor-business'),
		'section' => 'title_tagline',
	));

   $wp_customize->add_setting('multicolor_business_show_tagline',array(
      'default' => true,
      'sanitize_callback'	=> 'multicolor_business_sanitize_checkbox'
   ));
   $wp_customize->add_control('multicolor_business_show_tagline',array(
      'type' => 'checkbox',
      'label' => __('Show / Hide Site Tagline','multicolor-business'),
      'section' => 'title_tagline'
   ));

	$wp_customize->add_setting('multicolor_business_site_tagline_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_site_tagline_font_size',array(
		'type' => 'number',
		'label' => __('Site Tagline Font Size','multicolor-business'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_panel( 'multicolor_business_panel_id', array(
	   'priority' => 10,
	   'capability' => 'edit_theme_options',
	   'theme_supports' => '',
	   'title' => __( 'Theme Settings', 'multicolor-business' ),
	   'description' => __( 'Description of what this panel does.', 'multicolor-business' ),
	) );

	$wp_customize->add_section( 'multicolor_business_theme_options_section', array(
    	'title'      => __( 'General Settings', 'multicolor-business' ),
		'priority'   => 30,
		'panel' => 'multicolor_business_panel_id'
	) );

	$wp_customize->add_setting('multicolor_business_theme_options',array(
      'default' => 'Right Sidebar',
      'sanitize_callback' => 'multicolor_business_sanitize_choices'
	));
	$wp_customize->add_control('multicolor_business_theme_options',array(
        'type' => 'radio',
        'label' => __('Do you want this section','multicolor-business'),
        'section' => 'multicolor_business_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','multicolor-business'),
            'Right Sidebar' => __('Right Sidebar','multicolor-business'),
            'One Column' => __('One Column','multicolor-business'),
            'Three Columns' => __('Three Columns','multicolor-business'),
            'Four Columns' => __('Four Columns','multicolor-business'),
            'Grid Layout' => __('Grid Layout','multicolor-business')
        ),
	));

	$wp_customize->add_setting( 'multicolor_business_boxfull_width', array(
		'default'           => '',
		'sanitize_callback' => 'multicolor_business_sanitize_choices'
	));
	
	$wp_customize->add_control( 'multicolor_business_boxfull_width', array(
		'label'    => __( 'Section Width', 'multicolor-business' ),
		'section'  => 'multicolor_business_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'container'  => __('Box Width', 'multicolor-business'),
			'container-fluid' => __('Full Width', 'multicolor-business'),
			'none' => __('None', 'multicolor-business')
		),
	));

	$wp_customize->add_setting( 'multicolor_business_dropdown_anim', array(
		'default'           => 'None',
		'sanitize_callback' => 'multicolor_business_sanitize_choices'
	));
	$wp_customize->add_control( 'multicolor_business_dropdown_anim', array(
		'label'    => __( 'Menu Dropdown Animations', 'multicolor-business' ),
		'section'  => 'multicolor_business_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp'  => __('bounceInUp', 'multicolor-business'),
			'fadeInUp' => __('fadeInUp', 'multicolor-business'),
			'zoomIn'    => __('zoomIn', 'multicolor-business'),
			'None'    => __('None', 'multicolor-business')
		),
	));

	// Contact Details
	$wp_customize->add_section( 'multicolor_business_contact_details', array(
    	'title'      => __( 'Header Contact Details Setting', 'multicolor-business' ),
		'priority'   => null,
		'panel' => 'multicolor_business_panel_id'
	) );

	$wp_customize->add_setting('multicolor_business_hide_show_topbar',array(
    	'default' => false,
    	'sanitize_callback'	=> 'multicolor_business_sanitize_checkbox'
	));
	$wp_customize->add_control('multicolor_business_hide_show_topbar',array(
   	'type' => 'checkbox',
   	'label' => __('Show / Hide Topbar','multicolor-business'),
   	'section' => 'multicolor_business_contact_details',
	));

	$wp_customize->add_setting('multicolor_business_mail',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_email'
	));	
	$wp_customize->add_control('multicolor_business_mail',array(
		'label'	=> __('Email Address','multicolor-business'),
		'section'=> 'multicolor_business_contact_details',
		'setting'=> 'multicolor_business_mail',
		'type'=> 'text'
	));	

	$wp_customize->add_setting('multicolor_business_call',array(
		'default'=> '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_phone_number'
	));	
	$wp_customize->add_control('multicolor_business_call',array(
		'label'	=> __('Contact Number','multicolor-business'),
		'section'=> 'multicolor_business_contact_details',
		'setting'=> 'multicolor_business_call',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'multicolor_business_top_icon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multicolor_business_top_icon_color', array(
		'label' => 'Icon Color',
		'section' => 'multicolor_business_contact_details',
	)));

	$wp_customize->add_setting( 'multicolor_business_top_text_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multicolor_business_top_text_color', array(
		'label' => 'Text Color',
		'section' => 'multicolor_business_contact_details',
	)));

	$wp_customize->add_setting( 'multicolor_business_topbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multicolor_business_topbg_color', array(
		'label' => 'Top Bg Color',
		'section' => 'multicolor_business_contact_details',
	)));

	$wp_customize->add_setting( 'multicolor_business_menu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multicolor_business_menu_color', array(
		'label' => 'Menu Color',
		'section' => 'multicolor_business_contact_details',
	)));

	$wp_customize->add_setting( 'multicolor_business_menubg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multicolor_business_menubg_color', array(
		'label' => 'Menu Bg Color',
		'section' => 'multicolor_business_contact_details',
	)));

	//home page slider
	$wp_customize->add_section( 'multicolor_business_slider_section' , array(
    	'title'      => __( 'Slider Settings', 'multicolor-business' ),
		'priority'   => null,
		'panel' => 'multicolor_business_panel_id'
	) );

	$wp_customize->add_setting('multicolor_business_slider_hide_show',array(
    	'default' => false,
    	'sanitize_callback'	=> 'multicolor_business_sanitize_checkbox'
	));
	$wp_customize->add_control('multicolor_business_slider_hide_show',array(
   	'type' => 'checkbox',
   	'label' => __('Show / Hide slider','multicolor-business'),
   	'section' => 'multicolor_business_slider_section',
	));

	$wp_customize->add_setting( 'multicolor_business_slider_effect', array(
		'default'           => '',
		'sanitize_callback' => 'multicolor_business_sanitize_choices'
	));
	$wp_customize->add_control( 'multicolor_business_slider_effect', array(
		'label'    => __( 'Onload Transactions Effects', 'multicolor-business' ),
		'section'  => 'multicolor_business_slider_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInLeft'  => __('bounceInLeft', 'multicolor-business'),
			'bounceInRight' => __('bounceInRight', 'multicolor-business'),
			'bounceInUp'    => __('bounceInUp', 'multicolor-business'),
			'bounceInDown'    => __('bounceInDown', 'multicolor-business'),
			'zoomIn'  => __('zoomIn', 'multicolor-business'),
			'zoomOut' => __('zoomOut', 'multicolor-business'),
			'fadeInDown'    => __('fadeInDown', 'multicolor-business'),
			'fadeInUp'    => __('fadeInUp', 'multicolor-business'),
			'fadeInLeft'  => __('fadeInLeft', 'multicolor-business'),
			'fadeInRight' => __('fadeInRight', 'multicolor-business'),
			'flip-up'    => __('flip-up', 'multicolor-business'),
			'none'    => __('none', 'multicolor-business')
		),
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'multicolor_business_slider' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'multicolor_business_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'multicolor_business_slider' . $count, array(
			'label'    => __( 'Select Slide Image Page', 'multicolor-business' ),
			'section'  => 'multicolor_business_slider_section',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('multicolor_business_slider_excerpt_length',array(
		'default' => '25',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_slider_excerpt_length',array(
		'type' => 'number',
		'label' => __('Slider Excerpt Length','multicolor-business'),
		'section' => 'multicolor_business_slider_section',
	));

	$wp_customize->add_setting('multicolor_business_slider_title_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_slider_title_font_size',array(
		'type' => 'number',
		'label' => __('Title Font Size','multicolor-business'),
		'section' => 'multicolor_business_slider_section',
	));

	$wp_customize->add_setting('multicolor_business_slider_text_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_slider_text_font_size',array(
		'type' => 'number',
		'label' => __('Text Font Size','multicolor-business'),
		'section' => 'multicolor_business_slider_section',
	));

	$wp_customize->add_setting( 'multicolor_business_slider_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multicolor_business_slider_color', array(
		'label' => 'Title Color',
		'section' => 'multicolor_business_slider_section',
	)));

	$wp_customize->add_setting( 'multicolor_business_slider_text_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multicolor_business_slider_text_color', array(
		'label' => 'Text Color',
		'section' => 'multicolor_business_slider_section',
	)));

	$wp_customize->add_setting( 'multicolor_business_slider_btn_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multicolor_business_slider_btn_color', array(
		'label' => 'Button Text Color',
		'section' => 'multicolor_business_slider_section',
	)));

	$wp_customize->add_setting( 'multicolor_business_slider_btnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multicolor_business_slider_btnbg_color', array(
		'label' => 'Button BG Color',
		'section' => 'multicolor_business_slider_section',
	)));

	//	Our Services
	$wp_customize->add_section('multicolor_business_service',array(
		'title'	=> __('Our Services','multicolor-business'),
		'description'=> __('<b>Note :</b> This section will appear below the slider.','multicolor-business'),
		'panel' => 'multicolor_business_panel_id',
	));

	$wp_customize->add_setting('multicolor_business_services_subtitle',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('multicolor_business_services_subtitle',array(
		'label'	=> __('Section Subtitle','multicolor-business'),
		'section'	=> 'multicolor_business_service',
		'setting'	=> 'multicolor_business_services_subtitle',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('multicolor_business_our_services_title',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('multicolor_business_our_services_title',array(
		'label'	=> __('Section Title','multicolor-business'),
		'section'	=> 'multicolor_business_service',
		'setting'	=> 'multicolor_business_our_services_title',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('multicolor_business_services_subtitle_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_services_subtitle_font_size',array(
		'type' => 'number',
		'label' => __('Section Subtitle Font Size','multicolor-business'),
		'section' => 'multicolor_business_service',
	));

	$wp_customize->add_setting('multicolor_business_services_title_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_services_title_font_size',array(
		'type' => 'number',
		'label' => __('Section Title Font Size','multicolor-business'),
		'section' => 'multicolor_business_service',
	));

	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_pst[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_pst[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('multicolor_business_category_setting',array(
		'default'	=> 'select',
		'sanitize_callback' => 'multicolor_business_sanitize_choices',
	));
	$wp_customize->add_control('multicolor_business_category_setting',array(
		'type'    => 'select',
		'choices' => $cat_pst,
		'label' => __('Select Category To Display Post','multicolor-business'),
		'section' => 'multicolor_business_service',
	));

	$wp_customize->add_setting('multicolor_business_services_post_title_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_services_post_title_font_size',array(
		'type' => 'number',
		'label' => __('Title Font Size','multicolor-business'),
		'section' => 'multicolor_business_service',
	));

	$wp_customize->add_setting('multicolor_business_services_post_text_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_services_post_text_font_size',array(
		'type' => 'number',
		'label' => __('Text Font Size','multicolor-business'),
		'section' => 'multicolor_business_service',
	));

	$wp_customize->add_setting('multicolor_business_service_section_padding',array(
      'default' => '',
      'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_service_section_padding',array(
		'type' => 'number',
		'label' => __('Section Top Bottom Padding','multicolor-business'),
		'section' => 'multicolor_business_service',
	));

	$wp_customize->add_setting('multicolor_business_img_hight',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_img_hight',array(
		'type' => 'number',
		'label' => __('Image Hight','multicolor-business'),
		'section' => 'multicolor_business_service',
	));
   
 	$wp_customize->add_setting( 'multicolor_business_service_subheading_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multicolor_business_service_subheading_color', array(
		'label' => 'Subheading Color',
		'section' => 'multicolor_business_service',
	)));

	$wp_customize->add_setting( 'multicolor_business_service_heading_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multicolor_business_service_heading_color', array(
		'label' => 'Heading Color',
		'section' => 'multicolor_business_service',
	)));

	//Footer
 	$wp_customize->add_section( 'multicolor_business_footer', array(
    	'title'      => __( 'Footer Setting', 'multicolor-business' ),
		'priority'   => null,
		'panel' => 'multicolor_business_panel_id'
	) );

	$wp_customize->add_setting('multicolor_business_show_back_totop',array(
 		'default' => true,
   	'sanitize_callback'	=> 'multicolor_business_sanitize_checkbox'
	));
	$wp_customize->add_control('multicolor_business_show_back_totop',array(
   	'type' => 'checkbox',
   	'label' => __('Show / Hide Back to Top','multicolor-business'),
   	'section' => 'multicolor_business_footer'
	));

 	$wp_customize->add_setting('multicolor_business_footer_copy',array(
		'default'	=> 'Multicolor Business WordPress Theme By Luzuk',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('multicolor_business_footer_copy',array(
		'label'	=> __('Copyright Text','multicolor-business'),
		'section'	=> 'multicolor_business_footer',
		'setting'	=> 'multicolor_business_footer_copy',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('multicolor_business_footer_copylink',array(
		'default'	=> 'https://www.luzuk.com/products/free-business-wordpress-theme/',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('multicolor_business_footer_copylink',array(
		'label'	=> __('Copyright Link','multicolor-business'),
		'section'	=> 'multicolor_business_footer',
		'setting'	=> 'multicolor_business_footer_copylink',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('multicolor_business_footer_copy_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
	));
	$wp_customize->add_control('multicolor_business_footer_copy_font_size',array(
		'type' => 'number',
		'label' => __('Copyright Font Size','multicolor-business'),
		'section' => 'multicolor_business_footer',
	));

	$wp_customize->add_setting('multicolor_business_copyright_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'multicolor_business_sanitize_float'
 	));
 	$wp_customize->add_control('multicolor_business_copyright_padding',array(
		'type' => 'number',
		'label' => __('Copyright Top Bottom Padding','multicolor-business'),
		'section' => 'multicolor_business_footer',
	));

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'multicolor_business_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'multicolor_business_customize_partial_blogdescription',
	) );
}
add_action( 'customize_register', 'multicolor_business_customize_register' );

function multicolor_business_customize_partial_blogname() {
	bloginfo( 'name' );
}

function multicolor_business_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

function multicolor_business_is_static_front_page() {
	return ( is_front_page() && ! is_home() );
}

function multicolor_business_is_view_with_layout_option() {
	// This option is available on all pages. It's also available on archives when there isn't a sidebar.
	return ( is_page() || ( is_archive() && ! is_active_sidebar( 'sidebar-1' ) ) );
}

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Multicolor_Business_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Multicolor_Business_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Multicolor_Business_Customize_Section_Pro(
				$manager,
				'multicolor_business_example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__( 'Business Pro Theme', 'multicolor-business' ),
					'pro_text' => esc_html__( 'Go Pro','multicolor-business' ),
					'pro_url'  => esc_url( 'https://www.luzuk.com/products/business-wordpress-theme/' ),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'multicolor-business-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'multicolor-business-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Multicolor_Business_Customize::get_instance();