<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package movers_agency
 */
$movers_agency_single_meta_setting  = get_theme_mod( 'movers_agency_single_post_meta_setting' , true );
$movers_agency_single_content_setting  = get_theme_mod( 'movers_agency_single_post_content_setting' , true );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php

		if ( 'post' === get_post_type() ) : ?>
		<?php
		if ( $movers_agency_single_meta_setting ){ ?>
			<div class="entry-meta">
				<?php movers_agency_posted_on(); ?>
			</div><!-- .entry-meta -->
	    <?php } ?>
		<?php
		endif; ?>
	</header><!-- .entry-header -->
    <?php
	if ( $movers_agency_single_content_setting ){ ?>
		<div class="entry-content" itemprop="text">
			<?php
			if( is_single()){
				the_content( sprintf(
					/* translators: %s: Name of current post. */
					wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'movers-agency' ), array( 'span' => array( 'class' => array() ) ) ),
					the_title( '<span class="screen-reader-text">"', '"</span>', false )
				) );
				}else{
				$movers_agency_excerpt_length = get_theme_mod('movers_agency_post_excerpt_length' ,20);
				    $content = get_the_content();
				    echo esc_html(wp_trim_words($content, $movers_agency_excerpt_length));
				}
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'movers-agency' ),
					'after'  => '</div>',
				) );
			?>
		</div><!-- .entry-content -->
	<?php } ?>
</article><!-- #post-## -->