<?php 
/**
 * Template part for displaying Featured About Section
 *
 * @package Movers Agency
 */

$movers_agency_about = get_theme_mod( 'movers_agency_about_setting',true );
$movers_agency_number_of_featured_mission_items = get_theme_mod( 'movers_agency_number_of_featured_mission_items' ); ?>

<?php if ( $movers_agency_about ){?>
<div id="about-section" class="section-content py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 about-img">
                <?php 
                $movers_agency_image_left = get_theme_mod('movers_agency_image_left');
                if( !empty($movers_agency_image_left) ): ?>
                    <img src="<?php echo esc_url($movers_agency_image_left); ?>" alt="Your Image">
                <?php endif; ?>
            </div>
            <div class="col-lg-6 col-md-12 col-sm-12 col-12">
                <div class="row">
                    <div class="col-xl-3 col-lg-4 col-md-3 col-sm-12 col-12">
                        <ul class="tabs-nav">
                            <?php for( $i = 1; $i <= $movers_agency_number_of_featured_mission_items; $i++ ) : ?>
                                <?php if( get_theme_mod( 'movers_agency_featured_mission_section_tab_'.$i ) ) { ?>
                                    <li class="tabs-nav-box">
                                        <a href="<?php echo('#tab-').$i; ?>">
                                            <?php echo esc_html( get_theme_mod( 'movers_agency_featured_mission_section_tab_'.$i ) ); ?>
                                        </a>
                                    </li>
                                <?php } ?>
                            <?php endfor; ?>
                        </ul>
                    </div>
                    <div class="col-xl-9 col-lg-8 col-md-9 col-sm-12 col-12">
                        <div class="tabs-stage">
                            <?php for( $i=1; $i<=$movers_agency_number_of_featured_mission_items; $i++ ) :
                                
                                $post_id = get_theme_mod( 'movers_agency_banner_slider_content_post_'.$i, true );
                                ?>
                                <div id="<?php echo('tab-').$i ?>" class="featured-mission-box">
                                    <?php 
                                        $args = array(
                                            'post_type'           => 'post',
                                            'posts_per_page'      => 1
                                        );
                                        if ($post_id) {
                                            $args['p'] = $post_id;
                                        }
                                        ?>
                                        <?php
                                        $loop = new WP_Query($args);
                                        if ( $loop->have_posts() ) :
                                            while ($loop->have_posts()) : $loop->the_post(); ?>
                                                    <div class="box-content">
                                                        <h4 class="title mb-3"><a href="<?php the_permalink();?>"><?php the_title();?></a></h4>
                                                        <div class="entry-content mb-4 pb-2">
                                                            <?php
                                                                $movers_agency_excerpt = movers_agency_the_excerpt( 50 );
                                                                echo wp_kses_post( wpautop( $movers_agency_excerpt ) );
                                                            ?>
                                                        </div>
                                                        <div class="abuot-btn">
                                                            <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('BROWSE MORE','movers-agency'); ?></a>
                                                        </div>
                                                    </div>
                                            <?php endwhile;
                                        endif;
                                    ?>
                                </div>
                            <?php endfor; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php } ?>