<?php
/**
 * Banner Section
 * 
 * @package movers_agency
 */
$movers_agency_slider     = get_theme_mod( 'movers_agency_slider_setting',true );
$movers_agency_slider_button_1     = get_theme_mod( 'movers_agency_slider_button_1_setting',true );

$movers_agency_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('movers_agency_blog_slide_category'),
  'posts_per_page' => 3,
); ?>
<?php if ( $movers_agency_slider ){?>
  <div class="banner">
    <div class="owl-carousel">
      <?php $movers_agency_arr_posts = new WP_Query( $movers_agency_args );
      if ( $movers_agency_arr_posts->have_posts() ) :
        while ( $movers_agency_arr_posts->have_posts() ) :
          $movers_agency_arr_posts->the_post();
          ?>
          <div class="banner_inner_box">
            <?php
              if ( has_post_thumbnail() ) :
                the_post_thumbnail();
              else:
                ?>
                <div class="image-container">
                  <img src="<?php echo get_stylesheet_directory_uri() . '/images/banner.png'; ?>">
                </div>
                <?php
              endif;
            ?>
              <div class="banner_box">
                  <h3 class="my-3"><?php the_title(); ?></a></h3>
                  <p class="mb-0"><?php echo wp_trim_words( get_the_content(), 30 ); ?></p>
                  <div class="slider-buttons">
                     <?php if ( $movers_agency_slider_button_1 ){?>
                      <p class="btn-green mt-4">
                        <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('BOOK NOW','movers-agency'); ?><i class="fas fa-angle-double-right ms-2"></i></a>
                      </p>
                    <?php } ?>
                </div>
              </div>
          </div>
        <?php
      endwhile;
      wp_reset_postdata();
      endif; ?>
    </div>
  </div>
<?php } ?>