<?php

/*------------------------------------------------------------------------*/

function movers_agency_sanitize_choices( $input, $setting ) {
        global $wp_customize; 
        $control = $wp_customize->get_control( $setting->id ); 
        if ( array_key_exists( $input, $control->choices ) ) {
            return $input;
        } else {
            return $setting->default;
        }
    }

/*------------------------------------------------------------------------*/

if ( ! function_exists( 'movers_agency_sanitize_checkbox' ) ) :

    /**
     * Sanitize checkbox.
     *
     * @since 1.0.0
     *  
     */
    function movers_agency_sanitize_checkbox( $checked ) {

        return ( ( isset( $checked ) && true === $checked ) ? true : false );

    }

endif;

/*------------------------------------------------------------------------*/

function movers_agency_sanitize_theme_width($input) {
    // Define the valid options
    $valid = array('full-width', 'container-fluid', 'container');
    
    // Check if the input is in the array of valid options, otherwise return the default.
    if (in_array($input, $valid, true)) {
        return $input;
    }
    
    // Default fallback if the input is not valid.
    return 'full-width';
}

/*------------------------------------------------------------------------*/

function movers_agency_get_post_choices() {
    // Initialize the choices array with a default option
    $choices = array( '' => esc_html__( '--Select--', 'movers-agency' ) );

    // Arguments for getting all posts
    $args = array(
        'post_type'      => 'post',
        'numberposts'    => -1,
        'post_status'    => 'publish', // Get only published posts
        'orderby'        => 'title',   // Order by post title
        'order'          => 'ASC'      // Ascending order
    );

    // Get all posts
    $posts = get_posts( $args );

    // Loop through each post and add to the choices array
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }

    // Return the choices array
    return $choices;
}

/*------------------------------------------------------------------------*/

/**
 * Sanitize number range.
 *  
 */
function movers_agency_sanitize_number_range( $input, $setting ) {

    // Ensure input is an absolute integer.
    $input = absint( $input );

    // Get the input attributes associated with the setting.
    $atts = $setting->manager->get_control( $setting->id )->input_attrs;

    // Get min.
    $min = ( isset( $atts['min'] ) ? $atts['min'] : $input );

    // Get max.
    $max = ( isset( $atts['max'] ) ? $atts['max'] : $input );

    // Get Step.
    $step = ( isset( $atts['step'] ) ? $atts['step'] : 1 );

    // If the input is within the valid range, return it; otherwise, return the default.
    return ( $min <= $input && $input <= $max && is_int( $input / $step ) ? $input : $setting->default );

}

    /*------------------------------------------------------------------------*/

    function movers_agency_sanitize_choicess($input) {
    $valid = array(
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Roboto'         => 'Roboto, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
    );

    return (array_key_exists($input, $valid)) ? $input : '';
}

/*------------------------------------------------------------------------*/

    if ( ! function_exists( 'movers_agency_sanitize_number_range' ) ) :

        /**
         * Sanitize number range.
         *  
         */
        function movers_agency_sanitize_number_range( $input, $setting ) {

            // Ensure input is an absolute integer.
            $input = absint( $input );

            // Get the input attributes associated with the setting.
            $atts = $setting->manager->get_control( $setting->id )->input_attrs;

            // Get min.
            $min = ( isset( $atts['min'] ) ? $atts['min'] : $input );

            // Get max.
            $max = ( isset( $atts['max'] ) ? $atts['max'] : $input );

            // Get Step.
            $step = ( isset( $atts['step'] ) ? $atts['step'] : 1 );

            // If the input is within the valid range, return it; otherwise, return the default.
            return ( $min <= $input && $input <= $max && is_int( $input / $step ) ? $input : $setting->default );

        }

    endif;

/*------------------------------------------------------------------------*/

    if ( ! function_exists( 'movers_agency_dropdown_pages' ) ) :
        function movers_agency_dropdown_pages( $page_id, $setting ) {
            // Ensure $input is an absolute integer.
            $page_id = absint( $page_id );
          
            // If $page_id is an ID of a published page, return it; otherwise, return the default.
            return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
        }
    endif;

/*------------------------------------------------------------------------*/

// Sanitize callback function
function movers_agency_sanitize_post_layout($input) {
    $valid = array('one-column', 'right-sidebar', 'left-sidebar', 'three-column', 'four-column');

    if (in_array($input, $valid, true)) {
        return $input;
    }

    return 'right-sidebar'; // Default value if the input is invalid
}

/*------------------------------------------------------------------------*/

function movers_agency_sanitize_scroll_top_alignment($input) {
    $valid = array('right-align', 'center-align', 'left-align');

    if (in_array($input, $valid, true)) {
        return $input;
    }

    return 'right-align'; 
}

/*------------------------------------------------------------------------*/

function movers_agency_sanitize_pagination_alignment($input) {
    $valid = array('right-align', 'center-align', 'left-align');

    if (in_array($input, $valid, true)) {
        return $input;
    }

    return 'left-align'; 
}

/*------------------------------------------------------------------------*/

// Sanitize Sortable control.
function movers_agency_sanitize_sortable( $val, $setting ) {
    if ( is_string( $val ) || is_numeric( $val ) ) {
        return array(
            esc_attr( $val ),
        );
    }
    $sanitized_value = array();
    foreach ( $val as $item ) {
        if ( isset( $setting->manager->get_control( $setting->id )->choices[ $item ] ) ) {
            $sanitized_value[] = esc_attr( $item );
        }
    }
    return $sanitized_value;
}