<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package movers_agency
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function movers_agency_body_classes( $classes ) {
  global $post;
  
    if( !is_page_template( 'template-home.php' ) ){
        $classes[] = 'inner';
        // Adds a class of group-blog to blogs with more than 1 published author.
    }

	if ( is_multi_author() ) {
		$classes[] = 'group-blog ';
	}

    // Adds a class of custom-background-image to sites with a custom background image.
    if ( get_background_image() ) {
        $classes[] = 'custom-background-image';
    }
    
    // Adds a class of custom-background-color to sites with a custom background color.
    if ( get_background_color() != 'ffffff' ) {
        $classes[] = 'custom-background-color';
    }
    

    if( movers_agency_woocommerce_activated() && ( is_shop() || is_product_category() || is_product_tag() || 'product' === get_post_type() ) && ! is_active_sidebar( 'shop-sidebar' ) ){
        $classes[] = 'full-width';
    }    

    // Adds a class of hfeed to non-singular pages.
    if ( ! is_page() ) {
    	$classes[] = 'hfeed ';
    }
  
    if( is_404() ||  is_search() ){
        $classes[] = 'full-width';
    }
  
    if( ! is_active_sidebar( 'right-sidebar' ) ) {
        $classes[] = 'full-width'; 
    }

	return $classes;
}
add_filter( 'body_class', 'movers_agency_body_classes' );

 /**
 * 
 * @link http://www.altafweb.com/2011/12/remove-specific-tag-from-php-string.html
 */
function movers_agency_strip_single( $tag, $string ){
    $string=preg_replace('/<'.$tag.'[^>]*>/i', '', $string);
    $string=preg_replace('/<\/'.$tag.'>/i', '', $string);
    return $string;
}

if ( ! function_exists( 'movers_agency_excerpt_more' ) ) :
/**
 * Replaces "[...]" (appended to automatically generated excerpts) with ... * 
 */
function movers_agency_excerpt_more($more) {
  return is_admin() ? $more : ' &hellip; ';
}
endif;
add_filter( 'excerpt_more', 'movers_agency_excerpt_more' );

if( ! function_exists( 'movers_agency_footer_credit' ) ):
/**
 * Footer Credits
*/
function movers_agency_footer_credit() {
    // Check if footer copyright is enabled
    $movers_agency_show_footer_copyright = get_theme_mod( 'movers_agency_footer_setting', true );

    if ( ! $movers_agency_show_footer_copyright ) {
        return; 
    }
    $movers_agency_copyright_text = get_theme_mod('movers_agency_footer_copyright_text');

    $movers_agency_text = '<div class="site-info"><div class="container"><span class="copyright">';
    if ($movers_agency_copyright_text) {
        $movers_agency_text .= wp_kses_post($movers_agency_copyright_text); 
    } else {
        $movers_agency_text .= esc_html__('&copy; ', 'movers-agency') . date_i18n(esc_html__('Y', 'movers-agency')); 
        $movers_agency_text .= ' <a href="' . esc_url(home_url('/')) . '">' . esc_html(get_bloginfo('name')) . '</a>' . esc_html__('. All Rights Reserved.', 'movers-agency');
    }
    $movers_agency_text .= '</span>';
    $movers_agency_text .= '<span class="by"> <a href="' . esc_url('https://www.themeignite.com/products/free-moving-company-wordpress-theme') . '" rel="nofollow" target="_blank">' . MOVERS_AGENCY_THEME_NAME . '</a>' . esc_html__(' By ', 'movers-agency') . '<a href="' . esc_url('https://themeignite.com/') . '" rel="nofollow" target="_blank">' . esc_html__('Themeignite', 'movers-agency') . '</a>.';
    $movers_agency_text .= sprintf(esc_html__(' Powered By %s', 'movers-agency'), '<a href="' . esc_url(__('https://wordpress.org/', 'movers-agency')) . '" target="_blank">WordPress</a>.');
    if (function_exists('the_privacy_policy_link')) {
        $movers_agency_text .= get_the_privacy_policy_link();
    }
    $movers_agency_text .= '</span></div></div>';
    echo apply_filters('movers_agency_footer_text', $movers_agency_text);
}
add_action('movers_agency_footer', 'movers_agency_footer_credit');
endif;


/**
 * Is Woocommerce activated
*/
if ( ! function_exists( 'movers_agency_woocommerce_activated' ) ) {
  function movers_agency_woocommerce_activated() {
    if ( class_exists( 'woocommerce' ) ) { return true; } else { return false; }
  }
}

if( ! function_exists( 'movers_agency_change_comment_form_default_fields' ) ) :
/**
 * Change Comment form default fields i.e. author, email & url.
 * https://blog.josemcastaneda.com/2016/08/08/copy-paste-hurting-theme/
*/
function movers_agency_change_comment_form_default_fields( $fields ){    
    // get the current commenter if available
    $commenter = wp_get_current_commenter();
 
    // core functionality
    $req      = get_option( 'require_name_email' );
    $aria_req = ( $req ? " aria-required='true'" : '' );
    $required = ( $req ? " required" : '' );
    $author   = ( $req ? __( 'Name*', 'movers-agency' ) : __( 'Name', 'movers-agency' ) );
    $email    = ( $req ? __( 'Email*', 'movers-agency' ) : __( 'Email', 'movers-agency' ) );
 
    // Change just the author field
    $fields['author'] = '<p class="comment-form-author"><label class="screen-reader-text" for="author">' . esc_html__( 'Name', 'movers-agency' ) . '<span class="required">*</span></label><input id="author" name="author" placeholder="' . esc_attr( $author ) . '" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . $required . ' /></p>';
    
    $fields['email'] = '<p class="comment-form-email"><label class="screen-reader-text" for="email">' . esc_html__( 'Email', 'movers-agency' ) . '<span class="required">*</span></label><input id="email" name="email" placeholder="' . esc_attr( $email ) . '" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . $required. ' /></p>';
    
    $fields['url'] = '<p class="comment-form-url"><label class="screen-reader-text" for="url">' . esc_html__( 'Website', 'movers-agency' ) . '</label><input id="url" name="url" placeholder="' . esc_attr__( 'Website', 'movers-agency' ) . '" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" /></p>'; 
    
    return $fields;    
}
endif;
add_filter( 'comment_form_default_fields', 'movers_agency_change_comment_form_default_fields' );

if( ! function_exists( 'movers_agency_change_comment_form_defaults' ) ) :
/**
 * Change Comment Form defaults
 * https://blog.josemcastaneda.com/2016/08/08/copy-paste-hurting-theme/
*/
function movers_agency_change_comment_form_defaults( $defaults ){    
    $defaults['comment_field'] = '<p class="comment-form-comment"><label class="screen-reader-text" for="comment">' . esc_html__( 'Comment', 'movers-agency' ) . '</label><textarea id="comment" name="comment" placeholder="' . esc_attr__( 'Comment', 'movers-agency' ) . '" cols="45" rows="8" aria-required="true" required></textarea></p>';
    
    return $defaults;    
}
endif;
add_filter( 'comment_form_defaults', 'movers_agency_change_comment_form_defaults' );

if( ! function_exists( 'movers_agency_escape_text_tags' ) ) :
/**
 * Remove new line tags from string
 *
 * @param $text
 * @return string
 */
function movers_agency_escape_text_tags( $text ) {
    return (string) str_replace( array( "\r", "\n" ), '', strip_tags( $text ) );
}
endif;

if( ! function_exists( 'wp_body_open' ) ) :
/**
 * Fire the wp_body_open action.
 * Added for backwards compatibility to support pre 5.2.0 WordPress versions.
*/
function wp_body_open() {
	/**
	 * Triggered after the opening <body> tag.
    */
	do_action( 'wp_body_open' );
}
endif;

if ( ! function_exists( 'movers_agency_get_fallback_svg' ) ) :    
/**
 * Get Fallback SVG
*/
function movers_agency_get_fallback_svg( $movers_agency_post_thumbnail ) {
    if( ! $movers_agency_post_thumbnail ){
        return;
    }
    
    $movers_agency_image_size = movers_agency_get_image_sizes( $movers_agency_post_thumbnail );
     
    if( $movers_agency_image_size ){ ?>
        <div class="svg-holder">
             <svg class="fallback-svg" viewBox="0 0 <?php echo esc_attr( $movers_agency_image_size['width'] ); ?> <?php echo esc_attr( $movers_agency_image_size['height'] ); ?>" preserveAspectRatio="none">
                    <rect width="<?php echo esc_attr( $movers_agency_image_size['width'] ); ?>" height="<?php echo esc_attr( $movers_agency_image_size['height'] ); ?>" style="fill:#dedddd;"></rect>
            </svg>
        </div>
        <?php
    }
}
endif;

if ( ! function_exists( 'movers_agency_the_excerpt' ) ) :

    /**
     * Generate excerpt.
     *
     * @since 1.0.0
     *
     * @param int     $length Excerpt length in words.
     * @param WP_Post $post_obj WP_Post instance (Optional).
     * @return string Excerpt.
     */
    function movers_agency_the_excerpt( $length = 0, $post_obj = null ) {

        global $post;

        if ( is_null( $post_obj ) ) {
            $post_obj = $post;
        }

        $length = absint( $length );

        if ( 0 === $length ) {
            return;
        }

        $source_content = $post_obj->post_content;

        if ( ! empty( $post_obj->post_excerpt ) ) {
            $source_content = $post_obj->post_excerpt;
        }

        $source_content = preg_replace( '`\[[^\]]*\]`', '', $source_content );
        $trimmed_content = wp_trim_words( $source_content, $length, '&hellip;' );
        return $trimmed_content;

    }

endif;

function movers_agency_enqueue_google_fonts() {

    require get_template_directory() . '/inc/wptt-webfont-loader.php';

    wp_enqueue_style(
        'google-fonts-montserrat',
        wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap' ),
        array(),
        '1.0'
    );

}
add_action( 'wp_enqueue_scripts', 'movers_agency_enqueue_google_fonts' );


if( ! function_exists( 'movers_agency_site_branding' ) ) :
/**
 * Site Branding
*/
function movers_agency_site_branding(){
    $movers_agency_logo_site_title = get_theme_mod( 'header_site_title', 0 );
    $movers_agency_tagline = get_theme_mod( 'header_tagline', false );
    $movers_agency_logo_width = get_theme_mod('logo_width', 100); // Retrieve the logo width setting

    ?>
    <div class="site-branding text-left">
        <?php 
        // Check if custom logo is set and display it
        if (function_exists('has_custom_logo') && has_custom_logo()) {
            the_custom_logo();
        }
        if ($movers_agency_logo_site_title) {
            if (is_front_page()) { ?>
                <h1 class="site-title" itemprop="name">
                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                </h1>
            <?php } else { ?>
                <p class="site-title" itemprop="name">
                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                </p>
            <?php }
        }
        
        if ($movers_agency_tagline) {
            $movers_agency_description = get_bloginfo('description', 'display');
            if ($movers_agency_description || is_customize_preview()) { ?>
                <p class="site-description" itemprop="description"><?php echo $movers_agency_description; ?></p>
            <?php }
        }
        ?>
    </div>

    <?php
}
endif;

/**
 * Site Navigation
*/
if( ! function_exists( 'movers_agency_navigation' ) ) :
function movers_agency_navigation(){ ?>
    <div class="header-menu-inner">
        <div class="row">
            <div class="col-xl-2 col-lg-3 col-md-4 align-self-center logo-main">
              <?php movers_agency_site_branding(); ?> 
            </div>
            <div class="col-xl-8 col-lg-7 col-md-4 align-self-center text-lg-end text-center">
                <nav class="main-navigation" id="site-navigation"  role="navigation">
                    <?php 
                    wp_nav_menu( array( 
                        'theme_location' => 'primary', 
                        'menu_id' => 'primary-menu' 
                    ) ); 
                    ?>
                </nav>
            </div>
            <div class="col-xl-2 col-lg-2 col-md-4 align-self-center text-lg-end">
                <?php if( get_theme_mod('movers_agency_show_hide_search',false) != ''){ ?>
                    <span class="search-body text-center align-self-center text-md-end">
                        <button type="button" class="search-show"><i class="fas fa-search"></i></button>
                    </span>
                    <?php } ?>
                    <div class="searchform-inner">
                        <?php get_search_form(); ?>
                        <button type="button" class="close"aria-label="<?php esc_attr_e( 'Close', 'movers-agency' ); ?>"><span aria-hidden="true">X</span></button>
                    </div>
                <?php if(class_exists('woocommerce')){ ?>
                    <span class="product-account">
                        <?php if ( is_user_logged_in() ) { ?>
                          <a href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>" title="<?php esc_attr_e('My Account','movers-agency'); ?>"><i class="fas fa-user"></i></a>
                        <?php } 
                        else { ?>
                          <a href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>" title="<?php esc_attr_e('Login / Register','movers-agency'); ?>"><i class="fas fa-user"></i></a>
                        <?php } ?>
                    </span>
                <?php }?>
            </div>
        </div>
    </div>
    <?php
}
endif;


/**
 * Header Start
*/
if( ! function_exists( 'movers_agency_top_header' ) ) :
function movers_agency_top_header(){
    $movers_agency_header_setting     = get_theme_mod( 'movers_agency_header_setting', false );
    $movers_agency_phone        = get_theme_mod( 'movers_agency_header_phone' );
    $movers_agency_email        = get_theme_mod( 'movers_agency_header_email' );
    $movers_agency_location     = get_theme_mod( 'movers_agency_header_location' );
    $movers_agency_timing     = get_theme_mod( 'movers_agency_header_timing' );
    ?>
    <?php if ( $movers_agency_header_setting ){?>
        <div class="top-header">
            <div class="container">
                <div class="row top-bg">
                    <div class="col-lg-4 col-md-4 col-sm-12 col-12 align-self-center">
                        <?php if ( $movers_agency_location ){?>
                            <div class="location">
                                <span class="contact-icon">
                                    <i class="fas fa-map-marker-alt"></i>
                                </span>
                                <span class="contact-box">
                                    <span class="contact-heading"><?php echo esc_html('Moving Company','movers-agency' );?></span>
                                    <span class="location-text"><?php echo esc_html( $movers_agency_location );?></span>
                                </span>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12 col-12 align-self-center">
                        <?php if ( $movers_agency_phone ){?>
                            <div class="location">
                                <span class="contact-icon">
                                    <i class="fas fa-phone-alt"></i>
                                </span>
                                <span class="contact-box">
                                    <span class="contact-heading"><?php echo esc_html('Moving Company','movers-agency' );?></span>
                                    <span class="location-text">
                                        <a href="tel:<?php echo esc_attr($movers_agency_phone);?>">
                                            <?php echo esc_html( $movers_agency_phone);?>
                                        </a>
                                    </span>
                                    <span class="location-text">
                                        <a href="mailto:<?php echo esc_attr($movers_agency_email);?>">
                                            <?php echo esc_html($movers_agency_email);?>
                                        </a>
                                    </span>
                                </span>
                                
                            </div>
                        <?php } ?>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12 col-12 align-self-center">
                        <?php if ( $movers_agency_timing ){?>
                            <div class="location">
                                <span class="contact-icon">
                                    <i class="far fa-clock"></i>
                                </span>
                                <span class="contact-box">
                                    <span class="contact-heading"><?php echo esc_html('Opening Time','movers-agency' );?></span>
                                    <span class="location-text"><?php echo esc_html( $movers_agency_timing );?></span>
                                </span>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
    <?php
}
endif;


/**
 * Header Start
*/
if( ! function_exists( 'movers_agency_header' ) ) :
function movers_agency_header(){
    ?>
    <?php $movers_agency_header_image = get_header_image(); ?>
    <div id="page-site-header">
        <header id="masthead" class="site-header header-inner" role="banner">
            <div id="main-header" class="header-menu" style="background-image: url('<?php echo esc_url($movers_agency_header_image); ?>') !important; background-size: 100%;">
                <div class="container">
                    <?php movers_agency_navigation(); ?>
                    <?php movers_agency_top_header(); ?>
                </div>
            </div>        
        </header>
    </div>
    <?php
}
endif;
add_action( 'movers_agency_header', 'movers_agency_header', 20 );