<?php
/**
 * Movers Agency Theme Customizer.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package movers_agency
 */

if( ! function_exists( 'movers_agency_customize_register' ) ):  
/**
 * Add postMessage support for site title and description for the Theme Customizer.F
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function movers_agency_customize_register( $wp_customize ) {
    require get_parent_theme_file_path('/inc/controls/changeable-icon.php');

    require get_parent_theme_file_path('/inc/controls/sortable-control.php');
    
    //Register the sortable control type.
    $wp_customize->register_control_type( 'Movers_Agency_Control_Sortable' ); 

    if ( version_compare( get_bloginfo('version'),'4.9', '>=') ) {
        $wp_customize->get_section( 'static_front_page' )->title = __( 'Static Front Page', 'movers-agency' );
    }
	
    /* Option list of all post */	
    $movers_agency_options_posts = array();
    $movers_agency_options_posts_obj = get_posts('posts_per_page=-1');
    $movers_agency_options_posts[''] = esc_html__( 'Choose Post', 'movers-agency' );
    foreach ( $movers_agency_options_posts_obj as $movers_agency_posts ) {
    	$movers_agency_options_posts[$movers_agency_posts->ID] = $movers_agency_posts->post_title;
    }
    
    /* Option list of all categories */
    $movers_agency_args = array(
	   'type'                     => 'post',
	   'orderby'                  => 'name',
	   'order'                    => 'ASC',
	   'hide_empty'               => 1,
	   'hierarchical'             => 1,
	   'taxonomy'                 => 'category'
    ); 
    $movers_agency_option_categories = array();
    $movers_agency_category_lists = get_categories( $movers_agency_args );
    $movers_agency_option_categories[''] = esc_html__( 'Choose Category', 'movers-agency' );
    foreach( $movers_agency_category_lists as $movers_agency_category ){
        $movers_agency_option_categories[$movers_agency_category->term_id] = $movers_agency_category->name;
    }
    
    /** Default Settings */    
    $wp_customize->add_panel( 
        'wp_default_panel',
         array(
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => esc_html__( 'Default Settings', 'movers-agency' ),
            'description' => esc_html__( 'Default section provided by wordpress customizer.', 'movers-agency' ),
        ) 
    );
    
    $wp_customize->get_section( 'title_tagline' )->panel                  = 'wp_default_panel';
    $wp_customize->get_section( 'colors' )->panel                         = 'wp_default_panel';
    $wp_customize->get_section( 'header_image' )->panel                   = 'wp_default_panel';
    $wp_customize->get_section( 'background_image' )->panel               = 'wp_default_panel';
    $wp_customize->get_section( 'static_front_page' )->panel              = 'wp_default_panel';
    
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    
    /** Default Settings Ends */

     /** Site Title control */
    $wp_customize->add_setting( 
        'header_site_title', 
        array(
            'default'           => false,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_site_title',
        array(
            'label'       => __( 'Show / Hide Site Title', 'movers-agency' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    /** Tagline control */
    $wp_customize->add_setting( 
        'header_tagline', 
        array(
            'default'           => false,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_tagline',
        array(
            'label'       => __( 'Show / Hide Tagline', 'movers-agency' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('logo_width', array(
        'sanitize_callback' => 'absint', 
    ));

    // Add a control for logo width
    $wp_customize->add_control('logo_width', array(
        'label' => __('Logo Width', 'movers-agency'),
        'section' => 'title_tagline',
        'type' => 'number',
        'input_attrs' => array(
            'min' => '50', 
            'max' => '500', 
            'step' => '5', 
    ),
        'default' => '100', 
    ));

        /** Responsive Media settings */
    
    $wp_customize->add_section(
        'movers_agency_responsive_media_section',
        array(
            'title' => esc_html__( 'Responsive Media Settings', 'movers-agency' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'movers_agency_general_settings',
        )
    );

    /** Scroll to top Responsive control */
    $wp_customize->add_setting( 
        'movers_agency_resp_scroll_top', 
        array(
            'default' => 1,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_resp_scroll_top',
        array(
            'label'       => __( 'Show Scroll To Top', 'movers-agency' ),
            'section'     => 'movers_agency_responsive_media_section',
            'type'        => 'checkbox',
        )
    );

        /** Scroll to top Responsive control */
    $wp_customize->add_setting( 
        'movers_agency_resp_loader', 
        array(
            'default' => 0,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_resp_loader',
        array(
            'label'       => __( 'Show Preloader', 'movers-agency' ),
            'section'     => 'movers_agency_responsive_media_section',
            'type'        => 'checkbox',
        )
    );

    /** Responsive Media Ends */

    //Global Color
    $wp_customize->add_section(
        'movers_agency_global_color',
        array(
            'title' => esc_html__( 'Global Color Settings', 'movers-agency' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'movers_agency_general_settings',
        )
    );

    $wp_customize->add_setting('movers_agency_primary_color', array(
        'default'           => '#153655',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'movers_agency_primary_color', array(
        'label'    => __('Theme Primary Color', 'movers-agency'),
        'section'  => 'movers_agency_global_color',
        'settings' => 'movers_agency_primary_color',
    )));  

    $wp_customize->add_setting('movers_agency_secondary_color', array(
        'default'           => '#00baff',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'movers_agency_secondary_color', array(
        'label'    => __('Theme Secondary Color', 'movers-agency'),
        'section'  => 'movers_agency_global_color',
        'settings' => 'movers_agency_secondary_color',
    ))); 

    $wp_customize->add_setting('movers_agency_tertiary_color', array(
        'default'           => '#0c1239',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'movers_agency_tertiary_color', array(
        'label'    => __('Theme Tertiary Color', 'movers-agency'),
        'section'  => 'movers_agency_global_color',
        'settings' => 'movers_agency_tertiary_color',
    ))); 

    /** Post & Pages Settings */
    $wp_customize->add_panel( 
        'movers_agency_home_post_settings',
         array(
            'priority' => 9,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Post & Pages Settings', 'movers-agency' ),
            'description' => esc_html__( 'Customize Post & Pages Settings', 'movers-agency' ),
        ) 
    );

        /** Post Layouts */
    
    $wp_customize->add_section(
        'movers_agency_post_layout_section',
        array(
            'title' => esc_html__( 'Post Layout Settings', 'movers-agency' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'movers_agency_home_post_settings',
        )
    );

    $wp_customize->add_setting('movers_agency_post_layout_setting', array(
        'default'           => 'right-sidebar',
        'sanitize_callback' => 'movers_agency_sanitize_post_layout',
    ));

    $wp_customize->add_control('movers_agency_post_layout_setting', array(
        'label'    => __('Post Column Settings', 'movers-agency'),
        'section'  => 'movers_agency_post_layout_section',
        'settings' => 'movers_agency_post_layout_setting',
        'type'     => 'select',
        'choices'  => array(
            'one-column'   => __('One Column', 'movers-agency'),
            'right-sidebar'   => __('Right Sidebar', 'movers-agency'),
            'left-sidebar'   => __('Left Sidebar', 'movers-agency'),
            'three-column'   => __('Three Columns', 'movers-agency'),
            'four-column'   => __('Four Columns', 'movers-agency'),
        ),
    ));

    $wp_customize->add_setting('movers_agency_archive_pagination_alignment',array(
        'default' => 'left-align',
        'sanitize_callback' => 'movers_agency_sanitize_pagination_alignment'
    ));
    $wp_customize->add_control('movers_agency_archive_pagination_alignment',array(
        'type' => 'select',
        'label' => __('Pagination Alignment','movers-agency'),
        'section' => 'movers_agency_post_layout_section',
        'choices' => array(
            'right-align' => __('Right Alignment','movers-agency'),
            'center-align' => __('Center Alignment','movers-agency'),
            'left-align' => __('Left Alignment','movers-agency'),
        ),
    ) );

     /** Post Layouts Ends */


    /** Post Settings */
    $wp_customize->add_section(
        'movers_agency_post_settings',
        array(
            'title' => esc_html__( 'Post Settings', 'movers-agency' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'movers_agency_home_post_settings',
        )
    );

    // Excerpt Length
    $wp_customize->add_section(
        'movers_agency_post_excerpt_length', 
        array(    
            'title'       => __('Excerpt Length', 'movers-agency'),
            'panel'       => 'theme_option_panel'    
        )
    );

    $wp_customize->add_setting( 
        'movers_agency_post_excerpt_length', 
        array(
            'default'           => '50',
            'sanitize_callback' => 'movers_agency_sanitize_number_range',
    ) );
    $wp_customize->add_control( 
        'movers_agency_post_excerpt_length', 
        array(
            'label'       => esc_html__( 'Excerpt Length', 'movers-agency' ),
            'section'     => 'movers_agency_post_settings',
            'type'        => 'number',
            'input_attrs' => array( 'min' => 1, 'max' => 200, 'style' => 'width: 100%;' ),
    ) );

    /** Post Heading control */
    $wp_customize->add_setting( 
        'movers_agency_post_heading_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_post_heading_setting',
        array(
            'label'       => __( 'Show / Hide Post Heading', 'movers-agency' ),
            'section'     => 'movers_agency_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Meta control */
    $wp_customize->add_setting( 
        'movers_agency_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Post Meta', 'movers-agency' ),
            'section'     => 'movers_agency_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Image control */
    $wp_customize->add_setting( 
        'movers_agency_post_image_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_post_image_setting',
        array(
            'label'       => __( 'Show / Hide Post Image', 'movers-agency' ),
            'section'     => 'movers_agency_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Content control */
    $wp_customize->add_setting( 
        'movers_agency_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Post Content', 'movers-agency' ),
            'section'     => 'movers_agency_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post ReadMore control */
     $wp_customize->add_setting( 'movers_agency_read_more_setting', array(
        'default'           => true,
        'sanitize_callback' => 'movers_agency_sanitize_checkbox',
    ) );

    $wp_customize->add_control( 'movers_agency_read_more_setting', array(
        'type'        => 'checkbox',
        'section'     => 'movers_agency_post_settings', 
        'label'       => __( 'Display Read More Button', 'movers-agency' ),
    ) );

    $wp_customize->add_setting('movers_agency_blog_meta_order', array(
        'default' => array('heading', 'author', 'featured-image', 'content','button'),
        'sanitize_callback' => 'movers_agency_sanitize_sortable',
    ));
    $wp_customize->add_control(new Movers_Agency_Control_Sortable($wp_customize, 'movers_agency_blog_meta_order', array(
        'label' => esc_html__('Post Meta Ordering', 'movers-agency'),
        'description' => __('Drag & drop post items to rearrange the ordering ( this control will not function by post format )', 'movers-agency') ,
        'section' => 'movers_agency_post_settings',
        'choices' => array(
            'heading' => __('heading', 'movers-agency') ,
            'author' => __('author', 'movers-agency') ,
            'featured-image' => __('featured-image', 'movers-agency') ,
            'content' => __('content', 'movers-agency') ,
            'button' => __('button', 'movers-agency') ,
        ) ,
    )));

    /** Post Settings Ends */

    /** Single Post Settings */
    $wp_customize->add_section(
        'movers_agency_single_post_settings',
        array(
            'title' => esc_html__( 'Single Post Settings', 'movers-agency' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'movers_agency_home_post_settings',
        )
    );

    /** Single Post Meta control */
    $wp_customize->add_setting( 
        'movers_agency_single_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_single_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Meta', 'movers-agency' ),
            'section'     => 'movers_agency_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Content control */
    $wp_customize->add_setting( 
        'movers_agency_single_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_single_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Content', 'movers-agency' ),
            'section'     => 'movers_agency_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Settings Ends */

      // Typography Settings Section
    $wp_customize->add_section('movers_agency_typography_settings', array(
        'title'      => esc_html__('Typography Settings', 'movers-agency'),
        'priority'   => 30,
        'capability' => 'edit_theme_options',
        'panel' => 'movers_agency_general_settings',
    ));

    // Array of fonts to choose from
    $font_choices = array(
        ''               => __('Select', 'movers-agency'),
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Roboto'         => 'Roboto, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
        'Libre Baskerville' => 'Libre Baskerville',
    );

    // Heading Font Setting
    $wp_customize->add_setting('movers_agency_heading_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'movers_agency_sanitize_choicess',
    ));
    $wp_customize->add_control('movers_agency_heading_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Heading', 'movers-agency'),
        'section' => 'movers_agency_typography_settings',
    ));

    // Body Font Setting
    $wp_customize->add_setting('movers_agency_body_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'movers_agency_sanitize_choicess',
    ));
    $wp_customize->add_control('movers_agency_body_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Body', 'movers-agency'),
        'section' => 'movers_agency_typography_settings',
    ));

    /** Typography Settings Section End */

    /** General Settings */
    $wp_customize->add_panel( 
        'movers_agency_general_settings',
         array(
            'priority' => 9,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'General Settings', 'movers-agency' ),
            'description' => esc_html__( 'Customize General Settings', 'movers-agency' ),
        ) 
    );

    /** General Settings */
    $wp_customize->add_section(
        'movers_agency_general_settings',
        array(
            'title' => esc_html__( 'Loader Settings', 'movers-agency' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'movers_agency_general_settings',
        )
    );

    /** Preloader control */
    $wp_customize->add_setting( 
        'movers_agency_preloader_setting', 
        array(
            'default'           => false,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_preloader_setting',
        array(
            'label'       => __( 'Show / Hide Preloader', 'movers-agency' ),
            'section'     => 'movers_agency_general_settings',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('movers_agency_theme_width',array(
        'default' => 'full-width',
        'sanitize_callback' => 'movers_agency_sanitize_theme_width'
    ));
    $wp_customize->add_control('movers_agency_theme_width',array(
        'type' => 'select',
        'label' => __('Theme Width Option','movers-agency'),
        'section' => 'movers_agency_general_settings',
        'choices' => array(
            'full-width' => __('Fullwidth','movers-agency'),
            'container' => __('Container','movers-agency'),
            'container-fluid' => __('Container Fluid','movers-agency'),
        ),
    ) );

    /** General Settings Ends */

    /** Header Section Settings */
    $wp_customize->add_section(
        'movers_agency_header_section_settings',
        array(
            'title' => esc_html__( 'Header Section Settings', 'movers-agency' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'movers_agency_home_page_settings',
        )
    );

    /** Header Section control */
    $wp_customize->add_setting( 
        'movers_agency_header_setting', 
        array(
            'default' => false ,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_header_setting',
        array(
            'label'       => __( 'Show Header', 'movers-agency' ),
            'section'     => 'movers_agency_header_section_settings',
            'type'        => 'checkbox',
        )
    );

     /** Location */
    $wp_customize->add_setting(
        'movers_agency_header_location',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'movers_agency_header_location',
        array(
            'label' => esc_html__( 'Add Location', 'movers-agency' ),
            'section' => 'movers_agency_header_section_settings',
            'type' => 'text',
        )
    );

     /** Phone */
    $wp_customize->add_setting(
        'movers_agency_header_phone',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'movers_agency_header_phone',
        array(
            'label' => esc_html__( 'Add Phone', 'movers-agency' ),
            'section' => 'movers_agency_header_section_settings',
            'type' => 'text',
        )
    );

     /** Email */
    $wp_customize->add_setting(
        'movers_agency_header_email',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'movers_agency_header_email',
        array(
            'label' => esc_html__( 'Add Email', 'movers-agency' ),
            'section' => 'movers_agency_header_section_settings',
            'type' => 'text',
        )
    );

     /** Location */
    $wp_customize->add_setting(
        'movers_agency_header_timing',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'movers_agency_header_timing',
        array(
            'label' => esc_html__( 'Add Timing', 'movers-agency' ),
            'section' => 'movers_agency_header_section_settings',
            'type' => 'text',
        )
    );

    $wp_customize->add_setting( 
        'movers_agency_show_hide_search', 
        array(
            'default' => false ,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_show_hide_search',
        array(
            'label'       => __( 'Show Search Icon', 'movers-agency' ),
            'section'     => 'movers_agency_header_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Add Setting for Menu Font Weight
    $wp_customize->add_setting( 'movers_agency_menu_font_weight', array(
        'default'           => '600',
        'sanitize_callback' => 'movers_agency_sanitize_font_weight',
    ) );

    // Add Control for Menu Font Weight
    $wp_customize->add_control( 'movers_agency_menu_font_weight', array(
        'label'    => __( 'Menu Font Weight', 'movers-agency' ),
        'section'  => 'movers_agency_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            '100' => __( '100 - Thin', 'movers-agency' ),
            '200' => __( '200 - Extra Light', 'movers-agency' ),
            '300' => __( '300 - Light', 'movers-agency' ),
            '400' => __( '400 - Normal', 'movers-agency' ),
            '500' => __( '500 - Medium', 'movers-agency' ),
            '600' => __( '600 - Semi Bold', 'movers-agency' ),
            '700' => __( '700 - Bold', 'movers-agency' ),
            '800' => __( '800 - Extra Bold', 'movers-agency' ),
            '900' => __( '900 - Black', 'movers-agency' ),
        ),
    ) );

    // Add Setting for Menu Text Transform
    $wp_customize->add_setting( 'movers_agency_menu_text_transform', array(
        'default'           => 'capitalize',
        'sanitize_callback' => 'movers_agency_sanitize_text_transform',
    ) );

    // Add Control for Menu Text Transform
    $wp_customize->add_control( 'movers_agency_menu_text_transform', array(
        'label'    => __( 'Menu Text Transform', 'movers-agency' ),
        'section'  => 'movers_agency_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            'none'       => __( 'None', 'movers-agency' ),
            'capitalize' => __( 'Capitalize', 'movers-agency' ),
            'uppercase'  => __( 'Uppercase', 'movers-agency' ),
            'lowercase'  => __( 'Lowercase', 'movers-agency' ),
        ),
    ) );
   
    $wp_customize->add_setting('movers_agency_menus_style',array(
        'default' => '',
        'sanitize_callback' => 'movers_agency_sanitize_choices'
	));
	$wp_customize->add_control('movers_agency_menus_style',array(
        'type' => 'select',
		'label' => __('Menu Hover Style','movers-agency'),
		'section' => 'movers_agency_header_section_settings',
		'choices' => array(
         'None' => __('None','movers-agency'),
         'Zoom In' => __('Zoom In','movers-agency'),
      ),
	));
   
    /** Header Section Settings End */

    /** Home Page Settings */
    $wp_customize->add_panel( 
        'movers_agency_home_page_settings',
         array(
            'priority' => 9,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Home Page Settings', 'movers-agency' ),
            'description' => esc_html__( 'Customize Home Page Settings', 'movers-agency' ),
        ) 
    );

    /** Slider Section Settings */
    $wp_customize->add_section(
        'movers_agency_slider_section_settings',
        array(
            'title' => esc_html__( 'Slider Section Settings', 'movers-agency' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'movers_agency_home_page_settings',
        )
    );

    /** Slider Section control */
    $wp_customize->add_setting( 
        'movers_agency_slider_setting', 
        array(
            'default' => true ,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_slider_setting',
        array(
            'label'       => __( 'Show Slider', 'movers-agency' ),
            'section'     => 'movers_agency_slider_section_settings',
            'type'        => 'checkbox',
        )
    );
    
    $categories = get_categories();
        $cat_posts = array();
            $i = 0;
            $cat_posts[]='Select';
        foreach($categories as $category){
            if($i==0){
            $default = $category->slug;
            $i++;
        }
        $cat_posts[$category->slug] = $category->name;
    }

    $wp_customize->add_setting(
        'movers_agency_blog_slide_category',
        array(
            'default'   => 'select',
            'sanitize_callback' => 'movers_agency_sanitize_choices',
        )
    );
    $wp_customize->add_control(
        'movers_agency_blog_slide_category',
        array(
            'type'    => 'select',
            'choices' => $cat_posts,
            'label' => __('Select Category to display Slider Post','movers-agency'),
            'section' => 'movers_agency_slider_section_settings',
        )
    );

    /** Slider Section control */
    $wp_customize->add_setting( 
        'movers_agency_slider_button_1_setting', 
        array(
            'default' => true ,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_slider_button_1_setting',
        array(
            'label'       => __( 'Show Slider Button', 'movers-agency' ),
            'section'     => 'movers_agency_slider_section_settings',
            'type'        => 'checkbox',
        )
    );

    /** About Section Settings */
    
    $wp_customize->add_section( 'movers_agency_section_featured_about',
        array(
        'title'      => __( 'About Us Section', 'movers-agency' ),
        'priority'   => 110,
        'capability' => 'edit_theme_options',
        'panel'      => 'movers_agency_home_page_settings',
        )
    );

    /** About Us Section control */
    $wp_customize->add_setting( 
        'movers_agency_about_setting', 
        array(
            'default' => true ,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_about_setting',
        array(
            'label'       => __( 'Show About Us', 'movers-agency' ),
            'section'     => 'movers_agency_section_featured_about',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting(
        'movers_agency_image_left',
         array(
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'esc_url_raw'
        )
    );

    $wp_customize->add_control( 
        new WP_Customize_Image_Control( $wp_customize, 
            'movers_agency_image_left', 
            array(
            'label' => 'Edit Image 1',
            'settings'  => 'movers_agency_image_left',
            'section'   => 'movers_agency_section_featured_about'
            ) 
        )
    );

        // Items
    $wp_customize->add_setting('movers_agency_number_of_featured_mission_items', 
        array(
        'default'           => '',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'movers_agency_sanitize_number_range'
        )
    );

    $wp_customize->add_control('movers_agency_number_of_featured_mission_items', 
        array(
        'label'       => __('Items (Max: 3)', 'movers-agency'),
        'section'     => 'movers_agency_section_featured_about',   
        'settings'    => 'movers_agency_number_of_featured_mission_items',
        'type'        => 'number',
        'input_attrs' => array(
                'min'   => 1,
                'max'   => 3,
                'step'  => 1,
            ),
        )
    );

 $movers_agency_number_of_featured_mission_items = get_theme_mod( 'movers_agency_number_of_featured_mission_items' );

for ($item_index = 1; $item_index <= $movers_agency_number_of_featured_mission_items; $item_index++) {

    // Section Tab
    $wp_customize->add_setting('movers_agency_featured_mission_section_tab_' . $item_index, 
        array(  
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('movers_agency_featured_mission_section_tab_' . $item_index, 
        array(
            'label'       => __('Tab ', 'movers-agency') . $item_index,
            'section'     => 'movers_agency_section_featured_about',
            'settings'    => 'movers_agency_featured_mission_section_tab_' . $item_index,
            'type'        => 'text'
        )
    ); 
    // Post Categories
    $wp_customize->add_setting(
        'movers_agency_banner_slider_content_post_' . $item_index,
        array(
            'sanitize_callback' => 'absint',
        )
    );

    $wp_customize->add_control(
        'movers_agency_banner_slider_content_post_' . $item_index,
        array(
            'label'           => sprintf( esc_html__( 'Select Post %d', 'movers-agency' ), $item_index ),
            'section'         => 'movers_agency_section_featured_about',
            'settings'        => 'movers_agency_banner_slider_content_post_' . $item_index,
            'type'            => 'select',
            'choices'         => movers_agency_get_post_choices(),
        )
    );
}
    
    /** Home Page Settings Ends */
    
    /** Footer Section */
    $wp_customize->add_section(
        'movers_agency_footer_section',
        array(
            'title' => __( 'Footer Settings', 'movers-agency' ),
            'priority' => 70,
            'panel' => 'movers_agency_home_page_settings',
        )
    );

    /** Footer Widget Columns */
    $wp_customize->add_setting('movers_agency_footer_widget_areas', array(
        'default'           => 4,
        'sanitize_callback' => 'movers_agency_sanitize_choices',
    ));

    $wp_customize->add_control('movers_agency_footer_widget_areas', array(
        'label'    => __('Footer Widget Columns', 'movers-agency'),
        'section'  => 'movers_agency_footer_section',
        'settings' => 'movers_agency_footer_widget_areas',
        'type'     => 'select',
        'choices'  => array(
		   '1'     => __('One', 'movers-agency'),
		   '2'     => __('Two', 'movers-agency'),
		   '3'     => __('Three', 'movers-agency'),
		   '4'     => __('Four', 'movers-agency')
        ),
    ));

    /** Copyright Text */
    $wp_customize->add_setting(
        'movers_agency_footer_copyright_text',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'movers_agency_footer_copyright_text',
        array(
            'label' => __( 'Copyright Info', 'movers-agency' ),
            'section' => 'movers_agency_footer_section',
            'type' => 'text',
        )
    );

    $wp_customize->add_setting('footer_background_image',
        array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
        )
    );


    $wp_customize->add_control(
         new WP_Customize_Cropped_Image_Control($wp_customize, 'footer_background_image',
            array(
                'label' => esc_html__('Footer Background Image', 'movers-agency'),
                'description' => sprintf(esc_html__('Recommended Size %1$s px X %2$s px', 'movers-agency'), 1024, 800),
                'section' => 'movers_agency_footer_section',
                'width' => 1024,
                'height' => 800,
                'flex_width' => true,
                'flex_height' => true,
            )
        )
    );

    /** Footer Background Image Attachment */
    $wp_customize->add_setting('movers_agency_background_attatchment', array(
        'default'           => 'scroll',
        'sanitize_callback' => 'movers_agency_sanitize_choices',
    ));

    $wp_customize->add_control('movers_agency_background_attatchment', array(
        'label'    => __('Footer Background Attachment', 'movers-agency'),
        'section'  => 'movers_agency_footer_section',
        'settings' => 'movers_agency_background_attatchment',
        'type'     => 'select',
        'choices'  => array(
            'fixed' => __('fixed','movers-agency'),
            'scroll' => __('scroll','movers-agency'),
        ),
    ));

    /* Footer Background Color*/
    $wp_customize->add_setting(
        'footer_background_color',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_background_color',
            array(
                'label' => __('Footer Widget Area Background Color', 'movers-agency'),
                'section' => 'movers_agency_footer_section',
                'type' => 'color',
            )
        )
    );

    /** Scroll To Top control */
    $wp_customize->add_setting( 
        'movers_agency_footer_scroll_to_top', 
        array(
            'default'           => true,
            'sanitize_callback' => 'movers_agency_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'movers_agency_footer_scroll_to_top',
        array(
            'label'       => __( 'Show / Hide Scroll To Top', 'movers-agency' ),
            'section'     => 'movers_agency_footer_section',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('movers_agency_scroll_icon',array(
        'default'   => 'fas fa-arrow-up',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control(new Movers_Agency_Changeable_Icon(
        $wp_customize,'movers_agency_scroll_icon',array(
        'label' => __('Scroll Top Icon','movers-agency'),
        'transport' => 'refresh',
        'section'   => 'movers_agency_footer_section',
        'type'      => 'icon'
    )));

    $wp_customize->add_setting('movers_agency_scroll_top_alignment',array(
        'default' => 'right-align',
        'sanitize_callback' => 'movers_agency_sanitize_scroll_top_alignment'
    ));
    $wp_customize->add_control('movers_agency_scroll_top_alignment',array(
        'type' => 'select',
        'label' => __('Scroll Top Alignment','movers-agency'),
        'section' => 'movers_agency_footer_section',
        'choices' => array(
            'right-align' => __('Right Alignment','movers-agency'),
            'center-align' => __('Center Alignment','movers-agency'),
            'left-align' => __('Left Alignment','movers-agency'),
        ),
    ) );

    /** Scroll to top button shape */
    $wp_customize->add_setting('movers_agency_scroll_to_top_radius', array(
        'default'           => 'curved-box',
        'sanitize_callback' => 'movers_agency_sanitize_choices',
    ));

    $wp_customize->add_control('movers_agency_scroll_to_top_radius', array(
        'label'    => __('Scroll Top Button Shape', 'movers-agency'),
        'section'  => 'movers_agency_footer_section',
        'settings' => 'movers_agency_scroll_to_top_radius',
        'type'     => 'select',
        'choices'  => array(
            'box'        => __( 'Box', 'movers-agency' ),
            'curved-box' => __( 'Curved Box', 'movers-agency' ),
            'circle'     => __( 'Circle', 'movers-agency' ),
        ),
    ));

    // 404 PAGE SETTINGS
    $wp_customize->add_section(
        'movers_agency_404_section',
        array(
            'title' => __( '404 Page Settings', 'movers-agency' ),
            'priority' => 70,
            'panel' => 'movers_agency_general_settings',
        )
    );
   
    $wp_customize->add_setting('404_page_image', array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'esc_url_raw', // Sanitize as URL
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, '404_page_image', array(
        'label' => __('404 Page Image', 'movers-agency'),
        'section' => 'movers_agency_404_section',
        'settings' => '404_page_image',
    )));

    $wp_customize->add_setting('404_pagefirst_header', array(
        'default' => __('404', 'movers-agency'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_pagefirst_header', array(
        'type' => 'text',
        'label' => __('Heading', 'movers-agency'),
        'section' => 'movers_agency_404_section',
    ));

    // Setting for 404 page header
    $wp_customize->add_setting('404_page_header', array(
        'default' => __('Sorry, that page can\'t be found!', 'movers-agency'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_page_header', array(
        'type' => 'text',
        'label' => __('Heading', 'movers-agency'),
        'section' => 'movers_agency_404_section',
    ));
    /** Footer control END */
}
add_action( 'customize_register', 'movers_agency_customize_register' );
endif;

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function movers_agency_customize_preview_js() {
    // Use minified libraries if SCRIPT_DEBUG is false
    $movers_agency_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $movers_agency_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_script( 'movers_agency_customizer', get_template_directory_uri() . '/js' . $movers_agency_build . '/customizer' . $movers_agency_suffix . '.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'movers_agency_customize_preview_js' );