<?php
/**
 * Movers Agency functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package movers_agency
 */

if ( ! defined( 'MOVERS_AGENCY_URL' ) ) {
    define( 'MOVERS_AGENCY_URL', esc_url( 'https://www.themeignite.com/products/packers-and-movers-wordpress-theme', 'movers-agency') );
}
if ( ! defined( 'MOVERS_AGENCY_FREE_DOC_URL' ) ) {
    define( 'MOVERS_AGENCY_FREE_DOC_URL', esc_url( 'https://demo.themeignite.com/documentation/movers-agency-free', 'movers-agency') );
}
if ( ! defined( 'MOVERS_AGENCY_PRO_DOC_URL' ) ) {
    define( 'MOVERS_AGENCY_PRO_DOC_URL', esc_url( 'https://demo.themeignite.com/documentation/movers-agency-pro/', 'movers-agency') );
}
if ( ! defined( 'MOVERS_AGENCY_DEMO_URL' ) ) {
    define( 'MOVERS_AGENCY_DEMO_URL', esc_url( 'https://demo.themeignite.com/movers-agency/', 'movers-agency') );
}
if ( ! defined( 'MOVERS_AGENCY_REVIEW_URL' ) ) {
    define( 'MOVERS_AGENCY_REVIEW_URL', esc_url( 'https://wordpress.org/support/theme/movers-agency/reviews/#new-post', 'movers-agency') );
}
if ( ! defined( 'MOVERS_AGENCY_SUPPORT_URL' ) ) {
    define( 'MOVERS_AGENCY_SUPPORT_URL', esc_url( 'https://wordpress.org/support/theme/movers-agency', 'movers-agency') );
}
if ( ! defined( 'MOVERS_AGENCY_BUNDLE_URL' ) ) {
    define( 'MOVERS_AGENCY_BUNDLE_URL', esc_url( 'https://www.themeignite.com/products/wp-theme-bundle', 'movers-agency') );
}

$movers_agency_theme_data = wp_get_theme();
if( ! defined( 'MOVERS_AGENCY_THEME_VERSION' ) ) define ( 'MOVERS_AGENCY_THEME_VERSION', $movers_agency_theme_data->get( 'Version' ) );
if( ! defined( 'MOVERS_AGENCY_THEME_NAME' ) ) define( 'MOVERS_AGENCY_THEME_NAME', $movers_agency_theme_data->get( 'Name' ) );

if ( ! function_exists( 'movers_agency_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function movers_agency_setup() {

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary', 'movers-agency' ),
		'primary-mobile' => esc_html__( 'Primary Mobile Media', 'movers-agency' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See https://developer.wordpress.org/themes/functionality/post-formats/
	 */
	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
		'gallery',
        'status',
        'audio', 
        'chat'
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'movers_agency_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );


	/* Custom Logo */
    add_theme_support( 'custom-logo', array(    	
    	'header-text' => array( 'site-title', 'site-description' ),
    ) );

	add_theme_support( 'woocommerce' );

    load_theme_textdomain( 'movers-agency', get_template_directory() . '/languages' );
}
endif;
add_action( 'after_setup_theme', 'movers_agency_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function movers_agency_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'movers_agency_content_width', 780 );
}
add_action( 'after_setup_theme', 'movers_agency_content_width', 0 );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function movers_agency_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Option', 'movers-agency' ),
		'id'            => 'right-sidebar',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Two', 'movers-agency' ),
		'id'            => 'sidebar-2',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Three', 'movers-agency' ),
		'id'            => 'sidebar-3',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer One', 'movers-agency' ),
		'id'            => 'footer-one',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
    
    register_sidebar( array(
		'name'          => esc_html__( 'Footer Two', 'movers-agency' ),
		'id'            => 'footer-two',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
    
    register_sidebar( array(
		'name'          => esc_html__( 'Footer Three', 'movers-agency' ),
		'id'            => 'footer-three',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Four', 'movers-agency' ),
		'id'            => 'footer-four',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

}
add_action( 'widgets_init', 'movers_agency_widgets_init' );

if( ! function_exists( 'movers_agency_scripts' ) ) :
/**
 * Enqueue scripts and styles.
 */
function movers_agency_scripts() {

	// Use minified libraries if SCRIPT_DEBUG is false
    $movers_agency_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $movers_agency_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    wp_enqueue_style( 'bootstrap-style', get_template_directory_uri().'/css/build/bootstrap.css' );
    wp_enqueue_style( 'owl.carousel', get_template_directory_uri() . '/css/build/owl.carousel.css' );
	wp_enqueue_style( 'fontawesome-all', esc_url(get_template_directory_uri()).'/css/all.min.css');

	wp_enqueue_style( 'movers-agency-style', get_stylesheet_uri(), array(), MOVERS_AGENCY_THEME_VERSION );

	wp_style_add_data('movers-agency-style', 'rtl', 'replace');

	require get_parent_theme_file_path( '/inc/css_custom.php' );
	wp_add_inline_style( 'movers-agency-style',$movers_agency_custom_css );

  	wp_enqueue_script( 'all', get_template_directory_uri() . '/js' . $movers_agency_build . '/all' . $movers_agency_suffix . '.js', array( 'jquery' ), '6.1.1', true );
  	wp_enqueue_script( 'v4-shims', get_template_directory_uri() . '/js' . $movers_agency_build . '/v4-shims' . $movers_agency_suffix . '.js', array( 'jquery' ), '6.1.1', true );
  	wp_enqueue_script( 'movers-agency-modal-accessibility', get_template_directory_uri() . '/js' . $movers_agency_build . '/modal-accessibility' . $movers_agency_suffix . '.js', array( 'jquery' ), MOVERS_AGENCY_THEME_VERSION, true );
	wp_enqueue_script( 'owl.carousel', get_template_directory_uri() . '/js/build/owl.carousel.js', array('jquery'), '2.6.0', true );
	wp_enqueue_script( 'movers-agency-js', get_template_directory_uri() . '/js/build/custom.js', array('jquery'), MOVERS_AGENCY_THEME_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
endif;
add_action( 'wp_enqueue_scripts', 'movers_agency_scripts' );

if( ! function_exists( 'movers_agency_admin_scripts' ) ) :
/**
 * Addmin scripts
*/
function movers_agency_admin_scripts() {
	wp_enqueue_style( 'movers-agency-admin-style',get_template_directory_uri().'/inc/css/admin.css', MOVERS_AGENCY_THEME_VERSION, 'screen' );
}
endif;
add_action( 'admin_enqueue_scripts', 'movers_agency_admin_scripts' );

function movers_agency_customize_enque_js(){
	wp_enqueue_script( 'customizer', get_template_directory_uri() . '/inc/js/customizer.js', array('jquery'), '2.6.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'movers_agency_customize_enque_js', 0 );


if( ! function_exists( 'movers_agency_block_editor_styles' ) ) :
/**
 * Enqueue editor styles for Gutenberg
 */
function movers_agency_block_editor_styles() {
	// Use minified libraries if SCRIPT_DEBUG is false
	$movers_agency_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
	$movers_agency_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	
	// Block styles.
	wp_enqueue_style( 'movers-agency-block-editor-style', get_template_directory_uri() . '/css' . $movers_agency_build . '/editor-block' . $movers_agency_suffix . '.css' );
}
endif;
add_action( 'enqueue_block_editor_assets', 'movers_agency_block_editor_styles' );

/**
 * Display the admin notice unless dismissed.
 */
function movers_agency_dashboard_notice() {
    // Check if the notice is dismissed
    $dismissed = get_user_meta(get_current_user_id(), 'movers_agency_dismissable_notice', true);

    // Display the notice only if not dismissed
    if (!$dismissed) {
        ?>
        <div class="updated notice notice-success is-dismissible notice-get-started-class" data-notice="get-start">
            <div class="notice-details">
                <div class="notice-content">
                    <h2><?php /* translators: %s: Theme name */printf( esc_html__( 'Thanks you for installing %s.', 'movers-agency' ), '<strong>Movers Agency</strong>' );?></h2>
                    <p><?php echo esc_html('Your journey to a powerful and stylish website begins here. Let’s get everything set up in just a few clicks!', 'movers-agency'); ?></p>
                    <div class="notice-btns">
                        <a class="button button-primary getstart"
                           href="<?php echo esc_url(admin_url('themes.php?page=movers-agency')); ?>"><?php esc_html_e('Getting Started', 'movers-agency') ?></a>   
                        <a class="button button-primary import"
			               href="<?php echo esc_url(admin_url('themes.php?page=moversagency-wizard')); ?>"><?php esc_html_e('Demo Importer', 'movers-agency') ?></a>                      
                       	<a class="button button-primary premium" target="_blank" href="<?php echo esc_url(MOVERS_AGENCY_URL); ?>"><?php esc_html_e('Go To Premium', 'movers-agency') ?></a>
						<a class="button button-primary demo" target="_blank" href="<?php echo esc_url(MOVERS_AGENCY_DEMO_URL); ?>"><?php esc_html_e('View Demo', 'movers-agency') ?></a>
		            </div>
        		</div>
                <div class="notice-img">
                    <a href="<?php echo esc_url( MOVERS_AGENCY_BUNDLE_URL ); ?>" target="_blank"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/notice.png' ); ?>"></a>
                </div>
            </div>
        </div>
        <?php
    }
}

// Hook to display the notice
add_action('admin_notices', 'movers_agency_dashboard_notice');

/**
 * AJAX handler to dismiss the notice.
 */
function movers_agency_dismissable_notice() {
    // Set user meta to indicate the notice is dismissed
    update_user_meta(get_current_user_id(), 'movers_agency_dismissable_notice', true);
    die();
}

// Hook for the AJAX action
add_action('wp_ajax_movers_agency_dismissable_notice', 'movers_agency_dismissable_notice');

/**
 * Clear dismissed notice state when switching themes.
 */
function movers_agency_switch_theme() {
    // Clear the dismissed notice state when switching themes
    delete_user_meta(get_current_user_id(), 'movers_agency_dismissable_notice');
}

// Hook for switching themes
add_action('after_switch_theme', 'movers_agency_switch_theme');

function movers_agency_template_setup() {

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extra.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Info Theme
 */
require get_template_directory() . '/inc/info.php';

/**
 * Getting Started
*/
require get_template_directory() . '/inc/getting-started/getting-started.php';

/**
 * setup wizard
 */
require get_parent_theme_file_path( '/theme-wizard/config.php' );

/**
 * sanitization Theme
 */
require get_template_directory() . '/inc/sanitization.php';

}
add_action('after_setup_theme', 'movers_agency_template_setup');


/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';


/**
 * Remove header text setting and control from the Customizer.
 */
function movers_agency_remove_customizer_setting($wp_customize) {
    // Replace 'your_setting_id' with the actual ID or name of the setting you want to remove
    $wp_customize->remove_control('display_header_text');
    $wp_customize->remove_setting('display_header_text');
}
add_action('customize_register', 'movers_agency_remove_customizer_setting');

function movers_agency_custom_blog_banner_title() {
    if (is_404()) {
        echo '<h1 class="entry-title">'. esc_html( 'Comments are closed.', 'movers-agency' ).'</h1>';
    } elseif (is_search()) {
        echo '<h1 class="entry-title">'. esc_html( 'Search Result For.', 'movers-agency' ).' ' . get_search_query() . '</h1>';
    } elseif (is_home() && !is_front_page()) {
        echo '<h1 class="entry-title">'. esc_html( 'Blogs', 'movers-agency' ).'</h1>';
    } elseif (function_exists('is_shop') && is_shop()) {
        echo '<h1 class="entry-title">'. esc_html( 'Shop', 'movers-agency' ).'</h1>';
    } elseif (is_page_template('template-homepage.php')) {
    } elseif (is_page()) {
        the_title('<h1 class="entry-title">', '</h1>');
    } elseif (is_single()) {
        the_title('<h1 class="entry-title">', '</h1>');
    } elseif (is_archive()) {
        the_archive_title('<h1 class="entry-title">', '</h1>');
    } else {
        the_archive_title('<h1 class="entry-title">', '</h1>');
    }
	movers_agency_the_breadcrumb();
}

function movers_agency_the_breadcrumb() {
    echo '<div class="breadcrumb justify-content-center align-items-center">';

    if (!is_home()) {
        echo '<a class="home-main align-self-center" href="' . esc_url(home_url()) . '">';
        bloginfo('name');
        echo "</a> >> ";

        if (is_category() || is_single()) {
            the_category(' >> ');
            if (is_single()) {
                echo ' >> <span class="current-breadcrumb">' . esc_html(get_the_title()) . '</span>';
            }
        } elseif (is_page()) {
            echo '<span class="current-breadcrumb">' . esc_html(get_the_title()) . '</span>';
        }
    }

    echo '</div>';
}

function movers_agency_customizer_css() { ?>
    <style type="text/css">
        .main-navigation ul li a {
            font-weight: <?php echo esc_html( get_theme_mod( 'movers_agency_menu_font_weight', '600' ) ); ?>;
            text-transform: <?php echo esc_html( get_theme_mod( 'movers_agency_menu_text_transform', 'capitalize' ) ); ?>;
        }
    </style>
    <?php
}
add_action('wp_head', 'movers_agency_customizer_css');

function movers_agency_enqueue_google_fontss() {
    $movers_agency_heading_font_family = get_theme_mod('movers_agency_heading_font_family', '');
    $movers_agency_body_font_family = get_theme_mod('movers_agency_body_font_family', '');

    // Google Fonts URL builder
    $google_fonts = array(
        'Arial'          => '',
        'Verdana'        => '',
        'Helvetica'      => '',
        'Times New Roman'=> '',
        'Georgia'        => '',
        'Courier New'    => '',
        'Trebuchet MS'   => '',
        'Tahoma'         => '',
        'Palatino'       => '',
        'Garamond'       => '',
        'Impact'         => '',
        'Comic Sans MS'  => '',
        'Lucida Sans'    => '',
        'Arial Black'    => '',
        'Gill Sans'      => '',
        'Segoe UI'       => '',
        'Open Sans'      => 'Open+Sans:wght@400;700',
        'Roboto'         => 'Roboto:wght@400;700',
        'Lato'           => 'Lato:wght@400;700',
        'Montserrat'     => 'Montserrat:wght@400;700',
        'Libre Baskerville' => 'Libre+Baskerville:wght@400;700'
    );

    $movers_agency_google_fonts_url = '';

    if (!empty($google_fonts[$movers_agency_heading_font_family]) || !empty($google_fonts[$movers_agency_body_font_family])) {
        $fonts = array();

        if (!empty($google_fonts[$movers_agency_heading_font_family])) {
            $fonts[] = $google_fonts[$movers_agency_heading_font_family];
        }

        if (!empty($google_fonts[$movers_agency_body_font_family])) {
            $fonts[] = $google_fonts[$movers_agency_body_font_family];
        }

        // Build Google Fonts URL
        $movers_agency_google_fonts_url = add_query_arg(
            'family',
            implode('|', $fonts),
            'https://fonts.googleapis.com/css2'
        );
    }

    if ($movers_agency_google_fonts_url) {
        wp_enqueue_style('movers-agency-google-fonts', $movers_agency_google_fonts_url, false);
    }
}
add_action('wp_enqueue_scripts', 'movers_agency_enqueue_google_fontss');


function movers_agency_apply_typography() {
    // Get the font family settings from the customizer
    $movers_agency_heading_font_family = get_theme_mod('movers_agency_heading_font_family');
    $movers_agency_body_font_family = get_theme_mod('movers_agency_body_font_family');

    // Only output CSS if one or both fonts are set
    if ($movers_agency_body_font_family || $movers_agency_heading_font_family) {
        ?>
        <style type="text/css">
            <?php if ($movers_agency_body_font_family): ?>
            body, a, a:active, a:hover {
                font-family: <?php echo esc_html($movers_agency_body_font_family); ?> !important;
            }
            <?php endif; ?>

            <?php if ($movers_agency_heading_font_family): ?>
            h1, h2, h3, h4, h5, h6 {
                font-family: <?php echo esc_html($movers_agency_heading_font_family); ?> !important;
            }
            <?php endif; ?>
        </style>
        <?php
    }
}
add_action('wp_head', 'movers_agency_apply_typography');