<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package movers_agency
 */
$movers_agency_scroll_top  = get_theme_mod( 'movers_agency_scroll_to_top', true );
$movers_agency_footer_background = get_theme_mod('footer_background_image');
$movers_agency_footer_background_url = '';
if(!empty($movers_agency_footer_background)){
    $movers_agency_footer_background = absint($movers_agency_footer_background);
    $movers_agency_footer_background_url = wp_get_attachment_url($movers_agency_footer_background);
}

$footer_background_color = get_theme_mod('footer_background_color', 'var(--tertiary-color)'); // New line

$movers_agency_footer_background_style = '';
if (!empty($movers_agency_footer_background_url)) {
    $movers_agency_footer_background_style = ' style="background-image: url(\'' . esc_url($movers_agency_footer_background_url) . '\'); background-repeat: no-repeat; background-size: cover;"';
} else {
    $movers_agency_footer_background_style = ' style="background-color: ' . esc_attr($footer_background_color) . ';"'; // Updated line
}
?>

</div>
</div>
</div>
</div>

<footer class="site-footer" <?php echo $movers_agency_footer_background_style; ?>>
    <?php 
    $movers_agency_active_areas = get_theme_mod('movers_agency_footer_widget_areas', 4);
    if (
        is_active_sidebar('footer-1') ||
        is_active_sidebar('footer-2') ||
        is_active_sidebar('footer-3') ||
        is_active_sidebar('footer-4')
    ) : ?>
        <div class="footer-t">
            <div class="container">
                <div class="row">
                    <?php 
                    for ($movers_agency_i = 1; $movers_agency_i <= $movers_agency_active_areas; $movers_agency_i++) {

                        if (is_active_sidebar('footer-' . $movers_agency_i)) {

                            $movers_agency_col = 12 / $movers_agency_active_areas;

                            echo '<div class="col-xl-' . $movers_agency_col . ' col-lg-' . $movers_agency_col . ' col-md-6 col-sm-6">';
                            dynamic_sidebar('footer-' . $movers_agency_i);
                            echo '</div>';
                        }
                    }
                    ?>
                </div>
            </div>
        </div>

    <?php else : ?>

        <!-- Default Widget Content -->
        <div class="footer-t">
            <div class="container">
                <div class="row">

                    <?php 
                    // Dynamic column width
                    $movers_agency_col = 12 / $movers_agency_active_areas;
                    ?>

                    <!-- Archive -->
                    <aside class="widget widget_archive col-xl-<?php echo $movers_agency_col; ?> col-lg-<?php echo $movers_agency_col; ?> col-md-6 col-sm-6">
                        <h2 class="widget-title"><?php esc_html_e('Archive List', 'movers-agency'); ?></h2>
                        <ul><?php wp_get_archives('type=monthly'); ?></ul>
                    </aside>

                    <!-- Recent Posts -->
                    <aside class="widget widget_recent_posts col-xl-<?php echo $movers_agency_col; ?> col-lg-<?php echo $movers_agency_col; ?> col-md-6 col-sm-6">
                        <h2 class="widget-title"><?php esc_html_e('Recent Posts', 'movers-agency'); ?></h2>
                        <ul>
                            <?php
                            $args = array('post_type' => 'post', 'posts_per_page' => 5);
                            $recent_posts = new WP_Query($args);
                            while ($recent_posts->have_posts()) : $recent_posts->the_post(); ?>
                                <li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
                            <?php endwhile; wp_reset_postdata(); ?>
                        </ul>
                    </aside>

                    <!-- Categories -->
                    <aside class="widget widget_categories col-xl-<?php echo $movers_agency_col; ?> col-lg-<?php echo $movers_agency_col; ?> col-md-6 col-sm-6">
                        <h2 class="widget-title"><?php esc_html_e('Categories', 'movers-agency'); ?></h2>
                        <ul><?php wp_list_categories(array('title_li' => '')); ?></ul>
                    </aside>

                    <!-- Tags -->
                    <aside class="widget widget_tags col-xl-<?php echo $movers_agency_col; ?> col-lg-<?php echo $movers_agency_col; ?> col-md-6 col-sm-6">
                        <h2 class="widget-title"><?php esc_html_e('Tags', 'movers-agency'); ?></h2>
                        <div class="tag-cloud"><?php wp_tag_cloud(); ?></div>
                    </aside>

                </div>
            </div>
        </div>

    <?php endif; ?>

    <?php do_action('movers_agency_footer'); ?>

    <?php if ($movers_agency_scroll_top) : ?>
        <a id="button">
            <i class="<?php echo esc_attr(get_theme_mod('movers_agency_scroll_icon', 'fas fa-arrow-up')); ?>"></i>
        </a>
    <?php endif; ?>

</footer>
</div>
</div>

<?php wp_footer(); ?>

</body>
</html>
