<?php 
    get_header();
    $col = ( is_active_sidebar('sidebar') ) ? 'has-sidebar col-md-12 col-lg-8 col-xl-9 px-4' : 'no-sidebar px-4 col-md-12';
 ?>
<?php morvaridlite_page_banner( get_the_title() ); ?>
<div class="main-contaier">
    <div class="container">
        <div class="row wrapper-main-content mx-n4">
            <div class="<?php echo esc_attr($col); ?>">
                <?php
                    while ( have_posts() ) {
                        the_post();
                        ?>
                    <div class="morvaridlite-single-post">
                        <article <?php post_class('post-single'); ?>>
                            <div class="post-inner">
                                <div class="post-header">
                                    <?php get_template_part('template-parts/post', 'format'); ?>
                                    <div class="date-post">
                                        <span class="day"><?php echo esc_html( get_the_date( 'd') ); ?></span>
                                        <span class="month"><?php echo esc_html( get_the_date( 'M') ); ?></span>
                                    </div>
                                </div>
                                <div class="post-info">
                                    <div class="post-cats"><?php the_category(', '); ?></div>
                                    <h2 class="post-title"><?php the_title(); ?></h2>
                                    <?php get_template_part('template-parts/post', 'meta'); ?>                      
                                    <div class="post-content">
                                        <?php
                                            the_content();
                                            wp_link_pages(
                                                array(
                                                    'before'   => '<p class="page-nav">' . esc_html__( 'Pages:', 'morvaridlite' ),
                                                    'after'    => '</p>'
                                                )
                                            );
                                        ?>
                                    </div>
                                    <?php get_template_part('template-parts/post', 'footer'); ?>
                                </div>
                            </div>
                        </article>
                        <?php  if ( get_the_author_meta( 'description' ) ) { ?>
                            <div class="post-about">
                                <div class="ab-img"><?php echo get_avatar( get_the_author_meta( 'ID' ), 140 ); ?></div>
                                <div class="ab-info">
                                    <h4><a class="name-ath" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>"><?php the_author(); ?></a></h4>
                                    <div class="ab-text"><?php echo esc_html( get_the_author_meta( 'description' ) );?></div>
                                    <?php get_template_part( 'template-parts/social','network' ) ?>
                                </div>
                            </div>
                        <?php }?>
                        <?php get_template_part( 'template-parts/single', 'post-related' ); ?>
                        <?php
                            if ( comments_open() || get_comments_number() ) :
                                comments_template('', true);
                            endif;
                        ?>    
                    </div>
                <?php } ?>
            </div>
            <?php if ( is_active_sidebar('sidebar') ) { ?>
            <div class="col-md-12 col-lg-4 col-xl-3 px-4">
                <?php get_sidebar() ?>
            </div>
            <?php } ?>
        </div>
    </div>
</div>
<?php get_footer(); ?>
