<!DOCTYPE HTML>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>
    <a class="skip-link screen-reader-text" href="#content">
    <?php esc_html_e( 'Skip to content', 'morvaridlite' ); ?></a>
    <div class="body-overlay"></div>
    <div class="main-wrapper-boxed">
        <header id="morvaridlite-header" class="header">
            <div class="main-header">
                <div class="header-wrapper">
                    <div class="mainheader-content">
                        <a href="javascript:void(0)" class="menu-touch icon-touch d-lg-none toggle-modal nav-toggle" data-toggle-target=".menu-modal"aria-expanded="false" data-set-focus=".morvaridlite-logo a">
                            <div class="navbar-toggle">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </a>
                        <?php get_template_part( 'template-parts/social', 'network'); ?>
                        <?php get_template_part( 'template-parts/logo', 'site' ) ?>
                        <div class="header-search">
                            <button class="navbar-search d-lg-none toggle-modal search-toggle" data-toggle-target=".inner-search-header" data-toggle-body-class="showing-search-modal" data-set-focus=".inner-search-header .text" aria-expanded="false">
                                <i class="fas fa-search"></i>
                            </button><!-- .search-toggle -->
                            <?php get_search_form() ?>
                        </div>
                        
                    </div>
                </div>
            </div>
            <div class="navmain-header">
                <div class="header-wrapper">
                    <div id="nav-wrapper" class="nav-main">
                        <?php
                            wp_nav_menu( array (
                                'container' => false,
                                'theme_location' => 'primary',
                                'menu_class' => 'morvaridlite-main-menu main-menu-horizontal',
                                'depth' => 5,
                            ) );
                        ?>
                    </div>                    
                </div>
            </div>
        </header>
        <?php get_template_part( 'template-parts/searchform', 'mobile' ) ?>
        <?php get_template_part( 'template-parts/menu', 'vertical' ) ?>
        <div  id="content" class="morvaridlite-primary">
    