<?php
# Define
define('MORVARIDLITE_LIBS_URI', get_template_directory_uri() . '/libs/');
define('MORVARIDLITE_CORE_PATH', get_template_directory() . '/core/');
define('MORVARIDLITE_CORE_URI', get_template_directory_uri() . '/core/');
define('MORVARIDLITE_CORE_CLASSES', MORVARIDLITE_CORE_PATH . 'classes/');
define('MORVARIDLITE_CORE_FUNCTIONS', MORVARIDLITE_CORE_PATH . 'functions/');

# Set Content Width
if ( ! isset( $content_width ) ) { $content_width = 1530; }

# After setup theme
add_action('after_setup_theme', 'morvaridlite_setup');
function morvaridlite_setup()
{
    load_theme_textdomain('morvaridlite', get_template_directory().'/languages');
    add_theme_support( 'custom-logo' );
	add_theme_support('automatic-feed-links');
	add_theme_support('post-thumbnails');
    add_theme_support('title-tag');
	register_nav_menus(array('primary' => esc_html__('Main Menu', 'morvaridlite')));
    add_theme_support( 'custom-background' );
}


# Google Fonts
add_action( 'wp_enqueue_scripts', 'morvaridlite_enqueue_googlefonts' );
function morvaridlite_enqueue_googlefonts()
{
    $fonts_url = '';
    $Playfair_Display = _x( 'on', 'Playfair Display: on or off', 'morvaridlite' );
    $Montserrat = _x('on', 'Montserrat : on or off', 'morvaridlite');
    $Alex_Brush = _x('on', 'Alex_Brush : on or off', 'morvaridlite');
    if( 'off' != $Playfair_Display || 'off' != $Montserrat || 'off' != $Alex_Brush)
    {
        $font_families = array();
        if ( 'off' !== $Playfair_Display ) $font_families[] = 'Playfair Display:600';
        if ( 'off' !== $Alex_Brush ) $font_families[] = 'Alex Brush:400';
        if ( 'off' !== $Montserrat ) $font_families[] = 'Montserrat:400,600';
        $query_args = array('family' => urlencode(implode('|', $font_families)), 'subset' => urlencode('latin,latin-ext'));
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }

    wp_enqueue_style('morvaridlite-googlefonts', esc_url_raw($fonts_url), array(), null);
}

add_action( 'enqueue_block_editor_assets', 'morvaridlite_enqueue_googlefonts' );

# Enqueue Scripts
add_action( 'wp_enqueue_scripts', 'morvaridlite_load_scripts' );
function morvaridlite_load_scripts()
{
    # CSS
    wp_enqueue_style('bootstrap', MORVARIDLITE_LIBS_URI . 'bootstrap/bootstrap.css');
    wp_enqueue_style('morvaridlite-font-awesome', MORVARIDLITE_LIBS_URI . 'font-awesome/css/all.css');
    wp_enqueue_style('chosen', MORVARIDLITE_LIBS_URI . 'chosen/chosen.css');
    wp_enqueue_style('jquery-ui-style', MORVARIDLITE_LIBS_URI . 'jquery-ui/jquery-ui.min.css');
    wp_enqueue_style('morvaridlite-style', get_template_directory_uri() . '/style.css');
    wp_enqueue_style('morvaridlite-theme-style', get_template_directory_uri() . '/assets/css/theme.css');

    # JS
    wp_enqueue_script( 'jquery' );
	wp_enqueue_script( 'jquery-ui-dialog' );	
    wp_enqueue_script('fitvids', MORVARIDLITE_LIBS_URI . 'fitvids/fitvids.js', array(), false, true);
    wp_enqueue_script('chosen', MORVARIDLITE_LIBS_URI . 'chosen/chosen.js', array(), false, true);
    wp_enqueue_script('morvaridlite-scripts', get_template_directory_uri() . '/assets/js/morvaridlite-scripts.js', array(), false, true);

    
    if ( is_singular() && get_option('thread_comments') ) {
        wp_enqueue_script('comment-reply');
    }
}


# Register Sidebar
add_action( 'widgets_init', 'morvaridlite_widgets_init' );
function morvaridlite_widgets_init() {
    register_sidebar(array(
		'name'            => esc_html__('Sidebar', 'morvaridlite'),
		'id'              => 'sidebar',
		'before_widget'   => '<div id="%1$s" class="widget %2$s">',
		'after_widget'    => '</div>',
		'before_title'    => '<h4 class="widget-title">',
		'after_title'     => '</h4>'
	));
    register_sidebar(array(
		'name'            => esc_html__('Footer Instagram', 'morvaridlite'),
		'id'              => 'footer-ins',
		'before_widget'   => '<div id="%1$s" class="widget %2$s">',
		'after_widget'    => '</div>',
		'before_title'    => '<h4 class="widget-title">',
		'after_title'     => '</h4>'
	));
}

# Check file exists
function morvaridlite_require_file( $path ) {
    if ( file_exists($path) ) {
        require $path;
    }
}

# Require file
morvaridlite_require_file( get_template_directory() . '/core/init.php' );


# Comment Layout
function morvaridlite_custom_comment($comment, $args, $depth) {
	extract($args, EXTR_SKIP);

	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	} else {
		$tag = 'li';
		$add_below = 'div-comment';
	}
?>
	<<?php echo esc_attr($tag); ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
	<?php if ( 'div' != $args['style'] ) : ?>
	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
	<?php endif; ?>
		<div class="comment-author">
		<?php if ( $args['avatar_size'] != 0 ) echo get_avatar( $comment, $args['avatar_size'] ); ?>
		</div>
		<div class="comment-content">
		    <h4 class="author-name"><?php echo wp_kses_post( get_comment_author_link() ); ?></h4>
			<div class="date-comment">
				<a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
					<?php echo esc_html( get_comment_date() ) . ' ' . esc_html__( 'at', 'morvaridlite' ) . ' ' . esc_html( get_comment_time() ); ?>
				</a>
			</div>
			<div class="reply">
				<?php edit_comment_link( esc_html__( '(Edit)', 'morvaridlite' ), '  ', '' );?>
				<?php comment_reply_link( array_merge( $args, array( 'add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
			</div>
			<?php if ( $comment->comment_approved == '0' ) : ?>
				<em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'morvaridlite' ); ?></em>
				<br />
			<?php endif; ?>
			<div class="comment-text"><?php comment_text(); ?></div>
		</div>	
	<?php if ( 'div' != $args['style'] ) : ?>
	</div>
	<?php endif; ?>
<?php
}

# Pagination
function morvaridlite_pagination()
{
    global $wp_query;
    if ( (int)$wp_query->found_posts > (int)get_option('posts_per_page') ) : ?>
    <div class="morvaridlite-pagination"><?php
        $args = array(
            'prev_text' => '<span class="fa fa-angle-left"></span>',
            'next_text' => '<span class="fa fa-angle-right"></span>'
        );
        the_posts_pagination($args);
    ?>
    </div>
    <?php
    endif;
}
/**
 * Breadcrumb
 */
function morvaridlite_breadcrumbs() {
    $delimiter = '<span class="morvaridlite-delimiter">&rsaquo;</span>';
    $home = esc_html__( 'Home', 'morvaridlite' ); // chữ thay thế cho phần 'Home' link
    $before = '<span class="current">'; // thẻ html đằng trước mỗi link
    $after = '</span>'; // thẻ đằng sau mỗi link
    if ( !is_home() && !is_front_page() || is_paged() ) {
        echo '<div class="morvaridlite-breadcrumbs">';
        global $post;
        $homeLink = home_url(); ?>
        <a href="<?php echo esc_url( $homeLink ); ?>"><?php echo wp_kses_post( $home ); ?></a> <?php echo wp_kses_post( $delimiter ); ?>&nbsp;
        <?php
        if ( is_category() ) {
            global $wp_query;
            $cat_obj = $wp_query->get_queried_object();
            $thisCat = $cat_obj->term_id;
            $thisCat = get_category($thisCat);
            $parentCat = get_category($thisCat->parent);
            if ($thisCat->parent != 0) echo wp_kses_post(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
            echo wp_kses_post( $before . single_cat_title('', false) . $after );
        } elseif ( is_day() ) { ?>
            <a href="<?php echo esc_url( get_year_link(get_the_time('Y')) ); ?>"><?php echo esc_html( get_the_time('Y') ); ?></a><?php echo wp_kses_post( $delimiter ); ?>&nbsp;
            <a href="<?php echo esc_url( get_month_link(get_the_time('Y'),get_the_time('m')) )?>"><?php echo esc_html( get_the_time('F') ); ?></a><?php echo wp_kses_post( $delimiter ); ?>&nbsp;
        <?php
            echo wp_kses_post( $before . get_the_time('d') . $after );
        } elseif ( is_month() ) { ?>
            <a href="<?php echo esc_url( get_year_link(get_the_time('Y')) ); ?>"><?php echo esc_html( get_the_time('Y') ); ?></a><?php echo wp_kses_post( $delimiter ); ?>&nbsp;
        <?php
            echo wp_kses_post( $before . get_the_time('F') . $after );
        } elseif ( is_year() ) {
            echo wp_kses_post( $before . get_the_time('Y') . $after );
        } elseif ( is_single() && !is_attachment() ) {
            if ( get_post_type() != 'post' ) {
                $post_type = get_post_type_object(get_post_type());
                $slug = $post_type->rewrite; ?>
                <a href="<?php echo esc_url( $homeLink . '/' . $slug['slug'] . '/' ); ?>"><?php echo wp_kses_post( $post_type->labels->singular_name ); ?></a><?php echo wp_kses_post( $delimiter ); ?>&nbsp;
            <?php
                echo wp_kses_post( $before . get_the_title() . $after );
            } else {
                $cat = get_the_category(); $cat = $cat[0];
                echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
                echo wp_kses_post( $before . get_the_title() . $after );
            }
        } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
            $post_type = get_post_type_object(get_post_type());
            echo wp_kses_post( $before . $post_type->labels->singular_name . $after );
        } elseif ( is_attachment() ) {
            $parent = get_post($post->post_parent);
            $cat = get_the_category($parent->ID); $cat = $cat[0];
            echo wp_kses_post( get_category_parents($cat, TRUE, ' ' . $delimiter . ' ') ); ?>
            <a href="<?php echo esc_url( get_permalink($parent) ); ?>"><?php echo esc_kses_post( $parent->post_title ); ?></a><?php echo wp_kses_post( $delimiter ); ?>&nbsp;
        <?php
            echo wp_kses_post( $before . get_the_title() . $after );
        } elseif ( is_page() && !$post->post_parent ) {
            echo wp_kses_post( $before . get_the_title() . $after );
        } elseif ( is_page() && $post->post_parent ) {
            $parent_id = $post->post_parent;
            $breadcrumbs = array();
            while ($parent_id) {
                $page = get_page($parent_id);
                $breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
                $parent_id = $page->post_parent;
            }
            $breadcrumbs = array_reverse($breadcrumbs);
            foreach ($breadcrumbs as $crumb) echo wp_kses_post( $crumb . ' ' . $delimiter . ' ');
            echo wp_kses_post( $before . get_the_title() . $after );
        } elseif ( is_search() ) {
            echo wp_kses_post( $before . esc_html__( 'Search results for "', 'morvaridlite' ) . get_search_query() . '"' . $after );
        } elseif ( is_tag() ) {
            echo wp_kses_post( $before . esc_html__( 'Posts tagged "', 'morvaridlite' ) . single_tag_title('', false) . '"' . $after );
        } elseif ( is_author() ) {
            global $author;
            echo wp_kses_post( $before . esc_html__( 'Articles posted by ', 'morvaridlite' ) . $userdata->display_name . $after );
        } elseif ( is_404() ) {
            echo wp_kses_post( $before . esc_html__( 'Error 404 ', 'morvaridlite' ) . $after );
        }
        if ( get_query_var('paged') ) {
            if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
            echo esc_html__('Page','morvaridlite') . ' ' . get_query_var('paged');
            if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
        }
        echo '</div>';
    }
} // end morvaridlite_breadcrumbs()

// Banner Page
function morvaridlite_page_banner( $title = null )
{ ?>
    <div class="banner-page">
        <div class="container">
            <div class="inner-banner">
                <div class="page-title">
                    <h1><?php echo wp_kses_post( $title ); ?></h1>
                </div>
                <?php morvaridlite_breadcrumbs(); ?>
            </div>
         </div>
    </div>
    <?php
}


# Include the TGM_Plugin_Activation class
add_action('tgmpa_register', 'morvaridlite_register_required_plugins');
function morvaridlite_register_required_plugins()
{
	$plugins = array(

		array(
			'name'   => esc_html__('Contact Form 7', 'morvaridlite'),
			'slug'   => 'contact-form-7'
		),
        array(
            'name'   => esc_html__('Smash Balloon Instagram Feed', 'morvaridlite'),
            'slug'   => 'instagram-feed'
        ),
        array(
			'name'   => esc_html__('MailChimp for WordPress', 'morvaridlite'),
			'slug'   => 'mailchimp-for-wp'
		)
	);

	$config = array(
		'id'           => 'morvaridlite',
		'default_path' => '',
		'menu'         => 'tgmpa-install-plugins',
		'parent_slug'  => 'themes.php',
		'capability'   => 'edit_theme_options',
		'has_notices'  => true,
		'dismissable'  => true,
		'dismiss_msg'  => '',
		'is_automatic' => true,
		'message'      => ''
	);
	tgmpa($plugins, $config);
}