<?php
function morvaridlite_custom_css()
{	
    $custom_css = "";
    if ( get_theme_mod('morvaridlite_body_color') )
    {
    	$body_color = esc_attr(get_theme_mod('morvaridlite_body_color'));
        $custom_css .= "
            :root{
				--body-color: {$body_color};
			}";
    }
    if ( get_theme_mod('morvaridlite_accent_color') )
    {
        $accent_color = esc_attr(get_theme_mod('morvaridlite_accent_color'));
        $custom_css .= "
        	:root{
				--accent-color: {$accent_color};
			}
        ";
    }

    $background_image = ( get_theme_mod('morvaridlite_background_banner_image') ) ? esc_attr(get_theme_mod('morvaridlite_background_banner_image'))  : get_template_directory_uri() . '/assets/images/bg-banner.jpg';
    $background_size = ( get_theme_mod('morvaridlite_background_banner_size') ) ? esc_attr(get_theme_mod('morvaridlite_background_banner_size'))  : 'cover';
    $background_repeat = ( get_theme_mod('morvaridlite_background_banner_repeat') ) ? esc_attr(get_theme_mod('morvaridlite_background_banner_repeat'))  : 'no-repeat';
    $background_position = ( get_theme_mod('morvaridlite_background_banner_position') ) ? esc_attr(get_theme_mod('morvaridlite_background_banner_position'))  : 'center';
    $custom_css .= "
    	.banner-page{
			background-image: url('{$background_image}');
		    background-size: {$background_size};
		    background-repeat: {$background_repeat};
		    background-position: {$background_position};
		}
    ";

    wp_add_inline_style( 'morvaridlite-woocommerce-style', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'morvaridlite_custom_css', 15 );
