<?php 
function morvaridlite_sanitize_default($value) {return $value;}
function morvaridlite_sanitize_checkbox( $checked ) {	
	return ( ( isset( $checked ) && true == $checked ) ? true : false );
}
//Select
function morvaridlite_sanitize_select( $input, $setting ){
          
    //input must be a slug: lowercase alphanumeric characters, dashes and underscores are allowed only
    $input = sanitize_key($input);

    //get the list of possible select options 
    $choices = $setting->manager->get_control( $setting->id )->choices;
                      
    //return input if valid or return default option
    return ( array_key_exists( $input, $choices ) ? $input : $setting->default );                
      
}

/** Customizer - Add Settings */
function morvaridlite_register_theme_customizer( $wp_customize )
{
	# Theme Options
    $wp_customize->add_panel('morvaridlite_panel', array('priority' => 1, 'capability'=> 'edit_theme_options', 'title' => esc_html__('Morvaridlite Theme Options', 'morvaridlite') ));

    # Sections
   	$wp_customize->add_section( 'morvaridlite_section_social_media', array( 'title' => esc_html__('Social Networks', 'morvaridlite'), 'panel' => 'morvaridlite_panel', 'priority' => 23 ) );
    $wp_customize->add_section( 'morvaridlite_section_banner_page', array( 'title' => esc_html__('Banner Page', 'morvaridlite'), 'panel' => 'morvaridlite_panel', 'priority' => 24 ) );
    $wp_customize->add_section( 'morvaridlite_section_footer', array('title' => esc_html__('Footer', 'morvaridlite'), 'panel' => 'morvaridlite_panel', 'priority' => 25 ));

    // Background Banner
    $wp_customize->add_setting( 'morvaridlite_background_banner_image', array('default' => '','sanitize_callback' => 'sanitize_text_field' ) );
    $wp_customize->add_setting( 'morvaridlite_background_banner_position', array( 'default' => '', 'sanitize_callback' => 'morvaridlite_sanitize_select' ) );
    $wp_customize->add_setting( 'morvaridlite_background_banner_repeat', array( 'default' => '', 'sanitize_callback' => 'morvaridlite_sanitize_select' ) );
    $wp_customize->add_setting( 'morvaridlite_background_banner_size', array( 'default' => '', 'sanitize_callback' => 'morvaridlite_sanitize_select' ) );

    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize, 'morvaridlite_background_banner_image',
            array(
                'label' => esc_html__('Background Image', 'morvaridlite'),
                'section' => 'morvaridlite_section_banner_page',
            )
        )
    );          
    $wp_customize->add_control( 
        'morvaridlite_background_banner_position',
        array(
            'label' => esc_html__( 'Background Position', 'morvaridlite' ),
            'section' => 'morvaridlite_section_banner_page',
            'type' => 'select',
            'choices' => array(
                '' => esc_html__('Please select','morvaridlite'),
                'center center' => esc_html__('Center Center','morvaridlite'),
                'center top' => esc_html__('Center Top','morvaridlite'),
                'center right' => esc_html__('Center Right','morvaridlite'),
                'top center' => esc_html__('Top Center','morvaridlite'),
                'top left' => esc_html__('Top Left','morvaridlite'),
                'top right' => esc_html__('Top Right','morvaridlite'),
                'bottom center' => esc_html__('Bottom Center','morvaridlite'),
                'bottom left' => esc_html__('Bottom Left','morvaridlite'),           
                'bottom right' => esc_html__('Bottom Right','morvaridlite')               
            )
        )
    );
    $wp_customize->add_control( 
        'morvaridlite_background_banner_repeat',
        array(
            'label' => esc_html__( 'Background Repeat', 'morvaridlite' ),
            'section' => 'morvaridlite_section_banner_page',
            'type' => 'select',
            'choices' => array(
                '' => esc_html__('Please select','morvaridlite'),
                'no-repeat' => esc_html__('No-Repeat','morvaridlite'),
                'repeat' => esc_html__('Repeat','morvaridlite'),
                'repeat-x' => esc_html__('Repeat-x','morvaridlite'),
                'repeat-y' => esc_html__('Repeat-y','morvaridlite')    
            )
        )
    );  
    $wp_customize->add_control( 
        'morvaridlite_background_banner_size',
        array(
            'label' => esc_html__( 'Background Size', 'morvaridlite' ),
            'section' => 'morvaridlite_section_banner_page',
            'type' => 'select',
            'choices' => array(
                '' => esc_html__('Please select','morvaridlite'),
                'cover' => esc_html__('Cover','morvaridlite'),
                'contain' => esc_html__('Contain','morvaridlite')
            )
        )
    );  

    /** Social Media */
    $wp_customize->add_setting('morvaridlite_facebook_url', array('default' => '', 'sanitize_callback' => 'sanitize_text_field'));
    $wp_customize->add_setting('morvaridlite_twitter_url', array('default' => '', 'sanitize_callback' => 'sanitize_text_field'));
    $wp_customize->add_setting('morvaridlite_instagram_url', array('default' => '', 'sanitize_callback' => 'sanitize_text_field'));
    $wp_customize->add_setting('morvaridlite_pinterest_url', array('default' => '', 'sanitize_callback' => 'sanitize_text_field'));
    $wp_customize->add_setting('morvaridlite_youtube_url', array('default' => '', 'sanitize_callback' => 'sanitize_text_field')); 
    $wp_customize->add_setting('morvaridlite_vimeo_url', array('default' => '', 'sanitize_callback' => 'sanitize_text_field'));
    $wp_customize->add_setting('morvaridlite_linkedin_url', array('default' => '', 'sanitize_callback' => 'sanitize_text_field'));
    
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'morvaridlite_facebook_url', array('label' => esc_html__('Facebook URL', 'morvaridlite'), 'section' => 'morvaridlite_section_social_media', 'settings' => 'morvaridlite_facebook_url', 'type' => 'text', 'priority' => 1)));
	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'morvaridlite_twitter_url', array('label' => esc_html__('Twitter URL', 'morvaridlite'), 'section' => 'morvaridlite_section_social_media', 'settings' => 'morvaridlite_twitter_url', 'type' => 'text', 'priority' => 2)));
	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'morvaridlite_instagram_url', array('label' => esc_html__('Instagram URL', 'morvaridlite'), 'section' => 'morvaridlite_section_social_media', 'settings' => 'morvaridlite_instagram_url', 'type' => 'text', 'priority' => 3)));
	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'morvaridlite_pinterest_url', array('label' => esc_html__('Pinterest URL', 'morvaridlite'), 'section' => 'morvaridlite_section_social_media', 'settings' => 'morvaridlite_pinterest_url', 'type' => 'text', 'priority' => 4)));
	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'morvaridlite_youtube_url', array('label' => esc_html__('Youtube URL', 'morvaridlite'), 'section' => 'morvaridlite_section_social_media', 'settings'  => 'morvaridlite_youtube_url', 'type' => 'text', 'priority' => 6)));
	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'morvaridlite_vimeo_url', array('label' => esc_html__('Vimeo URL', 'morvaridlite'), 'section' => 'morvaridlite_section_social_media', 'settings' => 'morvaridlite_vimeo_url', 'type' => 'text', 'priority' => 7)));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'morvaridlite_linkedin_url', array('label' => esc_html__('Linkedin URL', 'morvaridlite'), 'section' => 'morvaridlite_section_social_media', 'settings' => 'morvaridlite_linkedin_url', 'type' => 'text', 'priority' => 8)));


    /** Footer */
    $wp_customize->add_setting( 'morvaridlite_instagram_show', array( 'default' => false, 'sanitize_callback' => 'morvaridlite_sanitize_checkbox' ) );
    $wp_customize->add_setting( 'morvaridlite_social_footer_enable', array('default' => false,'sanitize_callback' => 'morvaridlite_sanitize_checkbox' ) );
    $wp_customize->add_setting( 'morvaridlite_footer_copyright_text', array( 'default' => esc_html__('Your Copyright Here', 'morvaridlite'), 'sanitize_callback' => 'wp_kses_post'));
    
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'morvaridlite_instagram_show',
            array(
                'label' => 'Show Instagram Feed',
                'section' => 'morvaridlite_section_footer',
                'type'  => 'checkbox'
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'morvaridlite_social_footer_enable',
            array(
                'label' => esc_html__('Show Social Network?', 'morvaridlite'),
                'section' => 'morvaridlite_section_footer',
                'type' => 'checkbox'
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'footer_copyright',
            array(
            'label' => esc_html__('Copyright Text', 'morvaridlite'), 
            'section' => 'morvaridlite_section_footer', 
            'settings' => 'morvaridlite_footer_copyright_text', 
            'type' => 'textarea'
        )
    ));

    /** Colors */
    $wp_customize->add_setting('morvaridlite_body_color', array('default' => esc_attr('#464646'), 'sanitize_callback' => 'sanitize_text_field'));
    $wp_customize->add_setting('morvaridlite_accent_color', array('default' => esc_attr('#925A41'), 'sanitize_callback' => 'sanitize_text_field'));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'morvaridlite_body_color', array('label' => esc_html__('Body Text Color', 'morvaridlite'), 'section' => 'colors', 'settings' => 'morvaridlite_body_color')));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'morvaridlite_accent_color', array('label' => esc_html__('Accent Color', 'morvaridlite'), 'section' => 'colors', 'settings' => 'morvaridlite_accent_color')));
    
}
add_action( 'customize_register', 'morvaridlite_register_theme_customizer' );
?>