<?php
/**
 * Template part for displaying page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Morphology Lite
 */

?>


<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>


  <?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => get_the_title(), 'itemprop' => "image")); ?>
 
  
    <header class="entry-header">
      <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
      </header><!-- .entry-header -->
    
    <div class="entry-content">
      <?php the_content(); ?>
      <?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'morphology-lite' ),
				'after'  => '</div>',
			) );
		?>
      </div>
    
    <footer class="entry-footer">
      <?php
	  if( esc_attr(get_theme_mod( 'show_edit', 0 ) ) ) :
			edit_post_link(
				sprintf(
					/* translators: %s: Name of current post */
					esc_html__( 'Edit %s', 'morphology-lite' ),
					the_title( '<span class="screen-reader-text">"', '"</span>', false )
				),
				'<span class="edit-link">',
				'</span>'
			);
		endif; 
	  
		?>
    </footer><!-- .entry-footer -->
    
</article><!-- #post-## -->
