<?php
/**
 * Title: Team Info
 * Slug: moog/team-info
 * Categories: about
 * Viewport width: 1640
 */
?>

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"right":"var:preset|spacing|9","left":"var:preset|spacing|9"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull" style="padding-right:var(--wp--preset--spacing--9);padding-left:var(--wp--preset--spacing--9)">
<!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|12","bottom":"var:preset|spacing|9"}}},"layout":{"type":"default"}} -->
<div class="wp-block-group alignwide" style="padding-top:var(--wp--preset--spacing--12);padding-bottom:var(--wp--preset--spacing--9)">
<!-- wp:heading {"level":1} -->
<h1 class="wp-block-heading">Hello.<br>We are Moog.</h1>
<!-- /wp:heading -->

</div>
<!-- /wp:group -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|9"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"width":"33.33%","style":{"spacing":{"padding":{"top":"var:preset|spacing|12","bottom":"var:preset|spacing|12"},"blockGap":"var:preset|spacing|9"}}} -->
<div class="wp-block-column" style="padding-top:var(--wp--preset--spacing--12);padding-bottom:var(--wp--preset--spacing--12);flex-basis:33.33%">



<!-- wp:group {"style":{"border":{"radius":"1.5rem","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|9","bottom":"var:preset|spacing|9","left":"var:preset|spacing|9","right":"var:preset|spacing|9"}}},"borderColor":"border-primary","backgroundColor":"surface-secondary","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-border-primary-border-color has-surface-secondary-background-color has-background" style="border-width:1px;border-radius:1.5rem;padding-top:var(--wp--preset--spacing--9);padding-right:var(--wp--preset--spacing--9);padding-bottom:var(--wp--preset--spacing--9);padding-left:var(--wp--preset--spacing--9)">

<!-- wp:image {"width":"96px","height":"96px","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"border":{"width":"0px","style":"none","radius":"100px"}},"className":"is-resized"} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/avatar-person-2.jpg" alt="Team Member" style="border-style:none;border-width:0px;border-radius:100px;object-fit:cover;width:96px;height:96px"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"style":{"spacing":{"padding":{"top":"var:preset|spacing|4"}},"typography":{"fontStyle":"normal","fontWeight":"600"}}} -->
<p style="padding-top:var(--wp--preset--spacing--4);font-style:normal;font-weight:600">Yuki Kobayashi</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"spacing":{"padding":{"top":"var:preset|spacing|2"}}},"fontSize":"text-xxs"} -->
<p class="has-text-xxs-font-size" style="padding-top:var(--wp--preset--spacing--2)">Founder of Moog</p>
<!-- /wp:paragraph -->

<!-- wp:social-links {"iconColor":"text-primary","iconColorValue":"#0B0B0B","style":{"spacing":{"margin":{"top":"var:preset|spacing|4"},"blockGap":{"left":"var:preset|spacing|3"}}},"className":"is-style-logos-only"} -->
<ul class="wp-block-social-links has-icon-color is-style-logos-only" style="margin-top:var(--wp--preset--spacing--4)"><!-- wp:social-link {"url":"#","service":"facebook","rel":""} /-->

<!-- wp:social-link {"url":"#","service":"behance"} /--></ul>
<!-- /wp:social-links --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"border":{"radius":"1.5rem","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|9","bottom":"var:preset|spacing|9","left":"var:preset|spacing|9","right":"var:preset|spacing|9"}}},"borderColor":"border-primary","backgroundColor":"surface-secondary","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-border-primary-border-color has-surface-secondary-background-color has-background" style="border-width:1px;border-radius:1.5rem;padding-top:var(--wp--preset--spacing--9);padding-right:var(--wp--preset--spacing--9);padding-bottom:var(--wp--preset--spacing--9);padding-left:var(--wp--preset--spacing--9)">

<!-- wp:image {"width":"96px","height":"96px","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"border":{"width":"0px","style":"none","radius":"100px"}},"className":"is-resized"} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/avatar-person-1.jpg" alt="Team Member" style="border-style:none;border-width:0px;border-radius:100px;object-fit:cover;width:96px;height:96px"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"style":{"spacing":{"padding":{"top":"var:preset|spacing|4"}},"typography":{"fontStyle":"normal","fontWeight":"600"}}} -->
<p style="padding-top:var(--wp--preset--spacing--4);font-style:normal;font-weight:600">Miu Nakamura</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"spacing":{"padding":{"top":"var:preset|spacing|2"}}},"fontSize":"text-xxs"} -->
<p class="has-text-xxs-font-size" style="padding-top:var(--wp--preset--spacing--2)">Curator and Artist</p>
<!-- /wp:paragraph -->

<!-- wp:social-links {"iconColor":"text-primary","iconColorValue":"#0B0B0B","style":{"spacing":{"margin":{"top":"var:preset|spacing|4"},"blockGap":{"left":"var:preset|spacing|3"}}},"className":"is-style-logos-only"} -->
<ul class="wp-block-social-links has-icon-color is-style-logos-only" style="margin-top:var(--wp--preset--spacing--4)"><!-- wp:social-link {"url":"#","service":"facebook","rel":""} /-->

<!-- wp:social-link {"url":"#","service":"behance"} /--></ul>
<!-- /wp:social-links --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"66.66%","style":{"spacing":{"padding":{"top":"var:preset|spacing|12","bottom":"var:preset|spacing|12"}}}} -->
<div class="wp-block-column" style="padding-top:var(--wp--preset--spacing--12);padding-bottom:var(--wp--preset--spacing--12);flex-basis:66.66%"><!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|text-primary"}}},"typography":{"fontStyle":"normal","fontWeight":"600","letterSpacing":"-2.75px","lineHeight":"1.06"}},"textColor":"text-primary","fontSize":"text-4-xl"} -->
<p class="has-text-primary-color has-text-color has-link-color has-text-4-xl-font-size" style="font-style:normal;font-weight:600;letter-spacing:-2.75px;line-height:1.06">As devoted advocates for modern artistic expression, we've curated a virtual haven where innovation reigns supreme and <mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-text-accent-color">diverse voices find their resonance.</mark></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.3"}},"fontSize":"text-xl"} -->
<p class="has-text-xl-font-size" style="line-height:1.3"><strong style="font-weight:600">Our mission?</strong> To unravel the intricate stories of artists spanning the globe, offering a platform for their distinctive visions and groundbreaking creations to shine. From avant-garde installations that challenge the senses to the latest in digital marvels redefining artistic boundaries, we dive headfirst into the most cutting-edge topics and trends in contemporary art.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.3"}},"fontSize":"text-xl"} -->
<p class="has-text-xl-font-size" style="line-height:1.3">Yet, our journey extends beyond the canvas. We believe that true art is a tapestry woven by communities, each thread contributing to a larger, vibrant narrative. Through our blog, we open the door for these diverse voices to share their experiences, providing a platform for untold stories that redefine the very essence of creation and connection.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.3"}},"fontSize":"text-xl"} -->
<p class="has-text-xl-font-size" style="line-height:1.3">So, whether you're an artist seeking inspiration, an enthusiast eager to explore new horizons, or simply someone captivated by the boundless possibilities of human expression, we invite you to join us. Together, let's embark on a dynamic journey, painting a vivid narrative of the ever-evolving world of contemporary art.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->
</div>
<!-- /wp:group -->
