<?php
/**
 * Template part for displaying Slider
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Moncaro_lite
 */

$moncaro_lite_enable_slider = moncaro_lite_gtm( 'moncaro_lite_slider_visibility' );

if ( ! moncaro_lite_display_section( $moncaro_lite_enable_slider ) ) {
	return;
}

$moncaro_lite_classes[] = 'section';
$moncaro_lite_classes[] = 'no-padding';

if ( moncaro_lite_gtm( 'moncaro_lite_slider_overlay' ) ) {
	$moncaro_lite_classes[] = 'overlay-enabled';
}

$moncaro_lite_classes[] = 'style-one';

if ( ! moncaro_lite_gtm( 'moncaro_lite_slider_zoom' ) ) {
	$moncaro_lite_classes[] = 'zoom-disabled';
}

$slider_zoom = moncaro_lite_gtm( 'moncaro_lite_slider_zoom' );
?>
<div id="slider-section" class="<?php echo esc_attr( implode( ' ', $moncaro_lite_classes ) ) ; ?>">
	<div class="swiper-wrapper">
		<?php get_template_part( 'template-parts/slider/post', 'type' ); ?>
	</div><!-- .swiper-wrapper -->


	<div class="swiper-pagination"></div>
	<div class="swiper-button-prev"></div>
    <div class="swiper-button-next"></div>
</div><!-- .main-slider -->
