<?php
/**
 * Template part for displaying Hero Content
 *
 * @package Moncaro_lite
 */

if ( moncaro_lite_gtm( 'moncaro_lite_promotional_headline_page' ) ) {
	$moncaro_lite_args = array(
		'page_id' => absint( moncaro_lite_gtm( 'moncaro_lite_promotional_headline_page' ) ),
	);
} 

// If $moncaro_lite_args is empty return false
if ( empty( $moncaro_lite_args ) ) {
	return;
}

$moncaro_lite_args['posts_per_page'] = 1;

$moncaro_lite_loop = new WP_Query( $moncaro_lite_args );

while ( $moncaro_lite_loop->have_posts() ) :
	$moncaro_lite_loop->the_post();
	$overlay  = moncaro_lite_gtm( 'moncaro_lite_promotional_headline_overlay' ) ? ' overlay-enabled' : '';
	?>

	<div id="promotional-headline-section" class="section promotional-headline-section text-aligncenter<?php echo esc_attr( $overlay ); ?>" <?php echo has_post_thumbnail() ? 'style="background-image: url( ' .esc_url( get_the_post_thumbnail_url() ) . ' )"' : ''; ?>>
	<div class="promotion-inner-wrapper section-promotion">
		<div class="container">
			<div class="promotion-content">
				<div class="promotion-description">
					<?php the_title( '<h2>', '</h2>' ); ?>

					<?php the_excerpt(); ?>
				</div><!-- .promotion-description -->
			</div><!-- .promotion-content -->
		</div><!-- .container -->
	</div><!-- .promotion-inner-wrapper" -->
</div><!-- .section -->
<?php
endwhile;

wp_reset_postdata();
