<?php
/**
 * Template part for displaying Hero Content
 *
 * @package Moncaro_lite
 */

if ( moncaro_lite_gtm( 'moncaro_lite_hero_content_page' ) ) {
	$moncaro_lite_args = array(
		'page_id' => absint( moncaro_lite_gtm( 'moncaro_lite_hero_content_page' ) ),
	);
}

// If $moncaro_lite_args is empty return false
if ( empty( $moncaro_lite_args ) ) {
	return;
}

$moncaro_lite_args['posts_per_page'] = 1;

$moncaro_lite_loop = new WP_Query( $moncaro_lite_args );

while ( $moncaro_lite_loop->have_posts() ) :
	$moncaro_lite_loop->the_post();

	$subtitle      = moncaro_lite_gtm( 'moncaro_lite_hero_content_custom_subtitle' );
	?>

	<div id="hero-content-section" class="hero-content-section section content-position-right default">
		<div class="section-featured-page">
			<div class="container">
				<div class="row">
					<?php if ( has_post_thumbnail() ) : ?>
					<div class="ff-grid-6 featured-page-thumb">
						<?php the_post_thumbnail( 'moncaro-lite-hero', array( 'class' => 'alignnone' ) );?>
					</div>
					<?php endif; ?>

					<!-- .ff-grid-6 -->
					<div class="ff-grid-6 featured-page-content">
						<div class="featured-page-section">
							<div class="section-title-wrap">
								<?php if ( $subtitle ) : ?>
								<p class="section-top-subtitle"><?php echo esc_html( $subtitle ); ?></p>
								<?php endif; ?>

								<?php the_title( '<h2 class="section-title">', '</h2>' ); ?>

								<span class="divider"></span>
							</div>

							<div class="featured-info">
								<?php the_excerpt(); ?>
							</div><!-- .featured-info -->
						</div><!-- .featured-page-section -->
					</div><!-- .ff-grid-6 -->
				</div><!-- .row -->
			</div><!-- .container -->
		</div><!-- .section-featured-page -->
	</div><!-- .section -->
<?php
endwhile;

wp_reset_postdata();
