<?php
/**
 * Header Search
 *
 * @package Moncaro_lite
 */

$moncaro_lite_phone      = moncaro_lite_gtm( 'moncaro_lite_header_phone' );
$moncaro_lite_email      = moncaro_lite_gtm( 'moncaro_lite_header_email' );
$moncaro_lite_address    = moncaro_lite_gtm( 'moncaro_lite_header_address' );
$moncaro_lite_open_hours = moncaro_lite_gtm( 'moncaro_lite_header_open_hours' );

if ( $moncaro_lite_phone || $moncaro_lite_email || $moncaro_lite_address || $moncaro_lite_open_hours ) : ?>
	<div class="inner-quick-contact">
		<ul>
			<?php if ( $moncaro_lite_phone ) : ?>
				<li class="quick-call">
					<span><?php esc_html_e( 'Phone', 'moncaro-lite' ); ?></span><a href="tel:<?php echo preg_replace( '/\s+/', '', esc_attr( $moncaro_lite_phone ) ); ?>"><?php echo esc_html( $moncaro_lite_phone ); ?></a> </li>
			<?php endif; ?>

			<?php if ( $moncaro_lite_email ) : ?>
				<li class="quick-email"><span><?php esc_html_e( 'Email', 'moncaro-lite' ); ?></span><a href="<?php echo esc_url( 'mailto:' . esc_attr( antispambot( $moncaro_lite_email ) ) ); ?>"><?php echo esc_html( antispambot( $moncaro_lite_email ) ); ?></a> </li>
			<?php endif; ?>

			<?php if ( $moncaro_lite_address ) : ?>
				<li class="quick-address"><span><?php esc_html_e( 'Address', 'moncaro-lite' ); ?></span><?php echo esc_html( $moncaro_lite_address ); ?></li>
			<?php endif; ?>

			<?php if ( $moncaro_lite_open_hours ) : ?>
				<li class="quick-open-hours"><span><?php esc_html_e( 'Open Hours', 'moncaro-lite' ); ?></span><?php echo esc_html( $moncaro_lite_open_hours ); ?></li>
			<?php endif; ?>
		</ul>
	</div><!-- .inner-quick-contact -->
<?php endif; ?>

