<?php
/**
 * Template part for displaying Service
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Moncaro_lite
 */

$moncaro_lite_enable = moncaro_lite_gtm( 'moncaro_lite_featured_content_visibility' );

if ( ! moncaro_lite_display_section( $moncaro_lite_enable ) ) {
	return;
}
?>
<div id="featured-content-section" class="section style-one">
	<div class="section-latest-posts">
		<div class="container">
			<?php moncaro_lite_section_title( 'featured_content' ); ?>

			<?php get_template_part( 'template-parts/featured-content/post-type' ); ?>

			<?php
			$moncaro_lite_button_text   = moncaro_lite_gtm( 'moncaro_lite_featured_content_button_text' );
			$moncaro_lite_button_link   = moncaro_lite_gtm( 'moncaro_lite_featured_content_button_link' );
			$moncaro_lite_button_target = moncaro_lite_gtm( 'moncaro_lite_featured_content_button_target' ) ? '_blank' : '_self';

			if ( $moncaro_lite_button_text ) : ?>
				<div class="more-wrapper clear-fix">
					<a href="<?php echo esc_url($moncaro_lite_button_link); ?>" class="ff-button" target="<?php echo esc_attr($moncaro_lite_button_target); ?>"><?php echo esc_html($moncaro_lite_button_text); ?></a>
				</div><!-- .more-wrapper -->
			<?php endif; ?>
			</div><!-- .container -->
		</div><!-- .latest-posts-section -->
	</div><!-- .section-latest-posts -->

