<?php
/**
 * Template part for displaying Post Types Slider
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Moncaro_lite
 */

$associate_logo_args = moncaro_lite_get_section_args( 'associate_logo' );

$moncaro_lite_loop = new WP_Query( $associate_logo_args );

if ( $moncaro_lite_loop->have_posts() ) :
	?>
	<div class="associate-logo-section associate-logo-col-6">
		<div class="row">
		<?php

		while ( $moncaro_lite_loop->have_posts() ) :
			$moncaro_lite_loop->the_post();

			if ( has_post_thumbnail() ) : ?>
			<div class="associate-logo-item ff-grid-2">
				<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'thumbnail' ); ?></a>
			</div><!-- .associate-logo-item -->
		<?php
			endif;
		endwhile;
		?>
		</div><!-- .row -->
	</div><!-- .associate-logo-wrapper -->
<?php
endif;

wp_reset_postdata();
