<?php
/**
 * WWD Options
 *
 * @package Moncaro_lite
 */

class Moncaro_lite_WWD_Options {
	public function __construct() {
		// Register WWD Options.
		add_action( 'customize_register', array( $this, 'register_options' ), 99 );

		// Add default options.
		add_filter( 'moncaro_lite_customizer_defaults', array( $this, 'add_defaults' ) );
	}

	/**
	 * Add options to defaults
	 */
	public function add_defaults( $default_options ) {
		$defaults = array(
			'moncaro_lite_wwd_visibility' => 'disabled',
			'moncaro_lite_wwd_number'     => 6,
		);

		$updated_defaults = wp_parse_args( $defaults, $default_options );

		return $updated_defaults;
	}

	/**
	 * Add layouts section and its controls
	 */
	public function register_options( $wp_customize ) {
		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_wwd_visibility',
				'type'              => 'select',
				'sanitize_callback' => 'moncaro_lite_sanitize_select',
				'label'             => esc_html__( 'Visible On', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_wwd',
				'choices'           => Moncaro_lite_Customizer_Utilities::section_visibility(),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'text',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'settings'          => 'moncaro_lite_wwd_section_top_subtitle',
				'label'             => esc_html__( 'Section Top Sub-title', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_wwd',
				'active_callback'   => array( $this, 'is_wwd_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_wwd_section_title',
				'type'              => 'text',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Section Title', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_wwd',
				'active_callback'   => array( $this, 'is_wwd_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_wwd_section_subtitle',
				'type'              => 'text',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Section Subtitle', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_wwd',
				'active_callback'   => array( $this, 'is_wwd_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_wwd_number',
				'type'              => 'number',
				'label'             => esc_html__( 'Number', 'moncaro-lite' ),
				'description'       => esc_html__( 'Please refresh the customizer page once the number is changed.', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_wwd',
				'sanitize_callback' => 'absint',
				'input_attrs'       => array(
					'min'   => 1,
					'max'   => 80,
					'step'  => 1,
					'style' => 'width:100px;',
				),
				'active_callback'   => array( $this, 'is_wwd_visible' ),
			)
		);

		$numbers = moncaro_lite_gtm( 'moncaro_lite_wwd_number' );

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_wwd_category',
				'custom_control'    => 'Moncaro_lite_Dropdown_Select2_Custom_Control',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Pick Categories', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_wwd',
				'choices'           => array( esc_html__( '--Select--', 'moncaro-lite' ) => Moncaro_lite_Customizer_Utilities::get_terms( 'category' ) ),
				'active_callback'   => array( $this, 'is_wwd_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Simple_Notice_Custom_Control',
				'sanitize_callback' => 'sanitize_text_field',
				'settings'          => 'moncaro_lite_wwd_icon_note',
				'label'             =>  esc_html__( 'Info', 'moncaro-lite' ),
				'description'       =>  sprintf( esc_html__( 'If you want camera icon, save "fas fa-camera". For more classes, check %1$sthis%2$s', 'moncaro-lite' ), '<a href="' . esc_url( 'https://fontawesome.com/icons?d=gallery&m=free' ) . '" target="_blank">', '</a>' ),
				'section'           => 'moncaro_lite_ss_wwd',
				'active_callback'   => array( $this, 'is_wwd_visible' ),
			)
		);

		for( $i = 0; $i < $numbers; $i++ ) {
			Moncaro_lite_Customizer_Utilities::register_option(
				array(
					'sanitize_callback' => 'sanitize_text_field',
					'settings'          => 'moncaro_lite_wwd_custom_icon_' . $i,
					'label'             => esc_html__( 'Icon Class', 'moncaro-lite' ),
					'section'           => 'moncaro_lite_ss_wwd',
					'active_callback'   => array( $this, 'is_wwd_visible' ),
				)
			);
		}
	}

	/**
	 * WWD visibility active callback.
	 */
	public function is_wwd_visible( $control ) {
		return ( moncaro_lite_display_section( $control->manager->get_setting( 'moncaro_lite_wwd_visibility' )->value() ) );
	}
}

/**
 * Initialize class
 */
$moncaro_lite_ss_wwd = new Moncaro_lite_WWD_Options();
