<?php
/**
 * Adds the theme options sections, settings, and controls to the theme customizer
 *
 * @package Moncaro_lite
 */

class Moncaro_lite_Theme_Options {
	public function __construct() {
		// Register our Panel.
		add_action( 'customize_register', array( $this, 'add_panel' ) );

		// Register Breadcrumb Options.
		add_action( 'customize_register', array( $this, 'register_breadcrumb_options' ) );

		// Register Excerpt Options.
		add_action( 'customize_register', array( $this, 'register_excerpt_options' ) );

		// Register Homepage Options.
		add_action( 'customize_register', array( $this, 'register_homepage_options' ) );

		// Register Layout Options.
		add_action( 'customize_register', array( $this, 'register_layout_options' ) );

		// Register Search Options.
		add_action( 'customize_register', array( $this, 'register_search_options' ) );

		// Add default options.
		add_filter( 'moncaro_lite_customizer_defaults', array( $this, 'add_defaults' ) );
	}

	/**
	 * Add options to defaults
	 */
	public function add_defaults( $default_options ) {
		$defaults = array(
			// Header Media.
			'moncaro_lite_header_image_visibility' => 'entire-site',

			// Breadcrumb
			'moncaro_lite_breadcrumb_show' => 1,

			// Layout Options.
			'moncaro_lite_layout_type'             => 'fluid',
			'moncaro_lite_default_layout'          => 'right-sidebar',
			'moncaro_lite_homepage_archive_layout' => 'no-sidebar-full-width',
			
			// Excerpt Options
			'moncaro_lite_excerpt_length'    => 30,
			'moncaro_lite_excerpt_more_text' => esc_html__( 'Continue reading', 'moncaro-lite' ),

			// Homepage/Frontpage Options.
			'moncaro_lite_front_page_category'   => '',
			'moncaro_lite_show_homepage_content' => 1,
			
			// Search Options.
			'moncaro_lite_search_text'         => esc_html__( 'Search...', 'moncaro-lite' ),
		);


		$updated_defaults = wp_parse_args( $defaults, $default_options );

		return $updated_defaults;
	}

	/**
	 * Register the Customizer panels
	 */
	public function add_panel( $wp_customize ) {
		/**
		 * Add our Header & Navigation Panel
		 */
		 $wp_customize->add_panel( 'moncaro_lite_theme_options',
		 	array(
				'title' => esc_html__( 'Theme Options', 'moncaro-lite' ),
			)
		);
	}

	/**
	 * Add breadcrumb section and its controls
	 */
	public function register_breadcrumb_options( $wp_customize ) {
		// Add Excerpt Options section.
		$wp_customize->add_section( 'moncaro_lite_breadcrumb_options',
			array(
				'title' => esc_html__( 'Breadcrumb', 'moncaro-lite' ),
				'panel' => 'moncaro_lite_theme_options',
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Toggle_Switch_Custom_control',
				'settings'          => 'moncaro_lite_breadcrumb_show',
				'sanitize_callback' => 'moncaro_lite_switch_sanitization',
				'label'             => esc_html__( 'Display Breadcrumb?', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_breadcrumb_options',
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Toggle_Switch_Custom_control',
				'settings'          => 'moncaro_lite_breadcrumb_show_home',
				'sanitize_callback' => 'moncaro_lite_switch_sanitization',
				'label'             => esc_html__( 'Show on homepage?', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_breadcrumb_options',
			)
		);
	}

	/**
	 * Add layouts section and its controls
	 */
	public function register_layout_options( $wp_customize ) {
		// Add layouts section.
		$wp_customize->add_section( 'moncaro_lite_layouts',
			array(
				'title' => esc_html__( 'Layouts', 'moncaro-lite' ),
				'panel' => 'moncaro_lite_theme_options'
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'select',
				'settings'          => 'moncaro_lite_layout_type',
				'sanitize_callback' => 'moncaro_lite_sanitize_select',
				'label'             => esc_html__( 'Site Layout', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_layouts',
				'choices'           => array(
					'fluid' => esc_html__( 'Fluid', 'moncaro-lite' ),
					'boxed' => esc_html__( 'Boxed', 'moncaro-lite' ),
				),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'select',
				'settings'          => 'moncaro_lite_default_layout',
				'sanitize_callback' => 'moncaro_lite_sanitize_select',
				'label'             => esc_html__( 'Default Layout', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_layouts',
				'choices'           => array(
					'right-sidebar'         => esc_html__( 'Right Sidebar', 'moncaro-lite' ),
					'no-sidebar-full-width' => esc_html__( 'No Sidebar: Full Width', 'moncaro-lite' ),
				),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'select',
				'settings'          => 'moncaro_lite_homepage_archive_layout',
				'sanitize_callback' => 'moncaro_lite_sanitize_select',
				'label'             => esc_html__( 'Homepage/Archive Layout', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_layouts',
				'choices'           => array(
					'right-sidebar'         => esc_html__( 'Right Sidebar', 'moncaro-lite' ),
					'no-sidebar-full-width' => esc_html__( 'No Sidebar: Full Width', 'moncaro-lite' ),
				),
			)
		);
	}

	/**
	 * Add excerpt section and its controls
	 */
	public function register_excerpt_options( $wp_customize ) {
		// Add Excerpt Options section.
		$wp_customize->add_section( 'moncaro_lite_excerpt_options',
			array(
				'title' => esc_html__( 'Excerpt Options', 'moncaro-lite' ),
				'panel' => 'moncaro_lite_theme_options',
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'number',
				'settings'          => 'moncaro_lite_excerpt_length',
				'sanitize_callback' => 'absint',
				'label'             => esc_html__( 'Excerpt Length (Words)', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_excerpt_options',
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'text',
				'settings'          => 'moncaro_lite_excerpt_more_text',
				'sanitize_callback' => 'sanitize_text_field',
				'label'             => esc_html__( 'Excerpt More Text', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_excerpt_options',
			)
		);
	}

	/**
	 * Add Homepage/Frontpage section and its controls
	 */
	public function register_homepage_options( $wp_customize ) {
		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Dropdown_Select2_Custom_Control',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'settings'          => 'moncaro_lite_front_page_category',
				'description'       => esc_html__( 'Filter Homepage/Blog page posts by following categories', 'moncaro-lite' ),
				'label'             => esc_html__( 'Categories', 'moncaro-lite' ),
				'section'           => 'static_front_page',
				'choices'           => array( esc_html__( '--Select--', 'moncaro-lite' ) => Moncaro_lite_Customizer_Utilities::get_terms( 'category' ) ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Toggle_Switch_Custom_control',
				'settings'          => 'moncaro_lite_show_homepage_content',
				'sanitize_callback' => 'moncaro_lite_switch_sanitization',
				'label'             => esc_html__( 'Show Home Content/Blog', 'moncaro-lite' ),
				'section'           => 'static_front_page',
			)
		);
	}

	/**
	 * Add Homepage/Frontpage section and its controls
	 */
	public function register_search_options( $wp_customize ) {
		// Add Homepage/Frontpage Section.
		$wp_customize->add_section( 'moncaro_lite_search',
			array(
				'title' => esc_html__( 'Search', 'moncaro-lite' ),
				'panel' => 'moncaro_lite_theme_options',
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_search_text',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Search Text', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_search',
				'type'              => 'text',
			)
		);
	}

	/**
	 * Array for fonts.
	 */
	public static function get_font_options() {
		$fonts = array(
			'moncaro_lite_body_font' => array(
				'label'    => esc_html__( 'Body(Default)', 'moncaro-lite' ),
				'selector' => 'body',
			),
			'moncaro_lite_title_font' => array(
				'label'    => esc_html__( 'Site Title', 'moncaro-lite' ),
				'selector' => '.site-title',
			),
			'moncaro_lite_tagline_font' => array(
				'label'    => esc_html__( 'Tagline', 'moncaro-lite' ),
				'selector' => '.site-description',
			),
			'moncaro_lite_content_font' => array(
				'label'    => esc_html__( 'Content', 'moncaro-lite' ),
				'selector' => '#content, #content p',
			),
			'moncaro_lite_headings_font' => array(
				'label'    => esc_html__( 'Headings (h1 to h6)', 'moncaro-lite' ),
				'selector' => 'h1, h2, h3, h4, h5, h6',
			),
			'moncaro_lite_content_font' => array(
				'label'    => esc_html__( 'Section Title', 'moncaro-lite' ),
				'selector' => '#hero-content .section-title',
			),
		);

		return $fonts;
	}
}

/**
 * Initialize class
 */
$moncaro_lite_theme_options = new Moncaro_lite_Theme_Options();
