<?php
/**
 * Testimonial Options
 *
 * @package Moncaro_lite
 */

class Moncaro_lite_Testimonial_Options {
	public function __construct() {
		// Register Testimonial Options.
		add_action( 'customize_register', array( $this, 'register_options' ), 99 );

		// Add default options.
		add_filter( 'moncaro_lite_customizer_defaults', array( $this, 'add_defaults' ) );
	}

	/**
	 * Add options to defaults
	 */
	public function add_defaults( $default_options ) {
		$defaults = array(
			'moncaro_lite_testimonial_visibility' => 'disabled',
			'moncaro_lite_testimonial_number'     => 4,

		);

		$updated_defaults = wp_parse_args( $defaults, $default_options );

		return $updated_defaults;
	}

	/**
	 * Add layouts section and its controls
	 */
	public function register_options( $wp_customize ) {
		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_testimonial_visibility',
				'type'              => 'select',
				'sanitize_callback' => 'moncaro_lite_sanitize_select',
				'label'             => esc_html__( 'Visible On', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_testimonial',
				'choices'           => Moncaro_lite_Customizer_Utilities::section_visibility(),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'text',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'settings'          => 'moncaro_lite_testimonial_section_top_subtitle',
				'label'             => esc_html__( 'Section Top Sub-title', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_testimonial',
				'active_callback'   => array( $this, 'is_testimonial_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_testimonial_section_title',
				'type'              => 'text',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Section Title', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_testimonial',
				'active_callback'   => array( $this, 'is_testimonial_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_testimonial_section_subtitle',
				'type'              => 'text',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Section Subtitle', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_testimonial',
				'active_callback'   => array( $this, 'is_testimonial_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_testimonial_number',
				'type'              => 'number',
				'label'             => esc_html__( 'Number', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_testimonial',
				'sanitize_callback' => 'absint',
				'input_attrs'       => array(
					'min'   => 1,
					'max'   => 80,
					'step'  => 1,
					'style' => 'width:100px;',
				),
				'active_callback'   => array( $this, 'is_testimonial_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_testimonial_category',
				'custom_control'    => 'Moncaro_lite_Dropdown_Select2_Custom_Control',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Pick Categories', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_testimonial',
				'choices'           => array( esc_html__( '--Select--', 'moncaro-lite' ) => Moncaro_lite_Customizer_Utilities::get_terms( 'category' ) ),
				'active_callback'   => array( $this, 'is_testimonial_visible' ),
			)
		);
	}

	/**
	 * Testimonial visibility active callback.
	 */
	public function is_testimonial_visible( $control ) {
		return ( moncaro_lite_display_section( $control->manager->get_setting( 'moncaro_lite_testimonial_visibility' )->value() ) );
	}
}

/**
 * Initialize class
 */
$moncaro_lite_ss_testimonial = new Moncaro_lite_Testimonial_Options();
