<?php
/**
 * Moncaro lite Theme Customizer
 *
 * @package Moncaro_lite
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function moncaro_lite_sections( $wp_customize ) {
	$wp_customize->add_panel( 'moncaro_lite_sections', array(
		'title'       => esc_html__( 'Sections', 'moncaro-lite' ),
		'priority'    => 150,
	) );

	$sections = array (
		'slider'               => esc_html__( 'Slider', 'moncaro-lite' ),
		'wwd'                  => esc_html__( 'What We Do', 'moncaro-lite' ),
		'hero_content'         => esc_html__( 'Hero Content', 'moncaro-lite' ),
		'featured_content'     => esc_html__( 'Featured Content', 'moncaro-lite' ),
		'promotional_headline' => esc_html__( 'Promotion Headline', 'moncaro-lite' ),
		'portfolio'            => esc_html__( 'Portfolio', 'moncaro-lite' ),
		'team'                 => esc_html__( 'Team', 'moncaro-lite' ),
		'testimonial'          => esc_html__( 'Testimonials', 'moncaro-lite' ),
		'associate_logo'       => esc_html__( 'Associate Logo', 'moncaro-lite' ),
	);

	foreach( $sections as $key => $value ){
		// Add sections.
		$wp_customize->add_section( 'moncaro_lite_ss_' . $key,
			array(
				'title' => $value,
				'panel' => 'moncaro_lite_sections'
			)
		);
	}
}
add_action( 'customize_register', 'moncaro_lite_sections', 1 );
