<?php
/**
 * Slider Options
 *
 * @package Moncaro_lite
 */

class Moncaro_lite_Slider_Options {
	public function __construct() {
		// Register Slider Options.
		add_action( 'customize_register', array( $this, 'register_options' ), 98 );

		// Register Slider Advance Options.
		add_action( 'customize_register', array( $this, 'register_advanced_options' ), 99 );

		// Add default options.
		add_filter( 'moncaro_lite_customizer_defaults', array( $this, 'add_defaults' ) );
	}

	/**
	 * Add options to defaults
	 */
	public function add_defaults( $default_options ) {
		$defaults = array(
			'moncaro_lite_slider_visibility'        => 'disabled',
			'moncaro_lite_slider_transition_speed'  => 300,
			'moncaro_lite_slider_transition_effect' => 'slide',
			'moncaro_lite_slider_loop'              => 1,
			'moncaro_lite_slider_autoplay_delay'    => 5000,
			'moncaro_lite_slider_pause_on_hover'    => 1,
			'moncaro_lite_slider_overlay'           => 1,
			'moncaro_lite_slider_number'            => 2,
		);

		$updated_defaults = wp_parse_args( $defaults, $default_options );

		return $updated_defaults;
	}

	/**
	 * Add slider section and its controls
	 */
	public function register_options( $wp_customize ) {
		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_slider_visibility',
				'type'              => 'select',
				'sanitize_callback' => 'moncaro_lite_sanitize_select',
				'label'             => esc_html__( 'Visible On', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_slider',
				'choices'           => Moncaro_lite_Customizer_Utilities::section_visibility(),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'number',
				'settings'          => 'moncaro_lite_slider_number',
				'label'             => esc_html__( 'Number', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_slider',
				'sanitize_callback' => 'absint',
				'input_attrs'       => array(
					'min'   => 1,
					'max'   => 80,
					'step'  => 1,
					'style' => 'width:100px;',
				),
				'active_callback'   => array( $this, 'is_slider_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_slider_category',
				'custom_control'    => 'Moncaro_lite_Dropdown_Select2_Custom_Control',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Pick Categories', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_slider',
				'choices'           => array( esc_html__( '--Select--', 'moncaro-lite' ) => Moncaro_lite_Customizer_Utilities::get_terms( 'category' ) ),
				'active_callback'   => array( $this, 'is_slider_visible' ),
			)
		);
	}

	/**
	 * Add slider advance options
	 */
	public function register_advanced_options( $wp_customize ) {
		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Note_Control',
				'settings'          => 'moncaro_lite_slider_advance_options_notice',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Slider Advance Options', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_slider',
				'active_callback'   => array( $this, 'is_slider_visible' ),
				'transport'         => 'postMessage',
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_slider_transition_speed',
				'type'              => 'number',
				'sanitize_callback' => 'absint',
				'label'             => esc_html__( 'Transition Speed', 'moncaro-lite' ),
				'description'       => esc_html__( 'Duration of transition between slides (in ms)', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_slider',
				'input_attrs'           => array(
					'width' => '10px',
				),
				'active_callback'   => array( $this, 'is_slider_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_slider_transition_effect',
				'type'              => 'select',
				'sanitize_callback' => 'moncaro_lite_sanitize_select',
				'label'             => esc_html__( 'Transition Effect', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_slider',
				'choices'           => array(
					'slide'     => esc_html__( 'Slide', 'moncaro-lite' ),
					'fade'      => esc_html__( 'Fade', 'moncaro-lite' ),
					'cube'      => esc_html__( 'Cube', 'moncaro-lite' ),
					'coverflow' => esc_html__( 'Coverflow', 'moncaro-lite' ),
					'flip'      => esc_html__( 'Flip', 'moncaro-lite' ),
				),
				'active_callback'   => array( $this, 'is_slider_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Toggle_Switch_Custom_control',
				'settings'          => 'moncaro_lite_slider_loop',
				'description'       => esc_html__( 'Enable continuous loop mode', 'moncaro-lite' ),
				'sanitize_callback' => 'moncaro_lite_switch_sanitization',
				'label'             => esc_html__( 'Loop', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_slider',
				'active_callback'   => array( $this, 'is_slider_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Toggle_Switch_Custom_control',
				'settings'          => 'moncaro_lite_slider_zoom',
				'description'       => esc_html__( 'Enable zoom effect on images', 'moncaro-lite' ),
				'sanitize_callback' => 'moncaro_lite_switch_sanitization',
				'label'             => esc_html__( 'Zoom Effect', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_slider',
				'active_callback'   => array( $this, 'is_slider_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Toggle_Switch_Custom_control',
				'settings'          => 'moncaro_lite_slider_autoplay',
				'sanitize_callback' => 'moncaro_lite_switch_sanitization',
				'label'             => esc_html__( 'Autoplay', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_slider',
				'active_callback'   => array( $this, 'is_slider_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_slider_autoplay_delay',
				'type'              => 'number',
				'sanitize_callback' => 'absint',
				'label'             => esc_html__( 'Autoplay Delay', 'moncaro-lite' ),
				'description'       => esc_html__( '(in ms)', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_slider',
				'input_attrs'           => array(
					'width' => '10px',
				),
				'active_callback'   => array( $this, 'is_slider_autoplay_on' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Toggle_Switch_Custom_control',
				'settings'          => 'moncaro_lite_slider_pause_on_hover',
				'sanitize_callback' => 'moncaro_lite_switch_sanitization',
				'label'             => esc_html__( 'Pause On Hover', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_slider',
				'active_callback'   => array( $this, 'is_slider_autoplay_on' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Toggle_Switch_Custom_control',
				'settings'          => 'moncaro_lite_slider_overlay',
				'sanitize_callback' => 'moncaro_lite_switch_sanitization',
				'label'             => esc_html__( 'Image Overlay', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_slider',
				'active_callback'   => array( $this, 'is_slider_visible' ),
			)
		);
	}

	/**
	 * Slider visibility active callback.
	 */
	public function is_slider_visible( $control ) {
		return ( moncaro_lite_display_section( $control->manager->get_setting( 'moncaro_lite_slider_visibility' )->value() ) );
	}

	/**
	 * Slider autoplay check.
	 */
	public function is_slider_autoplay_on( $control ) {
		return ( $this->is_slider_visible( $control ) && $control->manager->get_setting( 'moncaro_lite_slider_autoplay' )->value() );
	}
}

/**
 * Initialize class
 */
$moncaro_lite_ss_slider = new Moncaro_lite_Slider_Options();
