<?php
/**
 * Promotional Headline Options
 *
 * @package Moncaro_lite
 */

class Moncaro_lite_Promotional_Headline_Options {
	public function __construct() {
		// Register Promotion Headline Options.
		add_action( 'customize_register', array( $this, 'register_options' ), 99 );

		// Add default options.
		add_filter( 'moncaro_lite_customizer_defaults', array( $this, 'add_defaults' ) );
	}

	/**
	 * Add options to defaults
	 */
	public function add_defaults( $default_options ) {
		$defaults = array(
			'moncaro_lite_promotional_headline_visibility' => 'disabled',
			'moncaro_lite_promotional_headline_overlay'    => 1,
		);

		$updated_defaults = wp_parse_args( $defaults, $default_options );

		return $updated_defaults;
	}

	/**
	 * Add layouts section and its controls
	 */
	public function register_options( $wp_customize ) {
		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_promotional_headline_visibility',
				'type'              => 'select',
				'sanitize_callback' => 'moncaro_lite_sanitize_select',
				'label'             => esc_html__( 'Visible On', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_promotional_headline',
				'choices'           => Moncaro_lite_Customizer_Utilities::section_visibility(),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Dropdown_Posts_Custom_Control',
				'sanitize_callback' => 'absint',
				'settings'          => 'moncaro_lite_promotional_headline_page',
				'label'             => esc_html__( 'Select Page', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_promotional_headline',
				'active_callback'   => array( $this, 'is_promotional_headline_visible' ),
				'input_attrs' => array(
					'post_type'      => 'page',
					'posts_per_page' => -1,
					'orderby'        => 'name',
					'order'          => 'ASC',
				),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Toggle_Switch_Custom_control',
				'settings'          => 'moncaro_lite_promotional_headline_overlay',
				'sanitize_callback' => 'moncaro_lite_switch_sanitization',
				'label'             => esc_html__( 'Overlay on image?', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_promotional_headline',
				'active_callback'   => array( $this, 'is_promotional_headline_visible' ),
			)
		);
	}

	/**
	 * Promotion Headline visibility active callback.
	 */
	public function is_promotional_headline_visible( $control ) {
		return ( moncaro_lite_display_section( $control->manager->get_setting( 'moncaro_lite_promotional_headline_visibility' )->value() ) );
	}
}

/**
 * Initialize class
 */
$moncaro_lite_ss_promotional_headline = new Moncaro_lite_Promotional_Headline_Options();
