<?php
/**
 * Hero Content Options
 *
 * @package Moncaro_lite
 */

class Moncaro_lite_Hero_Content_Options {
	public function __construct() {
		// Register Hero Content Options.
		add_action( 'customize_register', array( $this, 'register_options' ), 99 );

		// Add default options.
		add_filter( 'moncaro_lite_customizer_defaults', array( $this, 'add_defaults' ) );
	}

	/**
	 * Add options to defaults
	 */
	public function add_defaults( $default_options ) {
		$defaults = array(
			'moncaro_lite_hero_content_visibility' => 'disabled',
			'moncaro_lite_hero_content_position'   => 'content-position-right',
			'moncaro_lite_hero_content_text_align' => 'default',
		);

		$updated_defaults = wp_parse_args( $defaults, $default_options );

		return $updated_defaults;
	}

	/**
	 * Add layouts section and its controls
	 */
	public function register_options( $wp_customize ) {
		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_hero_content_visibility',
				'type'              => 'select',
				'sanitize_callback' => 'moncaro_lite_sanitize_select',
				'label'             => esc_html__( 'Visible On', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_hero_content',
				'choices'           => Moncaro_lite_Customizer_Utilities::section_visibility(),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Dropdown_Posts_Custom_Control',
				'sanitize_callback' => 'absint',
				'settings'          => 'moncaro_lite_hero_content_page',
				'label'             => esc_html__( 'Select Page', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_hero_content',
				'active_callback'   => array( $this, 'is_hero_content_visible' ),
				'input_attrs' => array(
					'post_type'      => 'page',
					'posts_per_page' => -1,
					'orderby'        => 'name',
					'order'          => 'ASC',
				),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'text',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'settings'          => 'moncaro_lite_hero_content_custom_subtitle',
				'label'             => esc_html__( 'Top Subtitle', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_hero_content',
				'active_callback'   => array( $this, 'is_hero_content_visible' ),
			)
		);
	}

	/**
	 * Hero Content visibility active callback.
	 */
	public function is_hero_content_visible( $control ) {
		return ( moncaro_lite_display_section( $control->manager->get_setting( 'moncaro_lite_hero_content_visibility' )->value() ) );
	}
}

/**
 * Initialize class
 */
$moncaro_lite_ss_hero_content = new Moncaro_lite_Hero_Content_Options();
