<?php
/**
 * Adds the header options sections, settings, and controls to the theme customizer
 *
 * @package Moncaro_lite
 */

class Moncaro_lite_Header_Options {
	public function __construct() {
		// Register Header Options.
		add_action( 'customize_register', array( $this, 'register_header_options' ) );

		// Add default options.
		add_filter( 'moncaro_lite_customizer_defaults', array( $this, 'add_defaults' ) );
	}

	/**
	 * Add options to defaults
	 */
	public function add_defaults( $default_options ) {
		$defaults = array(
			'moncaro_lite_header_style' => 'header-one',
		);

		$updated_defaults = wp_parse_args( $defaults, $default_options );

		return $updated_defaults;
	}

	/**
	 * Add header options section and its controls
	 */
	public function register_header_options( $wp_customize ) {
		// Add header options section.
		$wp_customize->add_section( 'moncaro_lite_header_options',
			array(
				'title' => esc_html__( 'Header Options', 'moncaro-lite' ),
				'panel' => 'moncaro_lite_theme_options'
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Image_Radio_Button_Custom_Control',
				'settings'          => 'moncaro_lite_header_style',
				'sanitize_callback' => 'moncaro_lite_radio_sanitization',
				'label'             => esc_html__( 'Header Style', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_header_options',
				'choices'           => array(
					'header-one'   => array(
						'image' => trailingslashit( get_template_directory_uri() ) . 'images/header-1.png',
						'name'  => esc_html__( 'Header Style One', 'moncaro-lite' ),
					),
					'header-two'   => array(
						'image' => trailingslashit( get_template_directory_uri() ) . 'images/header-2.png',
						'name'  => esc_html__( 'Header Style Two', 'moncaro-lite' ),
					),
				),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'text',
				'settings'          => 'moncaro_lite_header_email',
				'sanitize_callback' => 'sanitize_email',
				'label'             => esc_html__( 'Email', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_header_options',
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'text',
				'settings'          => 'moncaro_lite_header_phone',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Phone', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_header_options',
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'text',
				'settings'          => 'moncaro_lite_header_address',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Address', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_header_options',
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'text',
				'settings'          => 'moncaro_lite_header_open_hours',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Open Hours', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_header_options',
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'text',
				'settings'          => 'moncaro_lite_header_button_text',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Button Text', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_header_options',
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'url',
				'settings'          => 'moncaro_lite_header_button_link',
				'sanitize_callback' => 'esc_url_raw',
				'label'             => esc_html__( 'Button Link', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_header_options',
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'custom_control'    => 'Moncaro_lite_Toggle_Switch_Custom_control',
				'settings'          => 'moncaro_lite_header_button_target',
				'sanitize_callback' => 'moncaro_lite_switch_sanitization',
				'label'             => esc_html__( 'Open link in new tab?', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_header_options',
			)
		);
	}
}

/**
 * Initialize class
 */
$moncaro_lite_theme_options = new Moncaro_lite_Header_Options();
