<?php
/**
 * Portfolio Options
 *
 * @package Moncaro_lite
 */

class Moncaro_lite_Associate_Logo_Options {
	public function __construct() {
		// Add options to default options.
		add_filter( 'moncaro_lite_customizer_defaults', array( $this, 'add_defaults' ) );

		// Register Portfolio Options.
		add_action( 'customize_register', array( $this, 'register_options' ), 99 );
	}

	/**
	 * Add options to defaults
	 */
	public function add_defaults( $default_options ) {
		$defaults = array(
			'moncaro_lite_associate_logo_visibility' => 'disabled',
			'moncaro_lite_associate_logo_number'     => 10,
		);

		$updated_defaults = wp_parse_args( $defaults, $default_options );

		return $updated_defaults;
	}

	/**
	 * Add default color options to main color options
	 * @param [type] $default_options [description]
	 */
	public function add_colors_to_defaults( $default_options ) {


		return $updated_options;
	}

	/**
	 * Add layouts section and its controls
	 */
	public function register_options( $wp_customize ) {
		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_associate_logo_visibility',
				'type'              => 'select',
				'sanitize_callback' => 'moncaro_lite_sanitize_select',
				'label'             => esc_html__( 'Visible On', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_associate_logo',
				'choices'           => Moncaro_lite_Customizer_Utilities::section_visibility(),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'type'              => 'text',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'settings'          => 'moncaro_lite_associate_logo_section_top_subtitle',
				'label'             => esc_html__( 'Section Top Sub-title', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_associate_logo',
				'active_callback'   => array( $this, 'is_associate_logo_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_associate_logo_section_title',
				'type'              => 'text',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Section Title', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_associate_logo',
				'active_callback'   => array( $this, 'is_associate_logo_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_associate_logo_section_subtitle',
				'type'              => 'text',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Section Subtitle', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_associate_logo',
				'active_callback'   => array( $this, 'is_associate_logo_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_associate_logo_number',
				'type'              => 'number',
				'label'             => esc_html__( 'Number', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_associate_logo',
				'sanitize_callback' => 'absint',
				'input_attrs'       => array(
					'min'   => 1,
					'max'   => 80,
					'step'  => 1,
					'style' => 'width:100px;',
				),
				'active_callback'   => array( $this, 'is_associate_logo_visible' ),
			)
		);

		Moncaro_lite_Customizer_Utilities::register_option(
			array(
				'settings'          => 'moncaro_lite_associate_logo_category',
				'custom_control'    => 'Moncaro_lite_Dropdown_Select2_Custom_Control',
				'sanitize_callback' => 'moncaro_lite_text_sanitization',
				'label'             => esc_html__( 'Pick Categories', 'moncaro-lite' ),
				'section'           => 'moncaro_lite_ss_associate_logo',
				'choices'           => array( esc_html__( '--Select--', 'moncaro-lite' ) => Moncaro_lite_Customizer_Utilities::get_terms( 'category' ) ),
				'active_callback'   => array( $this, 'is_associate_logo_visible' ),
			)
		);
	}

	/**
	 * Portfolio visibility active callback.
	 */
	public function is_associate_logo_visible( $control ) {
		return ( moncaro_lite_display_section( $control->manager->get_setting( 'moncaro_lite_associate_logo_visibility' )->value() ) );
	}
}

/**
 * Initialize class
 */
$moncaro_lite_ss_associate_logo = new Moncaro_lite_Associate_Logo_Options();
