<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package monal
 */
// $class=get_query_var( 'post-class');
?>
<?php if (get_theme_mod('enable_sidebar_option_single_page', 1) == 1){
                                $pageWidth = "cust-bio-left";
                            } else {
                                $pageWidth = "cust-bio-full";
                            }?>
<div id="post-<?php the_ID(); ?>" class="<?php echo $pageWidth; ?>">
    <header class="entry-header">
        <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
    </header><!-- .entry-header -->

    <?php monal_post_thumbnail(); ?>

    <div class="entry-content">
        <?php
		
		the_content(); 

        wp_link_pages(
        array(
        'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'monal' ),
            'after' => '</div>',
        )
        );
        ?>
    </div><!-- .entry-content -->

    <?php if ( get_edit_post_link() ) : ?>
    <footer class="entry-footer">
        <?php
			edit_post_link(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Edit <span class="screen-reader-text">%s</span>', 'monal' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					wp_kses_post( get_the_title() )
				),
				'<span class="edit-link">',
				'</span>'
			);
			?>
    </footer><!-- .entry-footer -->
    <?php endif; 
    if ( comments_open() || get_comments_number() ) :
        comments_template();
    endif;?>

</div><!-- #post-<?php the_ID(); ?> -->