/// Slider
var monal_slider = document.querySelectorAll('.glide');
for (i = 0; i < monal_slider.length; ++i) {
    if (monal_slider[i]) {
        var monal_typeId = monal_slider[i].getAttribute('data-typeId');
        var glide = new Glide(monal_slider[i], {
            type: 'carousel',
            perView: parseInt(monal_typeId),
            dragDistance: false,
            loop: true,
            breakpoints: ({
                600: {
                    perView: 1.2
                },
                800: {
                    perView: 2.2
                },
            })
        });
        glide.mount();
    }
}

// Search Open
function monal_searchshow() {
    const show = document.getElementById('search-show');
    const field = document.getElementById('search-input');
    show.classList.add('search-trans');
    field.focus();
    show.classList.add('focustrap');
    trap();
}

function monal_searchremove() {
    const show = document.getElementById('search-show');
    const searchbtn = document.getElementById('search-open');
    show.classList.remove('search-trans');
    show.classList.remove('focustrap');
    searchbtn.focus();
}

// Hamburger Animation
function monal_hamburger(e) {
    const closeMenu = document.getElementById('close-menu');
    const menutrapper = document.querySelector('.menu-container');
    closeMenu.classList.add('visible');
    closeMenu.focus();
    menutrapper.classList.add('focustrap');
    trap();
}

function menu_close() {
    const closeMenu = document.getElementById('close-menu');
    const getMenu = document.getElementById('site-navigation');
    const hamburgerMenu = document.getElementById('hamburger-menu');
    const menutrapper = document.querySelector('.menu-container');
    menutrapper.classList.remove('focustrap');
    getMenu.classList.remove('toggled');
    closeMenu.classList.remove('visible');
    hamburgerMenu.focus();
}

// AJAX FUNCTION CALL JS
jQuery(document).ready(function ($) {
    monal_revealPosts();
    var btnclass = $('.monal-load-more');
    var that = jQuery(this);
    //find scroll position
    if (!btnclass.length == 0) {
        $(window).scroll(function () {

            var page = btnclass.data('page');
            var newPage = page + 1;
            var ajaxurl = btnclass.data('url');
            var category = btnclass.data('category');
            var pagetype = btnclass.data('pagetype');
            //check
            if ($(window).scrollTop() >= $(document).height() - $(window).height() * 1.1) {
                if (!btnclass.hasClass('loading')) {
                    btnclass.addClass('loading').find('.text').slideUp(320);
                    btnclass.find('.icon-spinner').addClass('spin');
                    //ajax call

                    if (pagetype == 'home') {
                        jQuery.ajax({
                            url: ajaxurl,
                            type: 'post',
                            data: {
                                page: page,
                                action: 'monal_load_more_home',
                                category: category
                            },
                            error: function (response) {
                                console.log(response);
                            },
                            success: function (response) {

                                if (response) {
                                    setTimeout(() => {
                                        btnclass.data('page', newPage);
                                        jQuery('.monal-posts-container').append(response);

                                        btnclass.removeClass('loading').find('.text').slideDown(
                                            320);
                                        btnclass.find('.icon-spinner').removeClass('spin');
                                        monal_revealPosts();
                                    }, 800);
                                } else {
                                    setTimeout(() => {
                                        jQuery('.monal-posts-container').append('<div class="custcol-12 no-more"> No more Posts To Load.</div>');
                                        btnclass.remove();
                                    }, 800);
                                }
                            }
                        });
                    } else if (pagetype == 'singlepage') {
                        jQuery.ajax({
                            url: ajaxurl,
                            type: 'post',
                            data: {
                                page: page,
                                action: 'monal_load_more',
                                category: category
                            },
                            error: function (response) {
                                console.log(response);
                            },
                            success: function (response) {
                                if (response) {
                                    setTimeout(() => {
                                        btnclass.data('page', newPage);
                                        jQuery('.monal-posts-container').append(response);

                                        btnclass.removeClass('loading').find('.text').slideDown(
                                            320);
                                        btnclass.find('.icon-spinner').removeClass('spin');
                                        monal_revealPosts();
                                    }, 800);
                                } else {
                                    setTimeout(() => {
                                        jQuery('.monal-posts-container').append('<div class="custcol-12 no-more"> No more Posts To Load.</div>');
                                        btnclass.remove();
                                    }, 800);
                                }

                            }
                        });
                    }
                }
            }
        });

    }
    function monal_revealPosts() {
        var posts = jQuery('.glamour-flex:not(.reveal)');
        var postsSingle = jQuery('.slider-gridcont:not(.reveal)');
        var i = 0;
        if (!posts.length == 0) {
            setInterval(function () {
                if (i >= posts.length) return false;
                var el = posts[i];
                jQuery(el).addClass('reveal');
                i++;
            }, 80);
        } else if (!postsSingle.length == 0) {
            setInterval(function () {
                if (i >= postsSingle.length) return false;
                var el = postsSingle[i];
                jQuery(el).addClass('reveal');
                i++;
            }, 80);
        }
    }
});




////// Ajax Load By Clicking Button 
jQuery(document).on('click', '.monal-load-more-home:not(.loading)', function () {
    monal_revealPosts();
    var that = jQuery(this);
    var page = jQuery(this).data('page');
    var newPage = page + 1;
    var ajaxurl = jQuery(this).data('url');
    var pagetype = that.data('pagetype');
    that.addClass('loading').find('.text').slideUp(320);
    that.find('.icon-spinner').addClass('spin');

    if (pagetype == 'home') {
        jQuery.ajax({
            url: ajaxurl,
            type: 'post',
            data: {
                page: page,
                action: 'monal_load_more_home'
            },
            error: function (response) {
                console.log(response);
            },
            success: function (response) {

                setTimeout(() => {
                    that.data('page', newPage);
                    jQuery('.monal-posts-container').append(response);
                    that.removeClass('loading').find('.text').slideDown(320);
                    that.find('.icon-spinner').removeClass('spin');
                    monal_revealPosts();
                    console.log(newPage);
                }, 1000);
            }
        });
    } else if (pagetype == 'singlepage') {
        jQuery.ajax({
            url: ajaxurl,
            type: 'post',
            data: {
                page: page,
                action: 'monal_load_more'
            },
            error: function (response) {
                console.log(response);
            },
            success: function (response) {

                setTimeout(() => {
                    that.data('page', newPage);
                    jQuery('.monal-posts-container').append(response);
                    that.removeClass('loading').find('.text').slideDown(320);
                    that.find('.icon-spinner').removeClass('spin');
                    monal_revealPosts();
                    console.log(newPage);
                }, 1000);
            }
        });
    }


    // Helper Functions
    function monal_revealPosts() {
        var posts = jQuery('.slider-gridcont:not(.reveal)');
        var i = 0;
        setInterval(function () {
            if (i >= posts.length) return false;
            var el = posts[i];
            jQuery(el).addClass('reveal');
            i++;
        }, 200);
    }
});



// Focus Trapping Function 

function trap() {
    const focusableElements =
        'button, [href], input:not([type=hidden]), select, textarea, [tabindex]:not([tabindex="-1"])';
    const modal = document.querySelector('.focustrap'); // select the modal by it's class

    if (modal) {
        const firstFocusableElement = modal.querySelectorAll(focusableElements)[0]; // get first element to be focused inside modal
        const focusableContent = modal.querySelectorAll(focusableElements);
        const lastFocusableElement = focusableContent[focusableContent.length - 1]; // get last element to be focused inside modal


        document.addEventListener('keydown', function (e) {
            let isTabPressed = e.key === 'Tab' || e.keyCode === 9;

            if (!isTabPressed) {
                return;
            }

            if (e.shiftKey) { // if shift key pressed for shift + tab combination
                if (document.activeElement === firstFocusableElement) {
                    lastFocusableElement.focus(); // add focus for the last focusable element
                    e.preventDefault();
                }
            } else { // if tab key is pressed
                if (document.activeElement === lastFocusableElement) { // if focused has reached to last focusable element then focus first focusable element after pressing tab
                    firstFocusableElement.focus(); // add focus for the first focusable element
                    e.preventDefault();
                }
            }
        });

        firstFocusableElement.focus();
    }

}