<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package monal
 */

get_header();
?>
<div class="page-description">
    <?php bloginfo( 'description' ) ?>
</div>
<main id="primary" class="site-main container" style="margin-top:20px;">

    <div class="custholder">
        <div class="cust-bio-left">

            <?php
		if ( have_posts() ) :

			if ( is_home() && ! is_front_page() ) :
				?>
            <header>
                <h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
            </header>
            <?php
			endif;

			/* Start the Loop */
			while ( have_posts() ) :
				the_post();

				/*
				 * Include the Post-Type-specific template for the content.
				 * If you want to override this in a child theme, then include a file
				 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
				 */
				get_template_part( 'template-parts/content', get_post_type() );


			endwhile;

			?>
            <div class=" page-nav">
                <?php
		the_posts_pagination( array(
			'mid_size'  => 2,
			'prev_text' => __( 'Previous', 'monal' ),
			'next_text' => __( 'Next', 'monal' ),
		) );
		?>

            </div>
            <?php

		else :

			get_template_part( 'template-parts/content', 'none' );

		endif;
		?>
        </div>

        <?php get_sidebar() ?>
    </div>



</main><!-- #main -->

<?php
get_footer();