<?php
/**
 * monal functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package monal
 */


$monal_theme_ob = wp_get_theme();
$monal_ver      = $monal_theme_ob -> get( 'Version' );
define( 'MONAL_VERSION',$monal_ver);

if ( ! function_exists( 'monal_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function monal_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on monal, use a find and replace
		 * to change 'monal' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'monal', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'menu-1' => esc_html__( 'Primary', 'monal' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

			/// Editor THeme Support 
			function monal_add_editor_styles() {
				add_editor_style( 'custom-editor-style.css' );
			}
			add_action( 'admin_init', 'monal_add_editor_styles' );
		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'monal_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function monal_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'monal_content_width', 640 );
}
add_action( 'after_setup_theme', 'monal_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function monal_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'monal' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'monal' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span class="title">',
			'after_title'   => '</span></h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 1', 'monal' ),
			'id'            => 'footer-1',
			'description'   => esc_html__( 'Add Footer widgets here.', 'monal' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span class="title">',
			'after_title'   => '</span></h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 2', 'monal' ),
			'id'            => 'footer-2',
			'description'   => esc_html__( 'Add Footer widgets here.', 'monal' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span class="title">',
			'after_title'   => '</span></h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 3', 'monal' ),
			'id'            => 'footer-3',
			'description'   => esc_html__( 'Add Footer widgets here.', 'monal' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span class="title">',
			'after_title'   => '</span></h2>',
		)
	);
}
add_action( 'widgets_init', 'monal_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function monal_scripts() {

	wp_enqueue_style( 'monal-style', get_stylesheet_uri(), array(), MONAL_VERSION );

	wp_enqueue_style( 'monal-style-custom', get_template_directory_uri() . '/css/styles.css' );

	wp_enqueue_style( 'monal-font-style', 'https://fonts.googleapis.com/css2?family=Quicksand:wght@400;600;700&display=swap' );

	wp_enqueue_style( 'monal-fontawesome-icons', get_template_directory_uri() . '/css/font-awesome/css/font-awesome.min.css' );

	wp_style_add_data( 'monal-style', 'rtl', 'replace' );
	
	wp_enqueue_script( 'monal-glide-js', get_template_directory_uri() . '/js/glide.min.js' );

	wp_enqueue_script( 'monal-script-normal', get_template_directory_uri() . '/js/app.js',  array(), '1.0.2' , true);
	
	wp_enqueue_script( 'monal-navigation', get_template_directory_uri() . '/js/navigation.js', array('jquery'), MONAL_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'monal_scripts' );

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

// AJAX FUNCTION
require get_template_directory() . '/template-parts/ajax-function.php';


/////// Recoommmend Plugins Function 
require_once dirname( __FILE__ ) . '/inc/class-tgm-plugin-activation.php';
require_once dirname( __FILE__ ) . '/inc/required_plugins.php';


/// Widgets 
require_once dirname( __FILE__ ) . '/custom-widgets/widget-recent.php';
require_once dirname( __FILE__ ) . '/custom-widgets/widget-slider.php';
require_once dirname( __FILE__ ) . '/custom-widgets/widget-news-design.php';
require_once dirname( __FILE__ ) . '/custom-widgets/widget-news-design-2.php';
require_once dirname( __FILE__ ) . '/custom-widgets/widget-grid.php';
require_once dirname( __FILE__ ) . '/custom-widgets/widget-asym.php';
require_once dirname( __FILE__ ) . '/custom-widgets/widget-ajax.php';

/// The Breacdcrumb
if (!function_exists('monal_breadcrumb')) :
function monal_breadcrumb() {
	
	if (!is_home()) {
		echo '<div class="breadcrumb"><a href="';
		echo esc_url(home_url());
		echo '">';
		echo "Home";
		echo "</a> » ";
		if (is_category() || is_single()) {			
			if (is_single()) {
				the_category( ' » ' );
				echo " » ";
				echo '<span class="current-link">';
				echo the_title();
				echo '</span>';
			}
			if (is_category()) {
				echo '<span class="current-link">';
				the_category( ' » ' );
				echo '</span>';
			}
		} elseif (is_page()) {
			echo '<span class="current-link">';
			echo the_title();
			echo '</span>';
		}
		elseif (is_author()) {
			echo '<span class="current-link">';
			the_author();
			echo '</span>';
		}
		elseif (is_tag()) {
			echo '<span class="current-link">';
			echo 'Tag';
			echo '</span>';
		}
		
		echo "</div>";
	}
}
endif;

//Exclude pages from WordPress Search
if (!is_admin()) {
	function monal_search_filter($query) {
	if ($query->is_search) {
	$query->set('post_type', 'post');
	}
	return $query;
	}
	add_filter('pre_get_posts','monal_search_filter');
	}