<?php
// Register and load the widget
function monal_load_widget_design_2() {
    register_widget( 'monal_widget_design_2' );
}
add_action( 'widgets_init', 'monal_load_widget_design_2' );
//  CUSTOM WIDGET ----------------------------------------------------------------------------------------------------------------------------================================================ 
// Creating the widget 
class monal_widget_design_2 extends WP_Widget {
    
    //Setup The Widget Name, Description, etc ...
function __construct() { //gets executed immediately at the beginning

parent::__construct(
'monal_widget_design_2', 
__('Monal Widget Design 2', 'monal'), 
array( 'description' => __( 'Monal Design 2', 'monal' )) 
);
}

// Creating widget front-end


public function widget( $args, $instance ) {

    $categories = get_the_category();
    $dorecent_category = ( !empty($instance[ 'dorecent_category' ])) ? $instance['dorecent_category'] : '';
    $dorecent_order = ( !empty($instance[ 'dorecent_order' ])) ? $instance['dorecent_order'] : esc_html__( 'DESC', 'monal' ) ;
    $title = ( !empty($instance[ 'title' ])) ? $instance['title'] : '' ;
    echo $args['before_widget'];
?>

<?php if ($title) :?>
<h2 class="widget-title"><span class="title"><?php echo esc_html($title); ?></span></h2>
<?php endif;?>
<div class="glamholder">
    <?php 
    $q_args = array(
        'post_type' => 'post',
        'posts_per_page' => 4,
        'post_status' => 'publish',
        'order_by' => 'date',
        'order' => esc_attr($dorecent_order),
        'category_name' => esc_attr($dorecent_category),
    );
    $bio = new WP_Query( $q_args );
    $post_count = 1;
    if( $bio->have_posts() ) {
        while( $bio->have_posts() ) {
            $bio->the_post();
            if($post_count == 1){
    ?>
    <div class="custcol-12">
        <div class="monal-card-holder" style="margin-bottom:10px;">
            <div class="monal-card-image">
                <?php 
                    if(get_the_post_thumbnail_url()){
                        the_post_thumbnail();
                    }
                ?>
                <div class="monal-category prime-text prime-color">
                    <?php 
                    $categories = get_the_category();
                    if ( ! empty( $categories ) ) {
                        echo esc_html( $categories[0]->name );   
                    }
                    ?>
                </div>
            </div>
            <h2 class="monal-card-heading"> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h2>
            <p class="monal-card-time">
                <span><i class="fa fa-user prime-color-text"></i> <?php the_author(); ?></span>
                <span><i class="fa fa-calendar prime-color-text"></i> <?php echo get_the_date('M j, Y')?> </span>
            </p>
            <div class="monal-card-description">
                <?php the_excerpt(); ?>
            </div>
        </div>
    </div>
    <!-- Another Column Start -->
    <div class="custcol-12">
        <?php
        }
        if ($post_count>1) 
        {
        ?>
        <div class="custholder">
            <div class="custcol-2">
                <a href="<?php the_permalink(); ?>" class="comp-container-height">
                    <?php 
                    if(get_the_post_thumbnail_url()){
                        the_post_thumbnail('medium');
                    }
                    ?>
                </a>
            </div>
            <div class="custcol-5">
                <div class="comp-side1-right-info">
                    <a href="<?php the_permalink() ?>">
                        <h3><?php the_title() ?></h3>
                    </a>
                    <p class="monal-meta">
                        <span><i class="fa fa-user prime-color-text"></i> <?php the_author(); ?></span>
                        <span><i class="fa fa-calendar prime-color-text"></i> <?php echo get_the_date('M j, Y')?>
                        </span>
                    </p>
                </div>
            </div>
        </div>
        <?php    
                        }
            $post_count++;
                }
            }                       
            ?>
    </div>
    <!-- End Another Column -->
</div>
<?php
		echo $args['after_widget'];
}
// Widget Backend 
public function form( $instance ) {

    $dorecent_category = ( !empty($instance[ 'dorecent_category' ])) ? $instance[ 'dorecent_category' ] : '' ;
    $dorecent_order = ( !empty($instance[ 'dorecent_order' ])) ? $instance[ 'dorecent_order' ] : esc_html__( 'DESC', 'monal' ) ;
    $title = ( !empty($instance[ 'title' ])) ? $instance[ 'title' ] : '' ;
?>

<p>
    <label
        for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'The Title of the Widget', 'monal' ); ?></label>

    <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
        name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
</p>
<p>
    <label
        for="<?php echo $this->get_field_id( 'dorecent_order' ); ?>"><?php esc_html_e( 'Ordering: Either Ascending or Desending order', 'monal' ); ?></label>
    <select class="widefat" id="<?php echo $this->get_field_id( 'dorecent_order' ); ?>"
        name="<?php echo $this->get_field_name( 'dorecent_order' ); ?>"
        value="<?php echo esc_attr( $dorecent_order ); ?>">
        <option value="ASC" <?php echo ($dorecent_order=='ASC')?'selected':''; ?>>
            <?php esc_html_e( 'Ascending Order', 'monal' ) ?>
        </option>
        <option value="DESC" <?php echo ($dorecent_order=='DESC')?'selected':''; ?>>
            <?php esc_html_e( 'Descending Order', 'monal' ) ?>
        </option>
    </select>
</p>
<p>
    <label
        for="<?php echo $this->get_field_id( 'dorecent_category' ); ?>"><?php  esc_html_e( 'Select the category:', 'monal' ); ?></label>
    <select class="widefat" id="<?php echo $this->get_field_id( 'dorecent_category' ); ?>"
        name="<?php echo $this->get_field_name( 'dorecent_category' ); ?>">
        <?php  
        $ag = array(
            'post_type' => 'post',
        );
        $all_categories = get_categories( $ag );
        foreach ($all_categories as $cat) {    
            ?>
        <option value="<?php echo $cat->slug;?>" <?php echo ($dorecent_category == $cat->slug)?'selected':''; ?>>
            <?php echo $cat->name;?></option>
        <?php
        }
?>
    </select>
</p>
<?php 
}

    // Updating widget replacing old instances with new
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['dorecent_category'] = ( ! empty( $new_instance['dorecent_category'] ) ) ? sanitize_text_field( $new_instance['dorecent_category'] ) : '';
        $instance['dorecent_order'] = ( ! empty( $new_instance['dorecent_order'] ) ) ? sanitize_text_field( $new_instance['dorecent_order'] ) : '';
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
        return $instance;
    }
} // Class monal_widget ends here
?>