<?php
function monal_load_asym_widget() {
    register_widget( 'monal_asym_widget' );
}
add_action( 'widgets_init', 'monal_load_asym_widget' );
// Creating the widget 
class monal_asym_widget extends WP_Widget {
    
function __construct() { //gets executed immediately at the beginning

    parent::__construct(
    'monal_asym_widget', 
    __('Monal ASYM Design', 'monal'), 
    array( 'description' => __( 'Monal Asym Details', 'monal' ))
    );
}

// Creating widget front-end

public function widget( $args, $instance ) {
    
        $dorecent_category = ( !empty($instance[ 'dorecent_category' ])) ? $instance['dorecent_category'] : '' ;
        $dorecent_order = ( !empty($instance[ 'dorecent_order' ])) ? $instance['dorecent_order'] : esc_html__( 'DESC', 'monal' );
        $dorecent_number = ( !empty($instance[ 'dorecent_number' ])) ? $instance['dorecent_number'] : '6' ;
        $title = ( !empty($instance[ 'title' ])) ? $instance['title'] : '' ;
        echo $args['before_widget'];
?>
<?php if ($title) :?>
<h2 class="widget-title"><span class="title"><?php echo esc_html($title); ?></span></h2>
<?php endif;?>
<div class="glamholder">
    <?php             
        $q_args = array(
            'post_type' => 'post',
            'posts_per_page' => absint($dorecent_number),
            'post_status' => 'publish',
            'order_by' => 'date',
            'order' => esc_attr($dorecent_order),
            'category_name' => esc_attr($dorecent_category),
        );
        ?>
    <?php 
        $asyms = new WP_Query( $q_args );      
        if( $asyms->have_posts() ) {
            while( $asyms->have_posts() ) {
                $asyms->the_post();
        ?>
    <div class="custcol-6">
        <div class="glamour-flex">

            <a class="glam-image" href="<?php the_permalink(); ?>">

                <?php
                if(get_the_post_thumbnail_url()){
                ?>
                <?php the_post_thumbnail('medium'); ?>
                <?php
                }
                ?>

            </a>

            <div class="glam-details">
                <?php 
                $categories = get_the_category();
                if ( ! empty( $categories ) ) {
                ?>
                <p class="glam-category prime-color-text">
                    <?php echo esc_html( $categories[0]->name );  ?>
                </p>
                <?php                                        
                }
                ?>
                <a href="<?php the_permalink(); ?>">
                    <h2> <?php the_title(); ?> </h2>
                </a>
                <span> <i class="fa fa-user prime-color-text"></i> <?php the_author(); ?> <i
                        class="fa fa-calendar prime-color-text"></i>
                    <?php echo get_the_date('M j, Y')?>
                </span><br>
                <a href="<?php the_permalink();?>">
                    <div class="button-read prime-color prime-text"> <?php esc_html_e( 'Read More', 'monal' )?> </div>
                </a>
            </div>
        </div>
    </div>
    <?php
            }
        }
    ?>
</div>
<?php
		echo $args['after_widget'];
}
// Widget Backend 
public function form( $instance ) {
    $dorecent_category = ( !empty($instance[ 'dorecent_category' ])) ? $instance[ 'dorecent_category' ] : '' ;
    $dorecent_order = ( !empty($instance[ 'dorecent_order' ])) ? $instance[ 'dorecent_order' ] : esc_html__( 'DESC', 'monal' ) ;
    $title = ( !empty($instance[ 'title' ])) ? $instance[ 'title' ] : '' ;
    $dorecent_number = ( !empty($instance[ 'dorecent_number' ])) ? $instance['dorecent_number'] : '6' ;
?>

<p>
    <label
        for="<?php echo $this->get_field_id( 'title' ); ?>"><?php  esc_html_e( 'The Title of the Widget', 'monal' ); ?></label>

    <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
        name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
</p>
<p>
    <label
        for="<?php echo $this->get_field_id( 'dorecent_number' ); ?>"><?php  esc_html_e( 'Number of posts to show ', 'monal' ); ?></label>
    <input class="widefat" type="number" id="<?php echo $this->get_field_id( 'dorecent_number' ); ?>"
        name="<?php echo $this->get_field_name( 'dorecent_number' ); ?>" type="text"
        value="<?php echo esc_attr( $dorecent_number ); ?>" />
</p>
<p>
    <label
        for="<?php echo $this->get_field_id( 'dorecent_order' ); ?>"><?php  esc_html_e( 'Ordering: Either Ascending or Desending order', 'monal' ); ?></label>
    <select class="widefat" id="<?php echo $this->get_field_id( 'dorecent_order' ); ?>"
        name="<?php echo $this->get_field_name( 'dorecent_order' ); ?>"
        value="<?php echo esc_attr( $dorecent_order ); ?>">
        <option value="ASC" <?php echo ($dorecent_order=='ASC')?'selected':''; ?>>
            <?php  esc_html_e( 'Ascending Order', 'monal' ) ?>
        </option>
        <option value="DESC" <?php echo ($dorecent_order=='DESC')?'selected':''; ?>>
            <?php  esc_html_e( 'Descending Order', 'monal' ) ?>
        </option>
    </select>
</p>
<p>
    <label
        for="<?php echo $this->get_field_id( 'dorecent_category' ); ?>"><?php   esc_html_e( 'Category:', 'monal' ); ?></label>
    <select class="widefat" id="<?php echo $this->get_field_id( 'dorecent_category' ); ?>"
        name="<?php echo $this->get_field_name( 'dorecent_category' ); ?>">
        <option value="" selected>
            <?php esc_html_e( 'Select A Category', 'monal' );?></option>
        <?php  
                $ag = array(
                    'post_type' => 'post',
                );
                $all_categories = get_categories( $ag );
                foreach ($all_categories as $cat) {    
                    ?>
        <option value="<?php echo $cat->slug;?>" <?php echo ($dorecent_category == $cat->slug)?'selected':''; ?>>
            <?php echo $cat->name;?></option>
        <?php
                }
?>
    </select>
</p>

<?php 
}
    //  CUSTOM WIDGET ----------------------------------------------------------------------------------------------------------------------------================================================
// Updating widget replacing old instances with new
public function update( $new_instance, $old_instance ) {
$instance = array();
$instance['dorecent_category'] = ( ! empty( $new_instance['dorecent_category'] ) ) ? sanitize_text_field( $new_instance['dorecent_category'] ) : '';
$instance['dorecent_number'] = ( ! empty( $new_instance['dorecent_number'] ) ) ? absint(strip_tags( $new_instance['dorecent_number'] )) : '';
$instance['dorecent_order'] = ( ! empty( $new_instance['dorecent_order'] ) ) ? sanitize_text_field( $new_instance['dorecent_order'] ) : '';
$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
return $instance;
}
} // Class monal_widget ends here
?>