<?php
// Register and load the widget
function monal_ajax_widget() {
    register_widget( 'monal_ajax_register_widget' );
}
add_action( 'widgets_init', 'monal_ajax_widget' );
// Creating the widget 
class monal_ajax_register_widget extends WP_Widget {
    
function __construct() { 

parent::__construct(

'monal_ajax_register_widget', 
__('Monal Ajax Widget Details', 'monal'), 
array( 'description' => __( ' Post Details with Ajax Loading', 'monal' )) 
);
}

// Creating widget front-end

public function widget( $args, $instance ) {
        $dorecent_category = ( !empty($instance[ 'dorecent_category' ])) ? $instance['dorecent_category'] : '' ;
        $dorecent_order = ( !empty($instance[ 'dorecent_order' ])) ? $instance['dorecent_order'] : esc_html__( 'DESC', 'monal' ) ;
        $title = ( !empty($instance[ 'title' ])) ? $instance['title'] : '' ;
        echo $args['before_widget'];
    ?>
<div class="glamour-sidebar-blog-container">
    <?php if ($title) :?>
    <h2 class="widget-title"><span class="title"><?php echo esc_html($title); ?></span></h2>
    <?php endif;?>
    <div class="glamholder monal-posts-container ">
        <?php             
            $monal_args = array(
                'post_type' => 'post',
                'posts_per_page' => get_option( 'posts_per_page' ),
                'order_by' => 'date',
                'post_status' => 'publish',
                'order' => esc_attr($dorecent_order),
                'category_name' => esc_attr($dorecent_category)
            );
            $bio = new WP_Query( $monal_args );
                if( $bio->have_posts() ) {
                    while( $bio->have_posts() ) {
                        $bio->the_post();
				?>
        <div class="custcol-4">
            <div class="slider-gridcont post-margin-cust reveal">
                <div class="slider-celeb">
                    <a href="<?php the_permalink(); ?>">
                        <div class="slider-container image-height">
                            <?php 
                                if(get_the_post_thumbnail_url()){
                                    the_post_thumbnail( 'medium' );
                                }
                            ?>
                            <div class="slider-desc">
                                <h2> <?php the_title() ?> </h2>
                                <small> <?php esc_html_e( 'By: ', 'monal' )?> <?php the_author() ?> <i
                                        class="fa fa-calendar"></i><?php echo get_the_date('M j, Y')?></small>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
        <?php
                }
            }
            ?>
    </div>
</div>
<div class="center">
    <button style="" class="btn monal-load-more" data-page="1" data-url="<?php echo admin_url('admin-ajax.php'); ?>"
        data-pagetype="singlepage" data-category="<?php echo esc_attr($dorecent_category) ?>"><i
            class="fa fa-spinner"></i> <span class="text">
            <?php esc_html_e( 'Load More', 'monal' )?> </span>
    </button>
</div>
<?php   
		echo $args['after_widget'];
}

// Widget Backend 
public function form( $instance ) {
    $dorecent_category = ( !empty($instance[ 'dorecent_category' ])) ? $instance[ 'dorecent_category' ] : '' ;
    $dorecent_order = ( !empty($instance[ 'dorecent_order' ])) ? $instance[ 'dorecent_order' ] : esc_html__( 'DESC', 'monal' ); ;
    $title = ( !empty($instance[ 'title' ])) ? $instance[ 'title' ] : '' ;
?>

<p>
    <label
        for="<?php echo $this->get_field_id( 'title' ); ?>"><?php  esc_html_e( 'The Title of the Widget', 'monal' ); ?></label>

    <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
        name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
</p>
<p>
    <label
        for="<?php echo $this->get_field_id( 'dorecent_order' ); ?>"><?php  esc_html_e( 'Ordering: Either Ascending or Desending order', 'monal' ); ?></label>
    <select class="widefat" id="<?php echo $this->get_field_id( 'dorecent_order' ); ?>"
        name="<?php echo $this->get_field_name( 'dorecent_order' ); ?>"
        value="<?php echo esc_attr( $dorecent_order ); ?>">
        <option value="ASC" <?php echo ($dorecent_order=='ASC')?'selected':''; ?>>
            <?php esc_html_e( 'Ascending Order', 'monal' ) ?>
        </option>
        <option value="DESC" <?php echo ($dorecent_order=='DESC')?'selected':''; ?>>
            <?php  esc_html_e( 'Descending Order', 'monal' ) ?> </option>
    </select>
</p>
<p>
    <label
        for="<?php echo $this->get_field_id( 'dorecent_category' ); ?>"><?php esc_html_e( 'Category:', 'monal' ); ?></label>
    <select class="widefat" id="<?php echo $this->get_field_id( 'dorecent_category' ); ?>"
        name="<?php echo $this->get_field_name( 'dorecent_category' ); ?>">
        <option value="" selected>
            <?php echo esc_html_e( 'Select A Category', 'monal' );?></option>
        <?php  
        $ag = array(
            'post_type' => 'post',
        );
        $all_categories = get_categories( $ag );
        foreach ($all_categories as $cat) {    
            ?>
        <option value="<?php echo $cat->slug;?>" <?php echo ($dorecent_category == $cat->slug) ? 'selected':''; ?>>
            <?php echo $cat->name;?></option>
        <?php
                }
?>
    </select>
</p>
<?php 
}
// Updating widget replacing old instances with new
    public function update( $new_instance, $old_instance ) {
    $instance = array();
    $instance['dorecent_category'] = ( ! empty( $new_instance['dorecent_category'] ) ) ? sanitize_text_field( $new_instance['dorecent_category'] ) : '';
    $instance['dorecent_order'] = ( ! empty( $new_instance['dorecent_order'] ) ) ? sanitize_text_field( $new_instance['dorecent_order'] ) : '';
    $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
    return $instance;
    }
} // Class monal_widget ends here
?>