<?php
    $wp_customize->add_panel('theme_options_global',array(
		'title'=>'Theme Options',
		'priority'=> 12,
    ));

    ///// ==================
    ///// HEADER SECTION 
    ///// ==================

    $wp_customize->add_section('header_section', array(
        'title'   => __('Header Options', 'monal'),
        'description' => sprintf(__('Options for header Section','monal')),
        'priority'    => 131,
        'panel'=>'theme_options_global',
    ));

    // Header Layout
    $wp_customize->add_setting( 'navbar_select', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'monal_sanitize_select',
        'default' => 'box',
    ));

    $wp_customize->add_control( 'navbar_select', array(
        'type' => 'select',
        'section' => 'header_section',
        'label' => __( 'Select Navbar Types', 'monal' ),
        'description' => __( 'You can choose from two navbars', 'monal' ),
        'choices' => array(
            'fullwidth' => __( 'Full Width Layout', 'monal' ),
            'box' => __( 'Box Layout', 'monal' ),
        ),
    ));


    // Header Background Color
    $wp_customize->add_setting( 'header_background',
        array(
        'default'           => '#ffffff',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control( 
        new WP_Customize_Color_Control( 
        $wp_customize, 'header_background', 
        array(
            'label'      => esc_html__( 'Header Background Color', 'monal' ),
            'section'    => 'header_section',
            'settings'   => 'header_background',
            'priority'   => 100,
        )) 
    );
    // Header Text Color
    $wp_customize->add_setting( 'header_text_color',
        array(
        'default'           => '#000000',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control( 
        new WP_Customize_Color_Control( 
        $wp_customize, 'header_text_color', 
        array(
            'label'      => esc_html__( 'Header Text Color', 'monal' ),
            'section'    => 'header_section',
            'settings'   => 'header_text_color',
            'priority'   => 100,
        )) 
    );

    // Header Dropdown Hover Background
    $wp_customize->add_setting( 'dropdown_background',
        array(
        'default'           => '#f3f3f3',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control( 
        new WP_Customize_Color_Control( 
        $wp_customize, 'dropdown_background', 
        array(
            'label'      => esc_html__( 'Navigation Dropdown Hover Background', 'monal' ),
            'section'    => 'header_section',
            'settings'   => 'dropdown_background',
            'priority'   => 100,
        )) 
    );

    // Header Dropdown Text
    $wp_customize->add_setting( 'dropdown_color',
        array(
        'default'           => '#000000',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control( 
        new WP_Customize_Color_Control( 
        $wp_customize, 'dropdown_color', 
        array(
            'label'      => esc_html__( 'Navigation Dropdown Hover Color', 'monal' ),
            'section'    => 'header_section',
            'settings'   => 'dropdown_color',
            'priority'   => 100,
        )) 
    );
    
    ///// ==================
    ///// END HEADER SECTION 
    ///// ==================



    ///// SIDEBAR 

    $wp_customize->add_section('sidebar_section', array(
        'title'   => __('Sidebar Options', 'monal'),
        'description' => sprintf(__('Options for Sidebar Section','monal')),
        'priority'    => 131,
        'panel'=>'theme_options_global',
    ));
    // Sidebar Single Post
    $wp_customize->add_setting('enable_sidebar_option_single_post',
    array(
        'default'           => 1,
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'monal_sanitize_checkbox',
    )
    );
    $wp_customize->add_control('enable_sidebar_option_single_post',
    array(
        'label'    => esc_html__('Enable Sidebar on Single Post', 'monal'),
        'section'  => 'sidebar_section',
        'type'     => 'checkbox',
        'priority' => 150,
    )
    );

    // Sidebar Archive Page
    $wp_customize->add_setting('enable_sidebar_option_archive',
    array(
        'default'           => 1,
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'monal_sanitize_checkbox',
    )
    );
    $wp_customize->add_control('enable_sidebar_option_archive',
    array(
        'label'    => esc_html__('Enable Sidebar on Archive Page', 'monal'),
        'section'  => 'sidebar_section',
        'type'     => 'checkbox',
        'priority' => 150,
    )
    );

    // Sidebar Archive Page
    $wp_customize->add_setting('enable_sidebar_option_single_page',
    array(
        'default'           => 1,
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'monal_sanitize_checkbox',
    )
    );
    $wp_customize->add_control('enable_sidebar_option_single_page',
    array(
        'label'    => esc_html__('Enable Sidebar on Page Post', 'monal'),
        'section'  => 'sidebar_section',
        'type'     => 'checkbox',
        'priority' => 150,
    )
    );
    ///// ==============
    ///// FOOTER SECTION 
    ///// ==============

    $wp_customize->add_section('footer_section', array(
        'title'   => __('Footer Options', 'monal'),
        'description' => sprintf(__('Options for footer Section','monal')),
        'priority'    => 131,
        'panel'=>'theme_options_global',
    ));
    
    // Copyright Text 
    $wp_customize->add_setting('copyright_text', array(
        'default' => __('© 2020 - Wordpress Theme : Monal', 'monal'),
        'type' => 'theme_mod',
        'sanitize_callback' => 'sanitize_text_field',
        ));
        
        $wp_customize->add_control('copyright_text', array(
        'label' => __('Text for Copyright Section', 'monal'),
        'section' => 'footer_section',
        'priority' => 7
        ));
        
	// Copyright Background.
    $wp_customize->add_setting( 'copyright_background',
        array(
        'default'           => '#000000',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
        )
        );
	$wp_customize->add_control( 
		new WP_Customize_Color_Control( 
		$wp_customize, 'copyright_background', 
		array(
			'label'      => esc_html__( 'Copyright Background', 'monal' ),
			'section'    => 'footer_section',
			'settings'   => 'copyright_background',
			'priority'   => 8,
		) ) 
    );

    // Copyright Display
    $wp_customize->add_setting( 'copyright_display', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'monal_sanitize_select',
        'default' => 'show',
    ));

    $wp_customize->add_control( 'copyright_display', array(
        'type' => 'select',
        'section' => 'footer_section',
        'label' => __( 'Display Copyright Section', 'monal' ),
        'description' => __( 'Options', 'monal' ),
        'choices' => array(
            'show' => __( 'Show', 'monal' ),
            'hide' => __( 'Hide', 'monal' ),
        ),
    ));


    // Footer Background.
    $wp_customize->add_setting( 'footer_background_color',
        array(
        'default'           => '#484848',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
        )
        );
	$wp_customize->add_control( 
		new WP_Customize_Color_Control( 
		$wp_customize, 'footer_background_color', 
		array(
			'label'      => esc_html__( 'Footer Background', 'monal' ),
			'section'    => 'footer_section',
			'settings'   => 'footer_background_color',
			'priority'   => 8,
		) ) 
    );
    