<?php
    $wp_customize->add_panel('general_options_global',array(
		'title'=>'General Settings',
		'priority'=> 12,
    ));

    ///// ==================
    ///// TYPOGRAPHY SECTION 
    ///// ==================
    $wp_customize->add_section('font_sizes_all', array(
        'title' => __('Typography', 'monal'),
        'priority' => 10,
        'panel' => 'general_options_global'
        ));
        // Heading One
        $wp_customize->add_setting('heading_one_size', array(
            'default' => __('32', 'monal'),
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'monal_sanitize_positive_integer',
            ));
            
            $wp_customize->add_control('heading_one_size', array(
            'label' => __('Heading 1', 'monal'),
            'section' => 'font_sizes_all',
            'type' => 'number',
            'priority' => 7
            ));
            
        // Heading Two
            $wp_customize->add_setting('heading_two_size', array(
                'default' => __('24', 'monal'),
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'monal_sanitize_positive_integer',
                ));
            $wp_customize->add_control('heading_two_size', array(
                'label' => __('Heading 2', 'monal'),
                'section' => 'font_sizes_all',
                'type' => 'number',
                'priority' => 8
                )); 
    
                // Heading Three
            $wp_customize->add_setting('heading_three_size', array(
                'default' => __('20', 'monal'),
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'monal_sanitize_positive_integer',
                ));
            $wp_customize->add_control('heading_three_size', array(
                'label' => __('Heading 3', 'monal'),
                'section' => 'font_sizes_all',
                'type' => 'number',
                'priority' => 9
                )); 
    
                // Heading Two
            $wp_customize->add_setting('heading_four_size', array(
                'default' => __('18', 'monal'),
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'monal_sanitize_positive_integer',
                ));
            $wp_customize->add_control('heading_four_size', array(
                'label' => __('Heading 4', 'monal'),
                'section' => 'font_sizes_all',
                'type' => 'number',
                'priority' => 10
                )); 
        
        // P tag Size
        $wp_customize->add_setting('paragraph_size', array(
        'default' => __('16', 'monal'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'monal_sanitize_positive_integer',
        ));
        
        $wp_customize->add_control('paragraph_size', array(
        'label' => __('Paragraph Font Size', 'monal'),
        'section' => 'font_sizes_all',
        'type' => 'number',
        'priority' => 11
        ));
    
        // Meta             
            $wp_customize->add_setting('meta_size', array(
                'default' => __('14', 'monal'),
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'monal_sanitize_positive_integer',
                ));
                
            $wp_customize->add_control('meta_size', array(
                'label' => __('Meta Data', 'monal'),
                'section' => 'font_sizes_all',
                'type' => 'number',
                'priority' => 12
            ));
    

            ///// ==================
            ///// GLOBAL COLORS 
            ///// ==================
            $wp_customize->add_section('colorpicker',array(
                'title'=>__('Global Colors', 'monal'),
                'priority'=>10,
                'panel' => 'general_options_global'
                
            ));
        
            // Setting - primary_color.
        $wp_customize->add_setting( 'primary_color',
        array(
        'default'           => '#0bc615',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
        )
        );
            $wp_customize->add_control( 
                new WP_Customize_Color_Control( 
                $wp_customize, 'primary_color', 
                array(
                    'label'      => esc_html__( 'Primary Color', 'monal' ),
                    'section'    => 'colorpicker',
                    'settings'   => 'primary_color',
                    'priority'   => 100,
                ) ) 
            );
            
        
            $wp_customize->add_setting( 'text_inside_primary_color',
        array(
        'default'           => '#ffffff',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
        )
        );
            $wp_customize->add_control( 
                new WP_Customize_Color_Control( 
                $wp_customize, 'text_inside_primary_color', 
                array(
                    'label'      => esc_html__( 'Text Inside Primary Color', 'monal' ),
                    'section'    => 'colorpicker',
                    'settings'   => 'text_inside_primary_color',
                    'priority'   => 100,
                ) ) 
            );

            /// Body Color
            $wp_customize->add_setting( 'bodybg_color',
            array(
            'default'           => '#ffffff',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            )
            );
                $wp_customize->add_control( 
                    new WP_Customize_Color_Control( 
                    $wp_customize, 'bodybg_color', 
                    array(
                        'label'      => esc_html__( 'Background Color', 'monal' ),
                        'section'    => 'colorpicker',
                        'settings'   => 'bodybg_color',
                        'priority'   => 100,
                    ) ) 
                );
            
            
        
            
            